/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.treeview;

import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.mvc.MvcController;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.internal.IDiffNodeImpl;
import com.deltawalker.structure.internal.ui.treeview.TreeEdit;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.UIUtil;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.io.FileUtil;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.OS;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeController
extends MvcController {
    TreeEdit cellEdit;
    private boolean dragSelect;
    private int endNodeIx = 0;
    Set<IDiffNode> oldRange = new LinkedHashSet<IDiffNode>();
    private final Listener onKey = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: {
                    if (KeyUtil.hasKey((Event)event, (int)13)) {
                        TreeController.this.fireDefaultSelection();
                        return;
                    }
                    if (KeyUtil.hasMask((Event)event, (int)SWT.MOD1)) break;
                    TreeController.this.scrollSelect(event);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    };
    private final Listener onMouse = new Listener(){
        private boolean doubleClick;
        private IDiffNode expandNode = null;
        private IDiffNode oldHitNode = null;
        private int oldY = 0;

        public void handleEvent(Event event) {
            EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
            if (KeyUtil.hasMask((Event)event, (int)SWT.MOD1)) {
                enumSet.add(Modifier.CTRL);
            }
            if (KeyUtil.hasMask((Event)event, (int)SWT.MOD2)) {
                enumSet.add(Modifier.SHIFT);
            }
            Point point = new Point(event.x, event.y);
            switch (event.type) {
                case 3: {
                    this.doubleClick = false;
                    if (event.count > 1) {
                        this.doubleClick = true;
                        return;
                    }
                    TreeController.this.hideCellEdit();
                    this.expandNode = TreeController.this.hitTestExpandImage(point);
                    if (this.expandNode != null) {
                        if (OS.WIN) {
                            this.expandNode.setExpanded(!this.expandNode.isExpanded());
                            this.expandNode = null;
                        }
                        return;
                    }
                    IDiffNode iDiffNode = TreeController.this.view().hitTestNode(event.y);
                    if (event.button == 3) {
                        if (iDiffNode != null && !iDiffNode.isSelected()) {
                            iDiffNode.setSelected(true, enumSet.contains((Object)Modifier.CTRL));
                        }
                        TreeController.this.view().fireShowContextMenu(new Point(event.x, event.y));
                        return;
                    }
                    if (event.button != 1) break;
                    if (iDiffNode != null && OS.OSX && KeyUtil.hasMask((Event)event, (int)SWT.MOD4)) {
                        iDiffNode.setSelected(true, true);
                        TreeController.this.view().fireShowContextMenu(new Point(event.x, event.y));
                        return;
                    }
                    this.oldY = event.y;
                    this.oldHitNode = iDiffNode;
                    boolean bl = false;
                    IDiffNode iDiffNode2 = TreeController.this.model().getOldSelected();
                    if (iDiffNode2 != null) {
                        if (enumSet.contains((Object)Modifier.SHIFT)) {
                            TreeController.this.selectViewableRange(iDiffNode2, this.oldHitNode);
                            bl = true;
                        }
                        if (enumSet.contains((Object)Modifier.CTRL)) {
                            bl = true;
                        }
                    }
                    if (this.oldHitNode == null) break;
                    boolean bl2 = true;
                    if (this.oldHitNode.isSelected() && enumSet.contains((Object)Modifier.CTRL) && !enumSet.contains((Object)Modifier.SHIFT)) {
                        bl2 = false;
                    }
                    this.oldHitNode.setSelected(bl2, bl);
                    break;
                }
                case 5: {
                    if (this.doubleClick) {
                        return;
                    }
                    if (this.oldHitNode == null) break;
                    int n = TreeController.this.view().getItemHeight();
                    int n2 = event.y;
                    int n3 = Math.abs(n2 - this.oldY);
                    int n4 = this.oldY;
                    while (n3 > n) {
                        n4 = n4 < n2 ? n4 + n : n4 - n;
                        n3 = Math.abs(n2 - n4);
                        this.handleMouseMove(event, n4);
                    }
                    this.handleMouseMove(event, n2);
                    this.oldY = event.y;
                    break;
                }
                case 4: {
                    TreeController.this.oldRange.clear();
                    if (this.doubleClick) {
                        this.doubleClick = false;
                        return;
                    }
                    if (this.expandNode != null && !OS.WIN) {
                        this.expandNode.setExpanded(!this.expandNode.isExpanded());
                        this.expandNode = null;
                        TreeController.this.view().redrawNow();
                    }
                    this.oldHitNode = null;
                    TreeController.this.dragSelect = false;
                    break;
                }
                case 8: {
                    TreeController.this.fireDefaultSelection();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void handleMouseMove(Event event, int n) {
            IDiffNode iDiffNode;
            if (this.doubleClick) {
                return;
            }
            if (this.oldHitNode != null && (iDiffNode = TreeController.this.view().hitTestNode(n)) != null && iDiffNode != this.oldHitNode) {
                TreeController.this.dragSelect = true;
                IDiffNode iDiffNode2 = TreeController.this.model().getOldSelected();
                if (iDiffNode != iDiffNode2) {
                    if (TreeController.this.oldRange.contains(iDiffNode)) {
                        ((IDiffNodeImpl)iDiffNode2).setSelected(false, true, false);
                        TreeController.this.oldRange.remove(iDiffNode2);
                        TreeController.this.view().updateSelection(iDiffNode2);
                    } else {
                        if (!KeyUtil.hasMask((Event)event, (int)SWT.MOD1)) {
                            TreeController.this.deselectVisibleNodes(this.oldHitNode);
                        }
                        TreeController.this.selectVisibleRange(this.oldHitNode, iDiffNode, true);
                    }
                }
                TreeController.this.model().setOldSelected(iDiffNode);
            }
        }
    };
    private final Listener onMouseMove = new Listener(){

        public void handleEvent(Event event) {
            if (TreeController.this.skipEvent[0] || !TreeController.this.dragSelect) {
                return;
            }
            ((TreeController)TreeController.this).skipEvent[0] = true;
            TreeController.this.tree.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TreeController.this.tree != null && !TreeController.this.tree.isDisposed()) {
                        TreeController.this.view().structView().birdsEye().redraw();
                        TreeController.this.view().structView().reportSelection();
                        ((TreeController)(this).TreeController.this).skipEvent[0] = false;
                    }
                }
            });
        }
    };
    private final Listener onResize = new Listener(){

        public void handleEvent(Event event) {
            TreeController.this.updateScrollBar();
        }
    };
    private Rectangle rcCell;
    private final ScrollBar sbCommon;
    private final boolean[] skipEvent = new boolean[1];
    private IDiffNode startNode;
    private Canvas tree;
    Text txtEdit;

    public TreeController(ScrollBar scrollBar) {
        this.sbCommon = scrollBar;
    }

    public void clearSelectionMode() {
        Event event = new Event();
        event.widget = this.view();
        event.button = 1;
        event.type = 4;
        this.onMouse.handleEvent(event);
    }

    public void connect(IMvcModel iMvcModel, IMvcView iMvcView) {
        super.connect(iMvcModel, iMvcView);
        assert (iMvcView instanceof TreeView);
        this.installListeners(false);
        this.tree = this.view().tree();
        this.installListeners(true);
    }

    private void deselectVisibleNodes(IDiffNode iDiffNode) {
        List<IDiffNode> list = this.view().visibleNodes();
        for (IDiffNode iDiffNode2 : list) {
            IDiffNodeImpl iDiffNodeImpl;
            if (iDiffNode2 == iDiffNode || !(iDiffNodeImpl = (IDiffNodeImpl)iDiffNode2).isSelected()) continue;
            iDiffNodeImpl.setSelected(false, true, false);
        }
    }

    public void disconnect() {
        this.installListeners(false);
        super.disconnect();
    }

    private boolean expandSelected(boolean bl) {
        List list = this.model().getSelected();
        if (list.isEmpty()) {
            return false;
        }
        IDiffNode iDiffNode = (IDiffNode)list.get(0);
        if (iDiffNode.isExpanded() != bl && iDiffNode.hasChildren()) {
            iDiffNode.setExpanded(bl);
            return true;
        }
        return false;
    }

    private void fireDefaultSelection() {
        Event event = new Event();
        event.type = 14;
        event.widget = this.tree;
        this.tree.notifyListeners(14, event);
    }

    private void hideCellEdit() {
        if (this.txtEdit != null && !this.txtEdit.isDisposed()) {
            this.txtEdit.dispose();
            this.txtEdit = null;
        }
    }

    IDiffNode hitTestExpandImage(Point point) {
        Rectangle rectangle = this.tree.getClientArea();
        if (!rectangle.contains(point)) {
            return null;
        }
        IDiffNode iDiffNode = null;
        int n = point.y / this.view().getItemHeight();
        Point point2 = this.view().visibleRange();
        if (n <= point2.y - point2.x) {
            List list = this.model().getViewable();
            if (point2.x + n < list.size()) {
                iDiffNode = (IDiffNode)list.get(point2.x + n);
            } else assert (false);
        }
        if (iDiffNode == null) {
            return null;
        }
        if (iDiffNode.getChildren(false).length == 0) {
            return null;
        }
        int n2 = 0;
        TreeColumn[] treeColumnArray = this.view().getColumns();
        int n3 = TreeView.depthOffset(iDiffNode);
        TreeColumn[] treeColumnArray2 = treeColumnArray;
        int n4 = treeColumnArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Rectangle rectangle2;
            TreeColumn treeColumn = treeColumnArray2[n5];
            if (((ColumnBoss.TreeColumnEx)treeColumn).type() == ColumnType.EXPAND && (rectangle2 = new Rectangle(n2 + n3, point.y, TreeView.arrowImgSize.x, TreeView.arrowImgSize.y)).contains(point)) {
                return iDiffNode;
            }
            n2 += treeColumn.getWidth();
            ++n5;
        }
        return null;
    }

    private void installKeyListener(boolean bl) {
        if (bl) {
            this.tree.addListener(1, this.onKey);
        } else {
            this.tree.removeListener(1, this.onKey);
        }
    }

    private void installListeners(boolean bl) {
        if (this.tree != null && !this.tree.isDisposed()) {
            this.installResizeListener(bl);
            this.installMouseListener(bl);
            this.installKeyListener(bl);
        }
    }

    public void installMouseListener(boolean bl) {
        if (bl) {
            this.tree.addListener(5, this.onMouseMove);
            this.tree.addListener(3, this.onMouse);
            this.tree.addListener(5, this.onMouse);
            this.tree.addListener(4, this.onMouse);
            this.tree.addListener(8, this.onMouse);
        } else {
            this.tree.removeListener(5, this.onMouseMove);
            this.tree.removeListener(3, this.onMouse);
            this.tree.removeListener(5, this.onMouse);
            this.tree.removeListener(4, this.onMouse);
            this.tree.removeListener(8, this.onMouse);
        }
    }

    private void installResizeListener(boolean bl) {
        if (bl) {
            this.view().addListener(11, this.onResize);
        } else {
            this.view().removeListener(11, this.onResize);
        }
    }

    public IStructDiffModel model() {
        return (IStructDiffModel)super.model();
    }

    public void renameSelected() {
        StructDiffView structDiffView;
        Role role;
        List list = this.model().getSelected();
        if (list.isEmpty()) {
            return;
        }
        final IDiffNode iDiffNode = (IDiffNode)list.get(0);
        IResource iResource = (IResource)iDiffNode.getElement(role = (structDiffView = this.view().structView()).getFocusRole());
        if (iResource == null) {
            return;
        }
        ColumnBoss.TreeColumnEx treeColumnEx = structDiffView.columnBoss(Role.REF).getColumn(role, ColumnType.EXPAND);
        if (this.cellEdit == null) {
            this.cellEdit = new TreeEdit(this.view().header(), this.view().tree()){

                @Override
                protected Rectangle getCellBounds() {
                    IDiffNode iDiffNode = (IDiffNode)TreeController.this.model().getSelected().get(0);
                    TreeColumn[] treeColumnArray = this.header.getColumns();
                    int n = treeColumnArray[this.cell.x].getWidth();
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.cell.x) {
                        n2 += treeColumnArray[n3].getWidth();
                        ++n3;
                    }
                    n3 = OS.OSX ? 2 : 0;
                    int n4 = TreeView.depthOffset(iDiffNode) + TreeView.arrowImgSize.x + 4;
                    int n5 = TreeController.this.view().getItemHeight();
                    TreeController.this.rcCell = new Rectangle(n2 + n4, this.cell.y * n5 - n3, n - n4, n5 + n3);
                    return TreeController.this.rcCell;
                }
            };
            this.cellEdit.horizontalAlignment = 16384;
            this.cellEdit.grabHorizontal = true;
        }
        this.txtEdit = new Text((Composite)this.view().tree(), 2048);
        String string = iResource.getName();
        this.txtEdit.setText(string);
        Listener listener = new Listener(){

            public void handleEvent(final Event event) {
                switch (event.type) {
                    case 16: {
                        TreeController.this.hideCellEdit();
                        break;
                    }
                    case 25: {
                        String string = TreeController.this.txtEdit.getText();
                        String string2 = string.substring(0, event.start);
                        String string3 = string.substring(event.end, string.length());
                        GC gC = new GC((Drawable)TreeController.this.txtEdit);
                        Point point = gC.textExtent(String.valueOf(string2) + event.text + string3);
                        gC.dispose();
                        point = TreeController.this.txtEdit.computeSize(point.x, -1);
                        TreeController.this.cellEdit.horizontalAlignment = 16384;
                        Rectangle rectangle = TreeController.this.tree.getClientArea();
                        TreeController.this.cellEdit.minimumWidth = Math.max(point.x, ((TreeController)TreeController.this).rcCell.width) + 2;
                        int n = ((TreeController)TreeController.this).rcCell.x;
                        int n2 = rectangle.x + rectangle.width;
                        TreeController.this.cellEdit.minimumWidth = Math.min(TreeController.this.cellEdit.minimumWidth, n2 - n);
                        TreeController.this.cellEdit.minimumHeight = point.y + 2;
                        TreeController.this.cellEdit.layout();
                        break;
                    }
                    case 31: {
                        switch (event.detail) {
                            case 4: {
                                final String string = TreeController.this.txtEdit.getText();
                                TreeController.this.tree.getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (TreeController.this.tree != null && !TreeController.this.tree.isDisposed()) {
                                            try {
                                                iDiffNode.renameElement(role, string);
                                            }
                                            catch (IOException iOException) {
                                                UIUtil.showError((String)iOException.getLocalizedMessage());
                                            }
                                        }
                                    }
                                });
                            }
                            case 2: {
                                TreeController.this.tree.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if ((this).TreeController.this.txtEdit != null && !(this).TreeController.this.txtEdit.isDisposed()) {
                                            (this).TreeController.this.txtEdit.dispose();
                                            event.doit = false;
                                            TreeController.this.view().tree().setFocus();
                                        }
                                    }
                                });
                            }
                        }
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
        };
        int n = FileUtil.getExtension((String)string).length();
        if (n > 0) {
            ++n;
        }
        this.txtEdit.setSelection(0, string.length() - n);
        this.txtEdit.setFocus();
        this.txtEdit.setFont(this.view().getFont());
        final int n2 = this.view().columnIndex(treeColumnEx);
        final ScrollBar scrollBar = this.view().getVerticalBar();
        int n3 = scrollBar.getSelection();
        Point point = new Point(n2, this.view().getVisibleNodeIndex(iDiffNode) - n3);
        this.cellEdit.setEditor((Control)this.txtEdit, point);
        this.txtEdit.addListener(16, listener);
        this.txtEdit.addListener(31, listener);
        this.txtEdit.addListener(25, listener);
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (TreeController.this.txtEdit == null || TreeController.this.txtEdit.isDisposed()) break;
                        int n = scrollBar.getSelection();
                        Point point = new Point(n2, TreeController.this.view().getVisibleNodeIndex(iDiffNode) - n);
                        TreeController.this.cellEdit.setEditor((Control)TreeController.this.txtEdit, point);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
        };
        scrollBar.addListener(13, listener2);
    }

    private void scrollSelect(Event event) {
        int n = event.keyCode;
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        if (KeyUtil.hasMask((Event)event, (int)SWT.MOD2)) {
            enumSet.add(Modifier.SHIFT);
        } else {
            this.startNode = null;
        }
        List list = this.model().getViewable();
        if (list.isEmpty()) {
            return;
        }
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        switch (n) {
            case 0x1000002: {
                n2 = 1;
                break;
            }
            case 0x1000001: {
                n2 = -1;
                bl2 = false;
                break;
            }
            case 0x1000006: {
                n2 = this.sbCommon.getPageIncrement();
                break;
            }
            case 0x1000003: {
                if (this.expandSelected(false)) break;
                n2 = -1;
                break;
            }
            case 0x1000004: {
                if (this.expandSelected(true)) break;
                n2 = 1;
                break;
            }
            case 0x1000005: {
                n2 = -this.sbCommon.getPageIncrement();
                bl2 = false;
                break;
            }
            case 0x1000007: {
                n2 = -this.model().getViewable().size();
                bl2 = false;
                break;
            }
            case 0x1000008: {
                n2 = this.model().getViewable().size();
                bl2 = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            List list2 = this.model().getSelected();
            int n3 = 0;
            if (list2.isEmpty()) {
                n3 = 0;
            } else if (this.startNode == null) {
                int n4 = bl2 ? list2.size() - 1 : 0;
                IDiffNode iDiffNode = (IDiffNode)list2.get(n4);
                n3 = list.indexOf(iDiffNode);
            } else {
                n3 = list.indexOf(this.startNode);
            }
            this.endNodeIx = (this.startNode == null ? n3 : this.endNodeIx) + n2;
            if (this.startNode == null && enumSet.contains((Object)Modifier.SHIFT)) {
                this.startNode = (IDiffNode)list.get(n3);
            }
            this.endNodeIx = Math.max(0, this.endNodeIx);
            this.endNodeIx = Math.min(this.endNodeIx, list.size() - 1);
            ((IDiffNode)list.get(this.endNodeIx)).setSelected(true, false);
            if (!enumSet.contains((Object)Modifier.SHIFT)) {
                return;
            }
            if (n3 == this.endNodeIx) {
                return;
            }
            if (this.endNodeIx > n3) {
                this.selectViewableRange(this.startNode, (IDiffNode)list.get(this.endNodeIx));
            } else {
                this.selectViewableRange((IDiffNode)list.get(this.endNodeIx), this.startNode);
            }
            this.view().redrawNow();
        }
    }

    private void selectRange(List<IDiffNode> list, IDiffNode iDiffNode, IDiffNode iDiffNode2, boolean bl) {
        boolean bl2 = false;
        LinkedList<IDiffNode> linkedList = new LinkedList<IDiffNode>();
        for (IDiffNode iDiffNode3 : list) {
            if (iDiffNode3 == iDiffNode || iDiffNode3 == iDiffNode2) {
                boolean bl3 = bl2 = !bl2;
            }
            if (!bl2) continue;
            ((IDiffNodeImpl)iDiffNode3).setSelected(true, true, false);
            if (bl) {
                if (this.oldRange.contains(iDiffNode3)) continue;
                this.oldRange.add(iDiffNode3);
                linkedList.add(iDiffNode3);
                continue;
            }
            linkedList.add(iDiffNode3);
        }
        ((IDiffNodeImpl)iDiffNode2).setSelected(true, true, false);
        linkedList.add(iDiffNode2);
        this.oldRange.add(iDiffNode2);
        this.view().updateSelection(linkedList);
    }

    private void selectViewableRange(IDiffNode iDiffNode, IDiffNode iDiffNode2) {
        this.selectRange(this.model().getViewable(), iDiffNode, iDiffNode2, false);
    }

    private void selectVisibleRange(IDiffNode iDiffNode, IDiffNode iDiffNode2, boolean bl) {
        this.selectRange(this.view().visibleNodes(), iDiffNode, iDiffNode2, bl);
    }

    public void updateScrollBar() {
        final IStructDiffModel iStructDiffModel = this.model();
        if (iStructDiffModel.isEmpty()) {
            return;
        }
        this.tree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeView treeView = TreeController.this.view();
                if (treeView != null && TreeController.this.tree != null && !TreeController.this.tree.isDisposed()) {
                    int n;
                    int n2 = iStructDiffModel.getViewable().size();
                    TreeController.this.sbCommon.setMaximum(n2);
                    int n3 = treeView.maxVisibleRowCount(false);
                    TreeController.this.sbCommon.setThumb(Math.min(n3, n2));
                    TreeController.this.sbCommon.setPageIncrement(TreeController.this.sbCommon.getThumb() - 1);
                    TreeController.this.sbCommon.setIncrement(3);
                    if (treeView.visibleRange().y < n2 && (n = n2 - n3) < 0) {
                        TreeController.this.sbCommon.setSelection(0);
                    }
                    treeView.redrawNow();
                }
            }
        });
    }

    public TreeView view() {
        return (TreeView)super.view();
    }

    private static enum Modifier {
        CTRL,
        SHIFT;

    }
}

