/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.PrefKey;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.TimeFilter;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterComposite;
import com.deltopia.eclipse.util.TimeUnit;
import com.deltopia.jface.util.DialogUtil;
import java.util.Calendar;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class TimeFilterComposite
extends FolderFilterComposite {
    private boolean absolute;
    private Combo cbRelation;
    private Combo cbUnit;
    private Button chbAbsolute;
    private DateTime dtDate;
    private DateTime dtTime;
    private Label lblAgo;
    private Label lblThan;
    private Spinner spnTime;
    private long time;
    private long timeDelta;

    public TimeFilterComposite(Composite composite, IPreferenceStore iPreferenceStore, FolderFilter folderFilter) {
        super(composite, iPreferenceStore, folderFilter);
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.absolute = true;
        this.createActionCombo();
        this.createTargetCombo();
        this.createRelationCombo();
        this.createDateTimeComposite();
        this.initializeControls();
    }

    private void createDateTimeComposite() {
        ++((GridLayout)this.getLayout()).numColumns;
        this.dtDate = new DateTime((Composite)this, 36);
        this.dtDate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.dtTime = new DateTime((Composite)this, 2176);
        this.dtTime.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(TimeFilterComposite.this.dtDate.getYear(), TimeFilterComposite.this.dtDate.getMonth(), TimeFilterComposite.this.dtDate.getDay(), TimeFilterComposite.this.dtTime.getHours(), TimeFilterComposite.this.dtTime.getMinutes(), TimeFilterComposite.this.dtTime.getSeconds());
                TimeFilterComposite.this.time = calendar.getTimeInMillis();
            }
        };
        this.dtDate.addSelectionListener(selectionListener);
        this.dtTime.addSelectionListener(selectionListener);
        this.spnTime = DialogUtil.createSpinner((Composite)this, null, (int)9999, (SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimeFilterComposite.this.timeDelta = TimeFilterComposite.this.spnTime.getSelection();
            }
        });
        this.spnTime.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.cbUnit = new Combo((Composite)this, 12);
        this.cbUnit.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Set set = TimeUnit.ASCENDING;
        for (TimeUnit timeUnit : set) {
            this.cbUnit.add(timeUnit.label());
        }
        this.cbUnit.select(TimeUnit.HOURS.toInt());
        this.cbUnit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimeFilterComposite.this.prefs.setValue(PrefKey.D_TIME_UNIT.toString(), TimeFilterComposite.this.cbUnit.getSelectionIndex());
            }
        });
        this.lblAgo = new Label((Composite)this, 0);
        this.lblAgo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.lblAgo.setText("ago");
        int n = 0;
        while (n < 5) {
            new Label((Composite)this, 0);
            ++n;
        }
        this.chbAbsolute = new Button((Composite)this, 32);
        this.chbAbsolute.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.chbAbsolute.setText("Absolute time");
        this.chbAbsolute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimeFilterComposite.this.absolute = TimeFilterComposite.this.chbAbsolute.getSelection();
                TimeFilterComposite.this.prefs.setValue(PrefKey.D_USE_ABSOLUTE_TIME.toString(), TimeFilterComposite.this.absolute);
                if (TimeFilterComposite.this.absolute) {
                    Calendar calendar = Calendar.getInstance();
                    long l = TimeFilterComposite.this.timeDelta();
                    calendar.setTimeInMillis(System.currentTimeMillis() - l);
                    TimeFilterComposite.this.time = calendar.getTimeInMillis();
                    TimeFilterComposite.this.updateAbsoluteTimeUI();
                }
                TimeFilterComposite.this.showDateTimeControls();
                TimeFilterComposite.this.getShell().pack();
            }
        });
        this.chbAbsolute.setSelection(this.absolute);
        this.showDateTimeControls();
    }

    private void createRelationCombo() {
        this.cbRelation = new Combo((Composite)this, 12);
        this.cbRelation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbRelation.add(TimeFilter.Relation.OLDER.toString());
        this.cbRelation.add(TimeFilter.Relation.NEWER.toString());
        this.cbRelation.select(0);
        ++((GridLayout)this.getLayout()).numColumns;
        this.lblThan = new Label((Composite)this, 0);
        this.lblThan.setText("than");
        this.lblThan.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    private void ensureMeaningfulTime() {
        if (this.absolute && this.time == 0L) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.dtDate.getYear(), this.dtDate.getMonth(), this.dtDate.getDay(), this.dtTime.getHours(), this.dtTime.getMinutes(), this.dtTime.getSeconds());
            this.time = calendar.getTimeInMillis();
        }
    }

    @Override
    public FolderFilter.Type getType() {
        return FolderFilter.Type.TIME;
    }

    @Override
    public String helpTopic() {
        return "folder-comparison-date-time-filter";
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        this.cbTarget.select(FolderFilter.Target.FILES.toInt());
        this.cbTarget.setEnabled(false);
        TimeFilter timeFilter = (TimeFilter)this.getFilter();
        if (timeFilter != null) {
            this.absolute = timeFilter.isAbsolute();
            if (this.absolute) {
                this.time = timeFilter.getTime();
                this.updateAbsoluteTimeUI();
            } else {
                TimeUnit timeUnit = TimeUnit.fromInt((int)this.prefs.getInt(PrefKey.D_TIME_UNIT.toString()));
                this.timeDelta = timeFilter.getTime() / timeUnit.toMillis();
                this.spnTime.setSelection((int)this.timeDelta);
                this.updateRelativeTimeUI();
            }
            this.showDateTimeControls();
            this.cbRelation.select(timeFilter.relation().toInt());
        } else {
            this.absolute = this.prefs.getBoolean(PrefKey.D_USE_ABSOLUTE_TIME.toString());
            this.updateRelativeTimeUI();
        }
    }

    @Override
    protected boolean isFilterInfoValid() {
        long l;
        this.ensureMeaningfulTime();
        TimeFilter timeFilter = (TimeFilter)this.getFilter();
        long l2 = l = this.absolute ? this.time : this.timeDelta();
        if (l > 0L) {
            TimeFilter.Relation relation = TimeFilter.Relation.fromInt((int)this.cbRelation.getSelectionIndex());
            timeFilter = new TimeFilter(this.getSelectedAction(), this.getSelectedTarget(), relation, l, this.absolute, true, "");
            this.setFilter((FolderFilter)timeFilter);
            return true;
        }
        return false;
    }

    private void showDateTimeControls() {
        boolean bl = this.absolute;
        ((GridData)this.dtDate.getLayoutData()).exclude = !bl;
        this.dtDate.setVisible(bl);
        ((GridData)this.dtTime.getLayoutData()).exclude = !bl;
        this.dtTime.setVisible(bl);
        ((GridData)this.spnTime.getLayoutData()).exclude = bl;
        this.spnTime.setVisible(!bl);
        ((GridData)this.cbUnit.getLayoutData()).exclude = bl;
        this.cbUnit.setVisible(!bl);
        ((GridData)this.lblAgo.getLayoutData()).exclude = bl;
        this.lblAgo.setVisible(!bl);
        ((GridLayout)this.getLayout()).numColumns = bl ? 6 : 7;
    }

    private long timeDelta() {
        long l = this.spnTime.getSelection();
        TimeUnit timeUnit = TimeUnit.fromInt((int)this.cbUnit.getSelectionIndex());
        System.out.println("timeDelta in ms=" + (l *= timeUnit.toMillis()));
        return l;
    }

    private void updateAbsoluteTimeUI() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.time);
        this.dtDate.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.dtTime.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
        this.showDateTimeControls();
    }

    private void updateRelativeTimeUI() {
        this.chbAbsolute.setSelection(this.absolute);
        int n = this.prefs.getInt(PrefKey.D_TIME_UNIT.toString());
        this.cbUnit.select(n);
        this.showDateTimeControls();
    }
}

