/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.SyncOpInfo;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.script.Role;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructContextId;
import com.deltawalker.structure.ui.DiffViewLabelProvider;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.util.Const;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SyncNonConflictsDialog
extends TitleAreaDialog {
    private static final int DEFAULT_HEIGHT = 360;
    private static final int DEFAULT_WIDTH = 480;
    private static final int H_GAP_IMAGE = 5;
    private static final int MESSAGE_LINE_COUNT = 2;
    private static final int MESSAGE_WIDTH_INCREMENT = 10;
    private Object[] operations;
    private int shellTrimWidth;
    private int titleAreaWidth;
    private TreeViewer treeViewer;

    public SyncNonConflictsDialog(Shell shell) {
        super(shell);
    }

    private void calculateTitleAreaSize(Composite composite, String string, String string2) {
        int n;
        int n2;
        block9: {
            GC gC = new GC((Drawable)composite);
            n2 = 0;
            n = 0;
            try {
                if (!StringUtil.isEmpty((String)string)) {
                    gC.setFont(JFaceResources.getBannerFont());
                    n2 = gC.textExtent((String)string).x;
                }
                if (StringUtil.isEmpty((String)string2)) break block9;
                Font font = JFaceResources.getDialogFont();
                gC.setFont(font);
                int n3 = gC.textExtent((String)string2).x;
                TextLayout textLayout = new TextLayout((Device)composite.getDisplay());
                try {
                    textLayout.setFont(font);
                    textLayout.setText(string2);
                    if (textLayout.getLineCount() >= 2) break block9;
                    n = Math.max((int)Math.ceil((double)n3 / 2.0), n2);
                    while (n < n3) {
                        textLayout.setWidth(n);
                        if (textLayout.getLineCount() <= 2) {
                            break;
                        }
                        n += 10;
                    }
                }
                finally {
                    textLayout.dispose();
                }
            }
            finally {
                gC.dispose();
            }
        }
        int n4 = this.convertHorizontalDLUsToPixels(4);
        this.titleAreaWidth = n4 + Math.max(n2, 5 + n) + this.getTitleImageLabel().computeSize((int)-1, (int)-1).x;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UIUtil.setHelpContextId((Control)shell, (String)StructContextId.SYNC_NON_CONFLICTS_DIALOG);
        shell.setText(StructMsg.SyncNonConflictsDlg_title);
        this.shellTrimWidth = shell.computeTrim((int)0, (int)0, (int)0, (int)0).width;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.initializeFromModel();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        String string = StructMsg.SyncNonConflictsDlg_subTitle;
        this.setTitle(string);
        String string2 = StructMsg.SyncNonConflictsDlg_msg;
        this.setMessage(string2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer = new TreeViewer(composite3);
        this.treeViewer.setContentProvider((IContentProvider)new MergeNonConflictsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MergeNonConflictsLabelProvider());
        Control control = this.treeViewer.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        SyncNonConflictsDialog.applyDialogFont((Control)composite2);
        this.calculateTitleAreaSize(composite, string, string2);
        return composite2;
    }

    protected Point getInitialSize() {
        return new Point(Math.max(480, this.titleAreaWidth + this.shellTrimWidth), 360);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)"sync-non-conflicts", (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    private void initializeFromModel() {
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.operations);
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            this.setExpanded(iTreeContentProvider.getElements((Object)this.operations), iTreeContentProvider);
        }
    }

    private void setExpanded(Object[] objectArray, ITreeContentProvider iTreeContentProvider) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.treeViewer.setExpandedState(object, true);
            Object[] objectArray2 = iTreeContentProvider.getChildren(object);
            if (objectArray2 != null && objectArray2.length > 0) {
                this.setExpanded(objectArray2, iTreeContentProvider);
            }
            ++n;
        }
    }

    public void setMergeOps(List<SyncOpInfo> list) {
        this.operations = list.toArray();
        this.initializeFromModel();
    }

    private static class MergeNonConflictsContentProvider
    implements ITreeContentProvider {
        private Map<Object, List<Object>> children;
        private Object root;

        private MergeNonConflictsContentProvider() {
        }

        public void dispose() {
            this.children = null;
            this.root = null;
        }

        private void ensureModel(Object object) {
            Object[] objectArray;
            if (this.root != null && this.children != null) {
                return;
            }
            this.root = null;
            this.children = new HashMap<Object, List<Object>>();
            Object[] objectArray2 = objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2;
                Object object3 = objectArray2[n2];
                while ((object2 = this.getParent(object3)) != null) {
                    List<Object> list = this.children.get(object2);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        this.children.put(object2, list);
                    }
                    if (!list.contains(object3)) {
                        list.add(object3);
                    }
                    object3 = object2;
                }
                if (this.root == null) {
                    this.root = object3;
                } else if (!this.root.equals(object3)) {
                    throw new IllegalArgumentException("input");
                }
                ++n2;
            }
            if (this.root == null) {
                throw new IllegalArgumentException("input");
            }
        }

        public Object[] getChildren(Object object) {
            List<Object> list = this.children.get(object);
            return list != null ? list.toArray() : Const.EMPTY_OBJECT_ARRAY;
        }

        public Object[] getElements(Object object) {
            this.ensureModel(object);
            return new Object[]{this.root};
        }

        public Object getParent(Object object) {
            if (object instanceof DiffNode) {
                return ((IDiffNode)object).getParent();
            }
            if (object instanceof SyncOpInfo) {
                SyncOpInfo syncOpInfo = (SyncOpInfo)object;
                SyncOpInfo syncOpInfo2 = syncOpInfo.parent();
                if (syncOpInfo2 != null) {
                    return syncOpInfo2;
                }
                return this.getParent(syncOpInfo.node());
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            List<Object> list = this.children.get(object);
            return list != null && !list.isEmpty();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.dispose();
        }
    }

    private static class MergeNonConflictsLabelProvider
    implements ILabelProvider {
        private MergeNonConflictsLabelProvider() {
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public Image getImage(Object object) {
            if (object instanceof DiffNode) {
                return this.getImage(null, (DiffNode)object);
            }
            if (object instanceof SyncOpInfo) {
                return this.getImage((SyncOpInfo)object);
            }
            return null;
        }

        private Image getImage(Role role, IDiffNode iDiffNode) {
            if (role != null) {
                return iDiffNode.image(role);
            }
            if (iDiffNode.getParent() == null) {
                return this.getImage(Role.REF, iDiffNode);
            }
            Role[] roleArray = Role.values();
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Role role2 = roleArray[n2];
                Image image = this.getImage(role2, iDiffNode);
                if (image != null) {
                    return image;
                }
                ++n2;
            }
            return null;
        }

        private Image getImage(SyncOpInfo syncOpInfo) {
            Image image;
            Image image2 = this.getImage(this.getRole(syncOpInfo), syncOpInfo.node());
            if (image2 != null && (image = this.getOverlay(syncOpInfo)) != null) {
                Image image3;
                image2 = image3 = image2.createOverlayCopy(image, 132096, 0.6, 0.9);
            }
            return image2;
        }

        private Image getOverlay(SyncOpInfo syncOpInfo) {
            String string;
            switch (syncOpInfo.type()) {
                case ADD: {
                    if (StructDiffModel.isNullElement((Object)syncOpInfo.node().getElement(syncOpInfo.destination()))) {
                        string = syncOpInfo.source() == Role.ONE ? ImageConst.ADD_RIGHT_OVR : ImageConst.ADD_LEFT_OVR;
                        break;
                    }
                    string = syncOpInfo.source() == Role.ONE ? ImageConst.REPLACE_RIGHT_OVR : ImageConst.REPLACE_LEFT_OVR;
                    break;
                }
                case DELETE: {
                    string = ImageConst.DELETE_OVR;
                    break;
                }
                case MERGE: {
                    IDiffNode iDiffNode = syncOpInfo.node();
                    if (iDiffNode.isConflict() && !iDiffNode.isPseudoConflict() && iDiffNode.hasTrueConflicts()) {
                        string = ImageConst.MERGE_CONFLICTS_OVR;
                        break;
                    }
                    string = ImageConst.MERGE_NON_CONFLICTS_OVR;
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string == null ? null : ImageCache.getImage((String)string);
        }

        private Role getRole(SyncOpInfo syncOpInfo) {
            Role role;
            switch (syncOpInfo.type()) {
                case ADD: {
                    role = syncOpInfo.source();
                    break;
                }
                case DELETE: {
                    role = syncOpInfo.destination();
                    break;
                }
                case MERGE: {
                    role = Role.REF;
                    break;
                }
                default: {
                    role = null;
                }
            }
            return role;
        }

        public String getText(Object object) {
            if (object instanceof DiffNode) {
                DiffNode diffNode = (DiffNode)object;
                return this.getText(null, diffNode);
            }
            if (object instanceof SyncOpInfo) {
                SyncOpInfo syncOpInfo = (SyncOpInfo)object;
                return this.getText(this.getRole(syncOpInfo), syncOpInfo.node());
            }
            return "";
        }

        private String getText(Role role, IDiffNode iDiffNode) {
            if (role != null) {
                return DiffViewLabelProvider.getText(role, iDiffNode);
            }
            if (iDiffNode.getParent() == null) {
                return this.getText(Role.REF, iDiffNode);
            }
            Role[] roleArray = Role.values();
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Role role2 = roleArray[n2];
                String string = this.getText(role2, iDiffNode);
                if (!StringUtil.isEmpty((String)string)) {
                    return string;
                }
                ++n2;
            }
            return "";
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

