/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.SizeFilter;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterComposite;
import com.deltopia.jface.util.DialogUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SizeFilterComposite
extends FolderFilterComposite {
    private Combo cbRelation;
    private Combo cbUnit;
    private long selSize;
    private Spinner spnSize;

    public SizeFilterComposite(Composite composite, IPreferenceStore iPreferenceStore, FolderFilter folderFilter) {
        super(composite, iPreferenceStore, folderFilter);
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.createActionCombo();
        this.createTargetCombo();
        this.createRelationCombo();
        this.createSizeSpinner();
        this.createSizeCombo();
        this.initializeControls();
    }

    private void createRelationCombo() {
        this.cbRelation = new Combo((Composite)this, 12);
        this.cbRelation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbRelation.add(SizeFilter.Relation.LARGER.toString());
        this.cbRelation.add(SizeFilter.Relation.SMALLER.toString());
        this.cbRelation.select(0);
        ++((GridLayout)this.getLayout()).numColumns;
        Label label = new Label((Composite)this, 0);
        label.setText("than");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    private void createSizeCombo() {
        ++((GridLayout)this.getLayout()).numColumns;
        this.cbUnit = new Combo((Composite)this, 12);
        this.cbUnit.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbUnit.add(SizeFilter.Unit.BYTES.toString());
        this.cbUnit.add(SizeFilter.Unit.KBYTES.toString());
        this.cbUnit.add(SizeFilter.Unit.MBYTES.toString());
        this.cbUnit.add(SizeFilter.Unit.GBYTES.toString());
        this.cbUnit.select(0);
    }

    private void createSizeSpinner() {
        ++((GridLayout)this.getLayout()).numColumns;
        this.spnSize = DialogUtil.createSpinner((Composite)this, null, (int)100000, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Widget widget = selectionEvent.widget;
                SizeFilterComposite.this.selSize = ((Spinner)widget).getSelection();
            }
        });
        this.spnSize.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    private SizeFilter.Relation getSelectedRelation() {
        return SizeFilter.Relation.fromInt((int)this.cbRelation.getSelectionIndex());
    }

    private SizeFilter.Unit getSelectedUnit() {
        return SizeFilter.Unit.fromInt((int)this.cbUnit.getSelectionIndex());
    }

    @Override
    public FolderFilter.Type getType() {
        return FolderFilter.Type.SIZE;
    }

    @Override
    public String helpTopic() {
        return "folder-comparison-size-filter";
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        this.cbTarget.select(FolderFilter.Target.FILES.toInt());
        this.cbTarget.setEnabled(false);
        SizeFilter sizeFilter = (SizeFilter)this.getFilter();
        if (sizeFilter != null) {
            this.selSize = sizeFilter.getSize();
            this.spnSize.setSelection((int)this.selSize);
            this.cbRelation.select(sizeFilter.relation().index());
            this.cbUnit.select(sizeFilter.unit().index());
        }
    }

    @Override
    protected boolean isFilterInfoValid() {
        SizeFilter sizeFilter = new SizeFilter(this.getSelectedAction(), this.getSelectedRelation(), this.selSize, this.getSelectedUnit(), true, "");
        this.setFilter((FolderFilter)sizeFilter);
        return true;
    }
}

