/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.DiffModel;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructContextId;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.UIUtil;
import com.deltopia.util.OS;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SetDateModifiedDialog
extends TrayDialog {
    private Button btnCopy;
    Button btnLastDate;
    Button btnSelDate;
    private Button btnSetTo;
    private boolean canCopyDate;
    private Combo cbCopyDate;
    private DateTime dtDate;
    private DateTime dtTime;
    private Role focusRole;
    private long lastDate;
    private final IPreferenceStore prefs;
    private Set<Role> roles;
    private long selDate;
    private Role srcRole;
    private boolean threeWay;
    private boolean useCopyDate = true;
    private boolean useLastDate;

    public SetDateModifiedDialog(Shell shell, StructDiffView structDiffView) {
        super(shell);
        this.focusRole = structDiffView.getFocusRole();
        this.roles = Relation.others((Role)this.focusRole, (boolean)structDiffView.isThreeWay());
        this.canCopyDate = this.canEnableCopy(structDiffView.deltaModel());
        this.prefs = structDiffView.getInput().preferences();
        this.useLastDate = this.prefs.getBoolean(PrefKey.D_USE_LAST_DATE.toString());
        this.useCopyDate = this.prefs.getBoolean(PrefKey.D_USE_COPY_DATE.toString());
        this.lastDate = this.prefs.getLong(PrefKey.D_LAST_DATE.toString());
        this.threeWay = structDiffView.isThreeWay();
    }

    private boolean canEnableCopy(IStructDiffModel iStructDiffModel) {
        List list = iStructDiffModel.getSelected();
        for (IDiffNode iDiffNode : list) {
            for (Role role : this.roles) {
                if (DiffModel.isNullElement((Object)iDiffNode.getElement(role))) continue;
                return true;
            }
        }
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StructMsg.SetDateModifiedAction_shellText);
    }

    private Control createDateTimeControls(Composite composite, int n) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 3 * gridLayout.verticalSpacing;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, n);
        composite2.setLayout((Layout)gridLayout);
        this.dtDate = new DateTime(composite2, 0x24 | (OS.OSX ? 0 : 2048));
        this.dtDate.setLayoutData((Object)new GridData(1, 4, false, true));
        this.dtTime = new DateTime(composite2, 0x80 | (OS.OSX ? 0 : 2048));
        this.updateSelectedDate();
        this.dtTime.setLayoutData((Object)new GridData(1, 4, false, true));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SetDateModifiedDialog.this.updateSelectedDate();
            }
        };
        this.dtDate.addListener(13, listener);
        this.dtTime.addListener(13, listener);
        return composite2;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        UIUtil.setHelpContextId((Control)composite2.getShell(), (String)StructContextId.SET_DATE_MODIFIED_DIALOG);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1808));
        this.btnCopy = new Button(composite3, 16);
        this.btnCopy.setEnabled(this.canCopyDate);
        this.btnCopy.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnCopy.setSelection(this.useCopyDate());
        this.btnCopy.setText(StructMsg.SetDateModifiedAction_copyLastModifiedFrom);
        this.cbCopyDate = new Combo(composite3, 12);
        this.cbCopyDate.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fillCopyCombo(this.cbCopyDate);
        Label label = new Label(composite3, 0);
        label.setEnabled(this.canCopyDate);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(NLS.bind((String)StructMsg.SetDateModifiedAction_copyLastModifiedTo, (Object)this.focusRole.getDisplayName(this.threeWay)));
        this.btnSetTo = new Button(composite3, 16);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = gridLayout.numColumns;
        this.btnSetTo.setLayoutData((Object)gridData);
        this.btnSetTo.setSelection(!this.btnCopy.getSelection());
        this.btnSetTo.setText(StructMsg.SetDateModifiedAction_setLastModifiedTo);
        gridData = new GridData(1808);
        gridData.horizontalSpan = gridLayout.numColumns;
        Control control = this.createSetControls(composite3, 0);
        control.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SetDateModifiedDialog.this.updateUI();
            }
        };
        this.cbCopyDate.addListener(13, listener);
        this.btnSetTo.addListener(13, listener);
        this.updateUI();
        return composite2;
    }

    private Control createSetControls(Composite composite, int n) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 3 * gridLayout.verticalSpacing;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, n);
        composite2.setLayout((Layout)gridLayout);
        this.btnLastDate = new Button(composite2, 16);
        this.btnLastDate.setLayoutData((Object)new GridData(4, 1, true, false));
        this.btnLastDate.setSelection(this.useLastDate);
        this.btnLastDate.setText(StructMsg.SetDateModifiedAction_lastLastModified);
        this.btnSelDate = new Button(composite2, 16);
        this.btnSelDate.setLayoutData((Object)new GridData(4, 1, true, false));
        this.btnSelDate.setSelection(!this.btnLastDate.getSelection());
        this.btnSelDate.setText(StructMsg.SetDateModifiedAction_selDateTime);
        Control control = this.createDateTimeControls(composite2, 0);
        control.setLayoutData((Object)new GridData(1808));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SetDateModifiedDialog.this.useLastDate = SetDateModifiedDialog.this.btnLastDate.getSelection();
                SetDateModifiedDialog.this.updateSelectedDate();
                SetDateModifiedDialog.this.updateUI();
            }
        };
        listener.handleEvent(null);
        this.btnLastDate.addListener(13, listener);
        return composite2;
    }

    private void fillCopyCombo(Combo combo) {
        for (Role role : this.roles) {
            combo.add(role.getDisplayName(this.threeWay));
        }
        combo.select(0);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)"set-date-modified", (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    private void logDateTime(long l, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        if (!bl) {
            System.out.println("date: y:" + calendar.get(1) + " m:" + calendar.get(2) + " d:" + calendar.get(5));
        }
        System.err.println("time: h:" + calendar.get(11) + " m:" + calendar.get(12) + " s:" + calendar.get(13));
    }

    protected void okPressed() {
        this.prefs.setValue(PrefKey.D_USE_COPY_DATE.toString(), this.useCopyDate);
        this.prefs.setValue(PrefKey.D_USE_LAST_DATE.toString(), this.useLastDate);
        if (!this.useCopyDate) {
            this.prefs.setValue(PrefKey.D_LAST_DATE.toString(), this.selDate);
        }
        super.okPressed();
    }

    public long selectedDate() {
        return this.useLastDate ? this.lastDate : this.selDate;
    }

    public Role sourceRole() {
        return this.srcRole;
    }

    private void updateControlState() {
        this.useCopyDate = this.btnCopy.getSelection();
        this.srcRole = this.roles.toArray(new Role[this.roles.size()])[this.cbCopyDate.getSelectionIndex()];
        boolean bl = !this.useCopyDate();
        this.cbCopyDate.setEnabled(!bl);
        this.btnLastDate.setEnabled(bl);
        this.btnSelDate.setEnabled(bl);
        this.dtDate.setEnabled(bl);
        this.dtTime.setEnabled(bl);
    }

    private void updateSelectedDate() {
        if (this.useLastDate) {
            this.selDate = this.lastDate;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.dtDate.getYear(), this.dtDate.getMonth(), this.dtDate.getDay(), this.dtTime.getHours(), this.dtTime.getMinutes(), this.dtTime.getSeconds());
            this.selDate = calendar.getTimeInMillis();
        }
    }

    private void updateUI() {
        assert (this.dtDate != null);
        assert (this.dtTime != null);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.selDate);
        this.dtDate.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.dtTime.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
        this.updateControlState();
    }

    public boolean useCopyDate() {
        return this.canCopyDate && this.useCopyDate;
    }
}

