/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.ProgressView;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.ui.UIUtil;
import com.deltopia.interfaces.ISyncProgressMonitor;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class ProgressDialog
extends TrayDialog
implements SyncModel.ISyncModelEventListener {
    private ProgressView progressView;
    private String title;

    public ProgressDialog(Shell shell) {
        super(shell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        this.setHelpAvailable(false);
    }

    protected void createButtonsForButtonBar(Composite composite) {
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.run();
        UIUtil.enforceMinDialogSize((Shell)this.getShell());
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.progressView = new ProgressView(composite2, 0, true);
        this.progressView.createContents();
        return composite2;
    }

    @Override
    public void done() {
        this.progressView.done();
        if (!this.progressView.hasErrors()) {
            this.close();
        }
    }

    @Override
    public Control getControl() {
        return this.progressView;
    }

    @Override
    public String getErrorLabel() {
        return StructMsg.ProgressView_error;
    }

    @Override
    public ISyncProgressMonitor monitor() {
        return this.progressView.monitor();
    }

    public ProgressView getProgressView() {
        return this.progressView;
    }

    public boolean handleException(Throwable throwable) {
        return this.progressView.handleException(throwable);
    }

    public void handleShellCloseEvent() {
        ISyncProgressMonitor iSyncProgressMonitor = this.monitor();
        if (iSyncProgressMonitor.isCanceled()) {
            this.close();
        } else {
            iSyncProgressMonitor.setCanceled(true);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.progressView != null && this.progressView.isDisposed() || this.getShell().isDisposed();
    }

    protected abstract void run();

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public void synchronizing() {
    }
}

