/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.PathFilter;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterComposite;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import com.deltopia.regex.RegexUtil;
import com.deltopia.util.ArrayUtil;
import com.deltopia.util.Const;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class PathFilterComposite
extends FolderFilterComposite {
    private static final String[] EXPRESSIONS = (String[])ArrayUtil.join(String.class, (Object)ArrayUtil.join(String.class, (Object)PathFilter.EXCLUDE_FILES, (Object)PathFilter.INCLUDE_FILES), (Object)PathFilter.EXCLUDE_FOLDERS);
    private Button btnChoose;
    private Button chbCase;
    private Button chbRegex;
    final Comparator<String> comparPattern = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            if (string.substring(0, 3).compareToIgnoreCase(string2.substring(0, 3)) == 0) {
                int n;
                int n2 = string.length();
                if (n2 == (n = string2.length())) {
                    return 0;
                }
                return n2 > n ? -1 : 1;
            }
            return string.compareToIgnoreCase(string2);
        }
    };
    private Label lblHint;
    private Text txtExp;

    public PathFilterComposite(Composite composite, IPreferenceStore iPreferenceStore, FolderFilter folderFilter) {
        super(composite, iPreferenceStore, folderFilter);
    }

    private void chooseRegex() {
        Object[] objectArray;
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = EXPRESSIONS;
        int n = EXPRESSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            treeSet.add(string);
            ++n2;
        }
        string = this.txtExp.getText();
        Object[] objectArray2 = objectArray = StringUtil.isEmpty((String)string) ? new String[]{} : string.split(RegexUtil.SUB_EXPRESSION_SEPARATOR);
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string2 = objectArray2[n4];
            treeSet.add(string2);
            ++n4;
        }
        Object[] objectArray3 = treeSet.toArray();
        IStructuredContentProvider iStructuredContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return (Object[])object;
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        };
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.getShell(), objectArray3, iStructuredContentProvider, (ILabelProvider)new LabelProvider(), StructMsg.FolderFilterDialog_Choose_expressions){

            public int open() {
                this.setShellStyle(this.getShellStyle() | 0x10000000);
                return super.open();
            }
        };
        listSelectionDialog.setInitialSelections(objectArray);
        listSelectionDialog.setTitle(StructMsg.FolderFilterDialog_Choose_title);
        listSelectionDialog.open();
        objectArray2 = listSelectionDialog.getResult();
        if (objectArray2 != null) {
            this.txtExp.setText(StringUtil.join((Object[])objectArray2, (String)RegexUtil.SUB_EXPRESSION_SEPARATOR));
        }
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.createActionCombo();
        this.createExpressionControls();
        this.createTargetCombo();
        this.createHintControls();
        this.initializeControls();
    }

    private void createExpressionControls() {
        this.txtExp = new Text((Composite)this, 2048);
        this.txtExp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnChoose = new Button((Composite)this, 8);
        this.btnChoose.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.btnChoose.setText(StructMsg.FolderFilterDialog_choose);
        this.btnChoose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathFilterComposite.this.chooseRegex();
            }
        });
    }

    private void createHintControls() {
        new Label((Composite)this, 0);
        this.lblHint = new Label((Composite)this, 64);
        this.lblHint.setLayoutData((Object)new GridData(4, 128, true, true));
        this.lblHint.setText(NLS.bind((String)StructMsg.PathFilterComposite_regexHint, (Object)Const.PATTERN_SEPARATOR));
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        this.chbRegex = new Button(composite, 32);
        this.chbRegex.setLayoutData((Object)new GridData(16384, 128, false, true));
        this.chbRegex.setText(StructMsg.PathFilterComposite_regexType);
        this.chbRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathFilterComposite.this.showHintLabel(!PathFilterComposite.this.chbRegex.getSelection());
            }
        });
        this.chbCase = new Button(composite, 32);
        this.chbCase.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.chbCase.setText("Case sensitive");
        this.chbCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    @Override
    public FolderFilter.Type getType() {
        return FolderFilter.Type.PATH;
    }

    @Override
    public String helpTopic() {
        return "folder-comparison-path-filter";
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        PathFilter pathFilter = (PathFilter)this.getFilter();
        if (pathFilter != null) {
            boolean bl = pathFilter.isRegexType();
            this.chbRegex.setSelection(bl);
            this.chbCase.setSelection(pathFilter.isCaseSensitive());
            this.txtExp.setText(pathFilter.getExpression());
            this.showHintLabel(!bl);
        }
    }

    @Override
    protected boolean isFilterInfoValid() {
        String string = this.txtExp.getText();
        if (string.length() == 0) {
            return false;
        }
        Object[] objectArray = string.split(Const.PATTERN_SEPARATOR);
        Arrays.sort(objectArray, this.comparPattern);
        string = StringUtil.join((Object[])objectArray, (String)Const.PATTERN_SEPARATOR);
        boolean bl = this.chbRegex.getSelection();
        boolean bl2 = this.chbCase.getSelection();
        FolderFilter.Action action = FolderFilter.Action.fromInt((int)this.cbAction.getSelectionIndex());
        FolderFilter.Target target = FolderFilter.Target.fromInt((int)this.cbTarget.getSelectionIndex());
        try {
            PathFilter pathFilter = new PathFilter(action, target, string, bl, bl2, true);
            this.setFilter((FolderFilter)pathFilter);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.showAlert(true, NLS.bind((String)UIMsg.RegexAlert_invalidRegex, (Object)patternSyntaxException.getMessage()), 1);
            return false;
        }
    }

    private void showHintLabel(boolean bl) {
        this.btnChoose.setEnabled(bl);
        this.lblHint.setVisible(bl);
    }
}

