/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.BoldFontCache;
import com.deltawalker.DiffMethodUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.script.Comparison;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructContextId;
import com.deltawalker.ui.ControlUtil;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.AlertComposite;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.OS;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderPrefPageComposite
extends AlertComposite {
    private static final Logger LOG = LoggerFactory.getLogger(FolderPrefPageComposite.class);
    private Button chbBbbThreshold;
    private Button chbContent;
    private Button chbDateThreshold;
    private Button chbDaylight;
    private Button chbTimezone;
    List<Control> contentCtls = new LinkedList<Control>();
    final Host host;
    private Label lblBbbUnit;
    private Map<Comparison.Method, Button> method2Btn = new HashMap<Comparison.Method, Button>();
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!FolderPrefPageComposite.this.isDisposed()) {
                FolderPrefPageComposite.this.updateUIFromPrefs();
            }
        }
    };
    private final SelectionListener onSelect = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Widget widget = selectionEvent.widget;
            Object object = widget.getData();
            if (object instanceof String) {
                String string = (String)object;
                if (widget instanceof Button) {
                    FolderPrefPageComposite.this.prefs.setValue(string, ((Button)widget).getSelection());
                }
            }
            FolderPrefPageComposite.this.updatePrefsFromUI();
            FolderPrefPageComposite.this.updateControlUI();
        }
    };
    private final SelectionListener onSpinner = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Widget widget = selectionEvent.widget;
            String string = (String)widget.getData();
            FolderPrefPageComposite.this.prefs.setValue(string, ((Spinner)widget).getSelection());
        }
    };
    private IPreferenceStore prefs;
    List<Control> quickCtls = new LinkedList<Control>();
    private Spinner spnBbbThreshold;
    private Spinner spnDateThreshold;

    public FolderPrefPageComposite(Composite composite, int n, IPreferenceStore iPreferenceStore, Host host) {
        super(composite, n);
        this.prefs = iPreferenceStore;
        this.host = host;
        UIUtil.setHelpContextId((Control)composite, (String)StructContextId.FOLDER_PREF_PAGE);
        this.createControls();
        Dialog.applyDialogFont((Control)this);
        this.updateUIFromPrefs();
    }

    private Set<Comparison.Method> chosenMethod() {
        return DiffMethodUtil.fromInt((int)this.prefs.getInt(PrefKey.D_COMP_METHOD.toString()));
    }

    private Composite createBbbThresholdControls(Composite composite) {
        Composite composite2 = DialogUtil.createIndentComposite((Composite)composite, (int)3, (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 3;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 128, false, false));
        composite3.setLayout((Layout)gridLayout);
        this.chbBbbThreshold = this.createButton(composite3, 32, PrefKey.D_COMP_BBB_THRESHOLD_ON.toString());
        this.contentCtls.add((Control)this.chbBbbThreshold);
        this.chbBbbThreshold.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.chbBbbThreshold.setText(StructMsg.FolderPrefPage_bbbLargerThan);
        this.spnBbbThreshold = DialogUtil.createSpinner((Composite)composite3, (PrefKey)PrefKey.D_COMP_BBB_THRESHOLD, (int)9999, (SelectionListener)this.onSpinner);
        this.spnBbbThreshold.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentCtls.add((Control)this.spnBbbThreshold);
        this.lblBbbUnit = new Label(composite3, 0);
        this.lblBbbUnit.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.lblBbbUnit.setText(StructMsg.FolderPrefPage_bbbUnits);
        return composite2;
    }

    private Button createButton(Composite composite, int n, Comparison.Method method) {
        Button button = new Button(composite, n);
        button.setData((Object)method);
        button.addSelectionListener(this.onSelect);
        return button;
    }

    private Button createButton(Composite composite, int n, String string) {
        Button button = new Button(composite, n);
        button.setData((Object)string);
        button.addSelectionListener(this.onSelect);
        return button;
    }

    private void createContentDiffControls(Composite composite) {
        int n = this.isDashboardHost() ? 0 : -1;
        int n2 = this.isDashboardHost() ? 0 : -1;
        Composite composite2 = DialogUtil.createIndentComposite((Composite)composite, (int)1, (int)1, (int)n, (int)n2);
        Button button = this.createButton(composite2, 16, Comparison.Method.BYTE_BY_BYTE);
        button.setText(StructMsg.FolderPrefPage_bbb);
        this.contentCtls.add((Control)button);
        this.method2Btn.put(Comparison.Method.BYTE_BY_BYTE, button);
        Button button2 = this.createButton(composite2, 16, Comparison.Method.AS_TEXT);
        button2.setText(StructMsg.FolderPrefPage_asText);
        this.contentCtls.add((Control)button2);
        this.method2Btn.put(Comparison.Method.AS_TEXT, button2);
        Composite composite3 = this.createBbbThresholdControls(composite2);
        ((GridData)composite3.getLayoutData()).exclude = this.isDashboardHost();
    }

    protected void createControls() {
        if (this.isDashboardHost()) {
            Composite composite = new Composite((Composite)this, 0);
            composite.setLayout((Layout)DialogUtil.createGridLayout((int)2, (int)0, (int)0, (int)2));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)DialogUtil.createGridLayout((int)1, (int)0, (int)0, (int)0));
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite composite3 = new Composite(composite, 0);
            composite3.setLayout((Layout)DialogUtil.createGridLayout((int)1, (int)0, (int)0, (int)0));
            composite3.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createQuickDiffControls(composite2);
            this.chbContent = this.createButton(composite3, 32, PrefKey.D_COMP_BY_CONTENT.toString());
            this.chbContent.setLayoutData((Object)new GridData(4, 128, true, false));
            this.chbContent.setText(NLS.bind((String)StructMsg.FolderPrefPage_content, (Object)""));
            this.createContentDiffControls(composite3);
            this.setLayout((Layout)DialogUtil.createGridLayout((int)1, (int)0, (int)0, (int)0));
            this.setLayoutData(new GridData());
        } else {
            Label label = new Label((Composite)this, 0);
            label.setFont(BoldFontCache.get((Font)label.getFont()));
            label.setText(StructMsg.FolderPrefPage_compareBy);
            DialogUtil.insertSpace((Composite)this);
            this.createQuickDiffControls((Composite)this);
            DialogUtil.insertSpace((Composite)this);
            this.chbContent = this.createButton((Composite)this, 32, PrefKey.D_COMP_BY_CONTENT.toString());
            this.chbContent.setLayoutData((Object)new GridData(4, 128, true, false));
            this.chbContent.setText(NLS.bind((String)StructMsg.FolderPrefPage_content, (Object)""));
            this.createContentDiffControls((Composite)this);
            DialogUtil.insertSpace((Composite)this, (boolean)true);
            DialogUtil.addButton((Composite)this, (String)StructMsg.FolderPrefPage_collectInfoEx, (String)PrefKey.D_COLLECT_INFO_EX.toString(), null, (int)1, (SelectionListener)this.onSelect);
            this.setLayout((Layout)new GridLayout());
            this.setLayoutData(new GridData());
        }
    }

    private Control createDateTresholdControl(Composite composite) {
        this.chbDateThreshold = this.createButton(composite, 32, PrefKey.D_COMP_DATE_THRESHOLD_ON.toString());
        this.chbDateThreshold.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.chbDateThreshold.setText(this.isDashboardHost() ? StructMsg.FolderPrefPage_datePrecisionPreShort : StructMsg.FolderPrefPage_datePrecisionPre);
        this.quickCtls.add((Control)this.chbDateThreshold);
        this.spnDateThreshold = DialogUtil.createSpinner((Composite)composite, (PrefKey)PrefKey.D_COMP_DATE_THRESHOLD, (int)9999, (SelectionListener)this.onSpinner);
        this.spnDateThreshold.setDigits(3);
        this.spnDateThreshold.setIncrement(100);
        this.spnDateThreshold.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.quickCtls.add((Control)this.spnDateThreshold);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        label.setText(this.isDashboardHost() ? StructMsg.FolderPrefPage_datePrecisionPostShort : StructMsg.FolderPrefPage_datePrecisionPost);
        this.quickCtls.add((Control)label);
        return this.chbDateThreshold;
    }

    private Control createDaylightDiffsControl(Composite composite) {
        this.chbDaylight = this.createButton(composite, 32, PrefKey.D_COMP_IGNORE_DAYLIGHT_DIFFS.toString());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.chbDaylight.setLayoutData((Object)gridData);
        this.chbDaylight.setText(this.isDashboardHost() ? StructMsg.FolderPrefPage_daylightDiffsShort : StructMsg.FolderPrefPage_daylightDiffs);
        this.quickCtls.add((Control)this.chbDaylight);
        return this.chbDaylight;
    }

    private void createQuickDiffControls(Composite composite) {
        Button button;
        Comparison.Method[] methodArray = new Comparison.Method[]{Comparison.Method.SIZE, Comparison.Method.ATTRIBUTES, Comparison.Method.DATE_MODIFIED};
        String[] stringArray = new String[]{StructMsg.FolderPrefPage_size, OS.WIN ? StructMsg.FolderPrefPage_attributes : StructMsg.FolderPrefPage_permissions, StructMsg.FolderPrefPage_date};
        int n = methodArray.length;
        assert (n == stringArray.length);
        int n2 = 0;
        while (n2 < n) {
            Comparison.Method method = methodArray[n2];
            button = this.createButton(composite, 32, method);
            button.setLayoutData((Object)new GridData(4, 128, true, false));
            button.setText(stringArray[n2]);
            this.quickCtls.add((Control)button);
            this.method2Btn.put(method, button);
            ++n2;
        }
        n2 = this.isDashboardHost() ? 0 : -1;
        int n3 = this.isDashboardHost() ? 2 : -1;
        button = DialogUtil.createIndentComposite((Composite)composite, (int)3, (int)1, (int)n2, (int)n3);
        ((GridLayout)button.getLayout()).horizontalSpacing = 0;
        this.createTimezoneDiffsControl((Composite)button);
        this.createDaylightDiffsControl((Composite)button);
        this.createDateTresholdControl((Composite)button);
        ((GridData)button.getLayoutData()).exclude = this.isDashboardHost();
    }

    private Control createTimezoneDiffsControl(Composite composite) {
        this.chbTimezone = this.createButton(composite, 32, PrefKey.D_COMP_IGNORE_TIMEZONE_DIFFS.toString());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.chbTimezone.setLayoutData((Object)gridData);
        this.chbTimezone.setText(this.isDashboardHost() ? StructMsg.FolderPrefPage_timezoneDiffsShort : StructMsg.FolderPrefPage_timezoneDiffs);
        this.quickCtls.add((Control)this.chbTimezone);
        return this.chbTimezone;
    }

    public void dispose() {
        try {
            for (Button button : this.method2Btn.values()) {
                button.dispose();
            }
            this.method2Btn.clear();
            if (this.prefs instanceof OverlayPrefStore) {
                ((OverlayPrefStore)this.prefs).stop();
            }
            if (this.prefs != null) {
                this.prefs.removePropertyChangeListener(this.onProp);
            }
            this.prefs = null;
        }
        finally {
            super.dispose();
        }
    }

    public Host host() {
        return this.host;
    }

    private boolean isDashboardHost() {
        return this.host == Host.PREF_DASHBOARD;
    }

    public void performDefaults() {
        if (this.prefs instanceof OverlayPrefStore) {
            ((OverlayPrefStore)this.prefs).loadDefaults();
        }
        this.updateUIFromPrefs();
        App.instance().stateBoss().saveState();
    }

    public boolean performOk() {
        Display display;
        Control control;
        if (OS.OSX && !this.isDisposed() && (control = (display = this.getDisplay()).getFocusControl()) instanceof Spinner) {
            Event event = new Event();
            event.keyCode = 9;
            event.type = 1;
            display.post(event);
            display.readAndDispatch();
            event.type = 2;
            display.post(event);
            display.readAndDispatch();
        }
        if (this.prefs instanceof OverlayPrefStore) {
            ((OverlayPrefStore)this.prefs).propagate();
        }
        return true;
    }

    public void setPreferences(IPreferenceStore iPreferenceStore, IPreferenceStore iPreferenceStore2) {
        if (iPreferenceStore != null) {
            iPreferenceStore.removePropertyChangeListener(this.onProp);
        }
        if (iPreferenceStore2 != null) {
            iPreferenceStore2.addPropertyChangeListener(this.onProp);
        }
        this.prefs = iPreferenceStore2;
        this.updateUIFromPrefs();
    }

    private void updateBbbThresholdControlUI() {
        Set<Comparison.Method> set = this.chosenMethod();
        boolean bl = set.contains(Comparison.Method.AS_TEXT) && this.prefs.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString());
        this.chbBbbThreshold.setEnabled(bl);
        this.spnBbbThreshold.setEnabled(bl && this.prefs.getBoolean(PrefKey.D_COMP_BBB_THRESHOLD_ON.toString()));
        this.lblBbbUnit.setEnabled(bl);
    }

    private void updateControlUI() {
        boolean bl = this.prefs.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString());
        for (Control control : this.quickCtls) {
            control.setEnabled(!bl);
        }
        for (Control control : this.contentCtls) {
            control.setEnabled(bl);
        }
        if (!this.method2Btn.get(Comparison.Method.BYTE_BY_BYTE).getSelection()) {
            this.method2Btn.get(Comparison.Method.AS_TEXT).setSelection(true);
        }
        this.updateBbbThresholdControlUI();
        this.updateDateControlUI();
    }

    private void updateDateControlUI() {
        Set<Comparison.Method> set = this.chosenMethod();
        boolean bl = set.contains(Comparison.Method.DATE_MODIFIED) && !this.prefs.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString());
        this.chbDaylight.setEnabled(bl);
        this.chbTimezone.setEnabled(bl);
        this.chbDateThreshold.setEnabled(bl);
        this.spnDateThreshold.setEnabled(bl && this.prefs.getBoolean(PrefKey.D_COMP_DATE_THRESHOLD_ON.toString()));
    }

    private void updatePrefsFromUI() {
        EnumSet<Comparison.Method> enumSet = EnumSet.noneOf(Comparison.Method.class);
        for (Comparison.Method method : this.method2Btn.keySet()) {
            Button button = this.method2Btn.get(method);
            if (!button.getSelection()) continue;
            enumSet.add(method);
        }
        this.prefs.setValue(PrefKey.D_COMP_METHOD.toString(), DiffMethodUtil.toInt(enumSet));
    }

    public void updateUIFromPrefs() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                Button button;
                Control control;
                Control[] controlArray = ControlUtil.getChildren((Control)FolderPrefPageComposite.this, Button.class);
                Set set = FolderPrefPageComposite.this.chosenMethod();
                if (LOG.isInfoEnabled()) {
                    LOG.info(set + " : " + set);
                }
                Control[] controlArray2 = controlArray;
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    control = controlArray2[n2];
                    button = (Button)control;
                    int n3 = button.getStyle();
                    if (32 == (n3 & 0x20) || 16 == (n3 & 0x10)) {
                        Object object = button.getData();
                        if (object instanceof Comparison.Method) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info(button + " selected: " + set.contains(object));
                            }
                            button.setSelection(set.contains(object));
                        } else if (object instanceof String) {
                            String string = (String)button.getData();
                            button.setSelection(FolderPrefPageComposite.this.prefs.getBoolean(string));
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    FolderPrefPageComposite.this.updateControlUI();
                    ++n2;
                }
                controlArray2 = controlArray = ControlUtil.getChildren((Control)FolderPrefPageComposite.this, Spinner.class);
                n = controlArray.length;
                n2 = 0;
                while (n2 < n) {
                    control = controlArray2[n2];
                    button = (Spinner)control;
                    String string = (String)control.getData();
                    if (LOG.isInfoEnabled()) {
                        LOG.info(button + " value: " + FolderPrefPageComposite.this.prefs.getInt(string));
                    }
                    button.setSelection(FolderPrefPageComposite.this.prefs.getInt(string));
                    if (LOG.isInfoEnabled()) {
                        LOG.info(button + " value: " + button.getSelection());
                    }
                    ++n2;
                }
            }
        });
    }

    public static enum Host {
        DEFAULT_PREF_PAGE,
        PREF_DASHBOARD,
        PREF_PAGE;

    }
}

