/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.Addon;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.FilterTable;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.script.Filter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructContextId;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterDialog;
import com.deltawalker.text.Filters;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.BaseFiltersPrefPage;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FolderFiltersPrefPage
extends BaseFiltersPrefPage {
    private Menu menu;

    protected void addFilterControls(Composite composite) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(4, 1024, true, false);
        gridData.widthHint = OS.GTK ? 400 : this.filterTable.getBounds().width;
        label.setLayoutData((Object)gridData);
        label.setText(StructMsg.FolderFiltersPrefPage_info);
    }

    protected void addToolBarItems() {
        final ToolItem toolItem = this.toolBar.getItem(BaseFiltersPrefPage.Item.NEW.id());
        this.menu = new Menu((Control)this.toolBar);
        MenuItem menuItem = new MenuItem(this.menu, 8);
        menuItem.setText(FolderFilter.Type.PATH.toString());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.showFilterDialog(true, FolderFilter.Type.PATH);
            }
        });
        menuItem = new MenuItem(this.menu, 8);
        menuItem.setText(FolderFilter.Type.TIME.toString());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.showFilterDialog(true, FolderFilter.Type.TIME);
            }
        });
        menuItem = new MenuItem(this.menu, 8);
        menuItem.setText(FolderFilter.Type.SIZE.toString());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.showFilterDialog(true, FolderFilter.Type.SIZE);
            }
        });
        menuItem = new MenuItem(this.menu, 8);
        menuItem.setText(FolderFilter.Type.ATTRIBUTE.toString());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.showFilterDialog(true, FolderFilter.Type.ATTRIBUTE);
            }
        });
        menuItem = new MenuItem(this.menu, 8);
        String string = FolderFilter.Type.ALIGN.toString();
        if (AddonInfoUtil.addonInfo().edition() == Addon.Edition.STANDARD) {
            menuItem.setText(String.valueOf(string) + NLS.bind((String)UIMsg.LicensedAction_availableIn_one, (Object)Addon.Edition.ORO.displayName()));
            menuItem.setEnabled(false);
        } else {
            menuItem.setText(string);
        }
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.showFilterDialog(true, FolderFilter.Type.ALIGN);
            }
        });
        toolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = toolItem.getBounds();
                Point point = FolderFiltersPrefPage.this.toolBar.toDisplay(rectangle.x, rectangle.y + rectangle.height);
                FolderFiltersPrefPage.this.menu.setLocation(point);
                FolderFiltersPrefPage.this.menu.setVisible(true);
            }
        });
        ToolItem toolItem2 = new ToolItem(this.toolBar, 2);
        toolItem2.setWidth(60);
        toolItem2.setControl((Control)new Label((Composite)this.toolBar, 0));
        ToolItem toolItem3 = new ToolItem(this.toolBar, 8);
        toolItem3.setText(StructMsg.FolderFiltersPrefPage_down);
        toolItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.moveUpDown(false);
            }
        });
        ToolItem toolItem4 = new ToolItem(this.toolBar, 8);
        toolItem4.setText(StructMsg.FolderFiltersPrefPage_up);
        toolItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderFiltersPrefPage.this.moveUpDown(true);
            }
        });
    }

    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, (String)StructContextId.FOLDER_FILTERS_PREF_PAGE);
        return super.createContents(composite);
    }

    protected void createFilterTable(Composite composite) {
        this.filterTable = new FilterTable(composite, 0, this.overlayFilters()){

            protected String getColumnText(Object object, int n) {
                IFolderFilter iFolderFilter = (IFolderFilter)object;
                switch (n) {
                    case 0: {
                        return iFolderFilter.getDisplayExpression();
                    }
                    case 1: {
                        return iFolderFilter.target().toString();
                    }
                    case 2: {
                        return iFolderFilter.action().toString();
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return "";
            }

            protected Object[] getFilterElements(List<IFilter> list) {
                return FolderFiltersPrefPage.this.getFolderFilters(list).toArray();
            }

            protected void setupTable(Table table) {
                TableColumn tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(StructMsg.FolderFiltersPrefPage_filter);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(64));
                tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(StructMsg.FolderFiltersPrefPage_target);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(20));
                tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(StructMsg.FolderFiltersPrefPage_action);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(16));
            }
        };
        this.filterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filterTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                FolderFiltersPrefPage.this.updateToolBarItems();
            }
        });
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        super.dispose();
    }

    protected DocType docType() {
        return DocType.FOLDER;
    }

    private List<IFolderFilter> getFolderFilters(List<IFilter> list) {
        ArrayList<IFolderFilter> arrayList = new ArrayList<IFolderFilter>(list.size());
        for (IFilter iFilter : list) {
            if (!(iFilter instanceof IFolderFilter)) continue;
            arrayList.add((IFolderFilter)iFilter);
        }
        return arrayList;
    }

    protected IFilters getGlobalFilters() {
        return App.instance().filterBoss().getDefaultFilters(DocType.FOLDER);
    }

    protected int getNewItemStyle() {
        return 4;
    }

    protected void handleEdit() {
        this.showFilterDialog(false, null);
    }

    protected void handleNew(ToolItem toolItem) {
        Rectangle rectangle = toolItem.getBounds();
        Point point = this.toolBar.toDisplay(rectangle.x, rectangle.y + rectangle.height);
        this.menu.setLocation(point);
        this.menu.setVisible(true);
    }

    private void moveUpDown(boolean bl) {
        FolderFilter folderFilter = this.selectedFilter();
        if (folderFilter != null) {
            Filters.moveUpDown((IFilters)this.overlayFilters(), (Filter)folderFilter, (boolean)bl);
            this.updateToolBarItems();
            this.filterTable.refresh(null);
            this.filterTable.setSelection((IFilter)folderFilter);
        }
    }

    public void performHelp() {
        UIUtil.showHelp((String)"folder-comparisons-filters", (UIUtil.HelpContext)UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        this.activeFilters().makeSame(this.overlayFilters());
        return true;
    }

    protected FolderFilter selectedFilter() {
        return (FolderFilter)super.selectedFilter();
    }

    protected void showFilterDialog(boolean bl, FolderFilter.Type type) {
        FolderFilter folderFilter = bl ? null : this.selectedFilter();
        FolderFilterDialog folderFilterDialog = new FolderFilterDialog(this.getShell(), this.getPreferenceStore(), folderFilter, type);
        if (folderFilterDialog.open() == 0) {
            FolderFilter folderFilter2 = folderFilterDialog.filter();
            if (folderFilter2 == null) {
                return;
            }
            IFilters iFilters = this.overlayFilters();
            int n = iFilters.getAllAsList().indexOf(folderFilter);
            if (n != -1) {
                iFilters.remove(n);
                iFilters.add((Filter)folderFilter2, n);
            } else {
                iFilters.add((Filter)folderFilter2);
            }
            this.filterTable.refresh(null);
            this.filterTable.setSelection((IFilter)folderFilter2);
        }
        this.filterTable.setFocus();
    }

    protected void updateToolBarItems() {
        int n;
        int n2;
        ToolItem toolItem;
        ToolItem[] toolItemArray;
        if (this.toolBar.isDisposed()) {
            return;
        }
        FolderFilter folderFilter = this.selectedFilter();
        boolean bl = false;
        if (folderFilter != null) {
            toolItemArray = this.overlayFilters();
            toolItem = this.getFolderFilters(toolItemArray.getAllAsList());
            n2 = toolItem.indexOf(folderFilter);
            n = toolItem.size();
            bl = n2 > 0;
        } else {
            n2 = -1;
            n = 0;
        }
        ToolItem[] toolItemArray2 = toolItemArray = this.toolBar.getItems();
        int n3 = toolItemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            toolItem = toolItemArray2[n4];
            int n5 = this.toolBar.indexOf(toolItem);
            if (n5 == BaseFiltersPrefPage.Item.EDIT.id() || n5 == BaseFiltersPrefPage.Item.DELETE.id()) {
                toolItem.setEnabled(bl);
            } else if (n5 == BaseFiltersPrefPage.Item.UP.id()) {
                toolItem.setEnabled(n2 > 1);
            } else if (n5 == BaseFiltersPrefPage.Item.DOWN.id()) {
                toolItem.setEnabled(bl && n2 < n - 1);
            }
            ++n4;
        }
    }
}

