/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructContextId;
import com.deltawalker.structure.internal.ui.dialogs.AlignFilterComposite;
import com.deltawalker.structure.internal.ui.dialogs.AttributeFilterComposite;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterComposite;
import com.deltawalker.structure.internal.ui.dialogs.PathFilterComposite;
import com.deltawalker.structure.internal.ui.dialogs.SizeFilterComposite;
import com.deltawalker.structure.internal.ui.dialogs.TimeFilterComposite;
import com.deltawalker.ui.UIUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class FolderFilterDialog
extends TrayDialog {
    private FolderFilterComposite cmpFilter;
    private FolderFilter filter;
    private final FolderFilter.Type filterType;
    private IPreferenceStore prefs;

    public FolderFilterDialog(Shell shell, IPreferenceStore iPreferenceStore, FolderFilter folderFilter, FolderFilter.Type type) {
        super(shell);
        this.prefs = iPreferenceStore;
        this.filter = folderFilter;
        this.filterType = type;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UIUtil.setHelpContextId((Control)shell, (String)StructContextId.FOLDER_FILTER_DIALOG);
        shell.setText(this.filter == null ? StructMsg.FolderFilterDialog_newFilter : StructMsg.FolderFilterDialog_editFilter);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = new Label(composite2, 0);
        FolderFilter.Type type = this.filter != null ? this.filter.type() : this.filterType;
        String string = type == FolderFilter.Type.ALIGN || type == FolderFilter.Type.ATTRIBUTE ? "n" : "";
        label.setText(NLS.bind((String)StructMsg.FolderFilterDialog_hint, (Object)string, (Object)type.toString()));
        switch (type) {
            case PATH: {
                this.cmpFilter = new PathFilterComposite(composite2, this.prefs, this.filter);
                break;
            }
            case TIME: {
                this.cmpFilter = new TimeFilterComposite(composite2, this.prefs, this.filter);
                break;
            }
            case SIZE: {
                this.cmpFilter = new SizeFilterComposite(composite2, this.prefs, this.filter);
                break;
            }
            case ATTRIBUTE: {
                this.cmpFilter = new AttributeFilterComposite(composite2, this.prefs, this.filter);
                break;
            }
            case ALIGN: {
                this.cmpFilter = new AlignFilterComposite(composite2, this.prefs, this.filter);
            }
        }
        this.cmpFilter.setLayoutData(new GridData(1808));
        FolderFilterDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public FolderFilter filter() {
        return this.filter;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    protected void helpPressed() {
        UIUtil.showHelp((String)this.cmpFilter.helpTopic(), (UIUtil.HelpContext)UIUtil.HelpContext.DIALOG);
    }

    protected void okPressed() {
        if (this.cmpFilter.isFilterInfoValid()) {
            this.filter = this.cmpFilter.getFilter();
            super.okPressed();
        }
    }
}

