/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.FolderFilter;
import com.deltawalker.ui.dialogs.AlertComposite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class FolderFilterComposite
extends AlertComposite {
    protected Combo cbAction;
    protected Combo cbTarget;
    private FolderFilter filter;
    protected final IPreferenceStore prefs;

    public FolderFilterComposite(Composite composite, IPreferenceStore iPreferenceStore, FolderFilter folderFilter) {
        super(composite, 0);
        this.prefs = iPreferenceStore;
        this.filter = folderFilter;
        this.createControls();
    }

    protected void createActionCombo() {
        this.cbAction = new Combo((Composite)this, 12);
        this.cbAction.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbAction.add(FolderFilter.Action.EXCLUDE.toString());
        this.cbAction.add(FolderFilter.Action.INCLUDE.toString());
    }

    protected void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
    }

    protected void createTargetCombo() {
        FolderFilter.Target[] targetArray;
        this.cbTarget = new Combo((Composite)this, 12);
        this.cbTarget.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        FolderFilter.Target[] targetArray2 = targetArray = new FolderFilter.Target[]{FolderFilter.Target.BOTH, FolderFilter.Target.FILES, FolderFilter.Target.FOLDERS};
        int n = targetArray.length;
        int n2 = 0;
        while (n2 < n) {
            FolderFilter.Target target = targetArray2[n2];
            this.cbTarget.add(target.toString());
            ++n2;
        }
    }

    public FolderFilter getFilter() {
        return this.filter;
    }

    protected IPreferenceStore getPreferences() {
        return this.prefs;
    }

    protected FolderFilter.Action getSelectedAction() {
        return FolderFilter.Action.fromInt((int)this.cbAction.getSelectionIndex());
    }

    protected FolderFilter.Target getSelectedTarget() {
        return FolderFilter.Target.fromInt((int)this.cbTarget.getSelectionIndex());
    }

    public String getText() {
        return this.getType().toString();
    }

    public abstract FolderFilter.Type getType();

    public abstract String helpTopic();

    protected void initializeControls() {
        FolderFilter folderFilter = this.getFilter();
        if (folderFilter == null) {
            this.cbAction.select(0);
            this.cbTarget.select(0);
        } else {
            this.cbAction.select(folderFilter.action().toInt());
            this.cbTarget.select(folderFilter.target().toInt());
        }
    }

    protected abstract boolean isFilterInfoValid();

    protected void setFilter(FolderFilter folderFilter) {
        this.filter = folderFilter;
    }
}

