/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.StructMsg;
import com.deltopia.ui.OSFileDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;

public final class ChooseEditorDialog
extends Dialog {
    private static final String[] execFilters;
    private static boolean EXTERNAL_APPS_ONLY;
    private static final String STORE_ID_INTERNAL_EXTERNAL = "ChooseEditorDialog.STORE_ID";
    private static final int TABLE_WIDTH = 200;
    private Button btnBrowse;
    private Button btnExternal;
    private Button btnInternal;
    private Button btnOk;
    private IEditorDescriptor[] editorsToFilter;
    private Table editorTable;
    private IEditorDescriptor[] extEditors;
    private Image[] extImages;
    private IEditorDescriptor[] intEditors;
    private Image[] intImages;
    private String message = StructMsg.ChooseEditor_defaultHint;
    private DialogListener onDialog = new DialogListener();
    private EditorDescriptor selectedEditor;

    static {
        EXTERNAL_APPS_ONLY = true;
        execFilters = Util.isWindows() ? new String[]{"*.exe", "*.bat", "*.*"} : new String[]{"*"};
    }

    public ChooseEditorDialog(Shell shell) {
        super(shell);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.writePrefs();
        }
        super.buttonPressed(n);
    }

    public boolean close() {
        int n;
        if (this.intImages != null) {
            n = 0;
            while (n < this.intImages.length) {
                this.intImages[n].dispose();
                ++n;
            }
            this.intImages = null;
        }
        if (this.extImages != null) {
            n = 0;
            while (n < this.extImages.length) {
                this.extImages[n].dispose();
                ++n;
            }
            this.extImages = null;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StructMsg.ChooseEditor_title);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.btnOk = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.btnOk.setEnabled(false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        Label label = new Label(composite2, 0);
        label.setText(this.message);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        if (!EXTERNAL_APPS_ONLY) {
            this.createRadioButtons(composite2);
        }
        this.editorTable = new Table(composite2, 2052);
        this.editorTable.addListener(13, (Listener)this.onDialog);
        this.editorTable.addListener(14, (Listener)this.onDialog);
        this.editorTable.addListener(8, (Listener)this.onDialog);
        gridData = new GridData();
        gridData.widthHint = this.convertHorizontalDLUsToPixels(200);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.editorTable.setLayoutData((Object)gridData);
        gridData.heightHint = this.editorTable.getItemHeight() * 12;
        this.btnBrowse = new Button(composite2, 8);
        this.btnBrowse.setText(StructMsg.ChooseEditor_browse);
        this.btnBrowse.addListener(13, (Listener)this.onDialog);
        gridData = new GridData();
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, this.btnBrowse.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnBrowse.setLayoutData((Object)gridData);
        this.readPrefs();
        this.fillEditorTable();
        this.updateEnableState();
        return composite2;
    }

    private void createRadioButtons(Composite composite) {
        this.btnInternal = new Button(composite, 16400);
        this.btnInternal.setText(StructMsg.ChooseEditor_internal);
        this.btnInternal.addListener(13, (Listener)this.onDialog);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.btnInternal.setLayoutData((Object)gridData);
        this.btnExternal = new Button(composite, 16400);
        this.btnExternal.setText(StructMsg.ChooseEditor_external);
        this.btnExternal.addListener(13, (Listener)this.onDialog);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.btnExternal.setLayoutData((Object)gridData);
    }

    protected void fillEditorTable() {
        Image[] imageArray;
        IEditorDescriptor[] iEditorDescriptorArray;
        boolean bl;
        this.editorTable.removeAll();
        this.editorTable.update();
        boolean bl2 = bl = EXTERNAL_APPS_ONLY ? false : this.btnInternal.getSelection();
        if (bl) {
            iEditorDescriptorArray = this.getInternalEditors();
            imageArray = this.intImages;
        } else {
            iEditorDescriptorArray = this.getExternalEditors();
            imageArray = this.extImages;
        }
        this.editorTable.setRedraw(false);
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            TableItem tableItem = new TableItem(this.editorTable, 0);
            tableItem.setData((Object)iEditorDescriptorArray[n]);
            tableItem.setText(iEditorDescriptorArray[n].getLabel());
            tableItem.setImage(imageArray[n]);
            ++n;
        }
        this.editorTable.setRedraw(true);
    }

    protected IEditorDescriptor[] filterEditors(IEditorDescriptor[] iEditorDescriptorArray) {
        if (iEditorDescriptorArray == null || iEditorDescriptorArray.length < 1) {
            return iEditorDescriptorArray;
        }
        if (this.editorsToFilter == null || this.editorsToFilter.length < 1) {
            return iEditorDescriptorArray;
        }
        ArrayList<IEditorDescriptor> arrayList = new ArrayList<IEditorDescriptor>();
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.editorsToFilter.length) {
                if (iEditorDescriptorArray[n].getId().equals(this.editorsToFilter[n2].getId())) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                arrayList.add(iEditorDescriptorArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IEditorDescriptor[arrayList.size()]);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("EditorSelectionDialog");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("EditorSelectionDialog");
        }
        return iDialogSettings2;
    }

    protected IEditorDescriptor[] getExternalEditors() {
        if (this.extEditors == null) {
            Composite composite;
            Shell shell = this.getShell();
            if (!shell.isVisible() && (composite = shell.getParent()) != null) {
                shell = composite;
            }
            composite = new Cursor((Device)shell.getDisplay(), 1);
            shell.setCursor((Cursor)composite);
            EditorRegistry editorRegistry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.extEditors = editorRegistry.getSortedEditorsFromOS();
            this.extEditors = this.filterEditors(this.extEditors);
            this.extImages = this.getImages(this.extEditors);
            shell.setCursor(null);
            composite.dispose();
        }
        return this.extEditors;
    }

    protected Image[] getImages(IEditorDescriptor[] iEditorDescriptorArray) {
        Image[] imageArray = new Image[iEditorDescriptorArray.length];
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            imageArray[n] = iEditorDescriptorArray[n].getImageDescriptor().createImage();
            ++n;
        }
        return imageArray;
    }

    protected IEditorDescriptor[] getInternalEditors() {
        if (this.intEditors == null) {
            EditorRegistry editorRegistry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.intEditors = editorRegistry.getSortedEditorsFromPlugins();
            this.intEditors = this.filterEditors(this.intEditors);
            this.intImages = this.getImages(this.intEditors);
        }
        return this.intEditors;
    }

    public IEditorDescriptor getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void handleDoubleClickEvent() {
        this.buttonPressed(0);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void promptForExternalEditor() {
        OSFileDialog oSFileDialog = new OSFileDialog(this.getShell(), 36864);
        oSFileDialog.setFilterExtensions(execFilters);
        String string = oSFileDialog.open();
        if (string != null) {
            EditorDescriptor editorDescriptor = EditorDescriptor.createForProgram((String)string);
            TableItem tableItem = new TableItem(this.editorTable, 0);
            tableItem.setData((Object)editorDescriptor);
            tableItem.setText(editorDescriptor.getLabel());
            Image image = editorDescriptor.getImageDescriptor().createImage();
            tableItem.setImage(image);
            this.editorTable.setSelection(new TableItem[]{tableItem});
            this.editorTable.showSelection();
            this.editorTable.setFocus();
            this.selectedEditor = editorDescriptor;
            IEditorDescriptor[] iEditorDescriptorArray = new IEditorDescriptor[this.extEditors.length + 1];
            System.arraycopy(this.extEditors, 0, iEditorDescriptorArray, 0, this.extEditors.length);
            iEditorDescriptorArray[iEditorDescriptorArray.length - 1] = editorDescriptor;
            this.extEditors = iEditorDescriptorArray;
            Image[] imageArray = new Image[this.extImages.length + 1];
            System.arraycopy(this.extImages, 0, imageArray, 0, this.extImages.length);
            imageArray[imageArray.length - 1] = image;
            this.extImages = imageArray;
        }
    }

    protected void readPrefs() {
        if (!EXTERNAL_APPS_ONLY) {
            IDialogSettings iDialogSettings = this.getDialogSettings();
            boolean bl = iDialogSettings.getBoolean(STORE_ID_INTERNAL_EXTERNAL);
            this.btnInternal.setSelection(!bl);
            this.btnExternal.setSelection(bl);
        }
    }

    public void setEditorsToFilter(IEditorDescriptor[] iEditorDescriptorArray) {
        this.editorsToFilter = iEditorDescriptorArray;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    protected void updateEnableState() {
        if (!EXTERNAL_APPS_ONLY) {
            boolean bl = this.btnExternal.getSelection();
            this.btnBrowse.setEnabled(bl);
        }
        this.updateOkButton();
    }

    protected void updateOkButton() {
        if (this.btnOk == null) {
            return;
        }
        if (this.editorTable.getSelectionCount() == 0) {
            this.btnOk.setEnabled(false);
            return;
        }
        this.btnOk.setEnabled(this.selectedEditor != null);
    }

    protected void writePrefs() {
        if (!EXTERNAL_APPS_ONLY) {
            IDialogSettings iDialogSettings = this.getDialogSettings();
            iDialogSettings.put(STORE_ID_INTERNAL_EXTERNAL, !this.btnInternal.getSelection());
        }
    }

    private class DialogListener
    implements Listener {
        private DialogListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 8) {
                ChooseEditorDialog.this.handleDoubleClickEvent();
                return;
            }
            if (event.widget == ChooseEditorDialog.this.btnExternal) {
                ChooseEditorDialog.this.fillEditorTable();
            } else if (event.widget == ChooseEditorDialog.this.btnBrowse) {
                ChooseEditorDialog.this.promptForExternalEditor();
            } else if (event.widget == ChooseEditorDialog.this.editorTable) {
                if (ChooseEditorDialog.this.editorTable.getSelectionIndex() != -1) {
                    ChooseEditorDialog.this.selectedEditor = (EditorDescriptor)ChooseEditorDialog.this.editorTable.getSelection()[0].getData();
                } else {
                    ChooseEditorDialog.this.selectedEditor = null;
                    ChooseEditorDialog.this.btnOk.setEnabled(false);
                }
            }
            ChooseEditorDialog.this.updateEnableState();
        }
    }
}

