/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.AttributeFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterComposite;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class AttributeFilterComposite
extends FolderFilterComposite {
    private Combo cbAttribs;

    public AttributeFilterComposite(Composite composite, IPreferenceStore iPreferenceStore, FolderFilter folderFilter) {
        super(composite, iPreferenceStore, folderFilter);
    }

    private void createAttributeCombo() {
        this.cbAttribs = new Combo((Composite)this, 12);
        this.cbAttribs.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Set set = AttributeFilter.Attribute.attributes();
        for (AttributeFilter.Attribute attribute : set) {
            this.cbAttribs.add(attribute.displayName());
        }
        this.cbAttribs.select(0);
        this.cbAttribs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = AttributeFilterComposite.this.cbAttribs.getText();
                if (AttributeFilter.Attribute.EXECUTABLE.displayName().equals(string)) {
                    AttributeFilterComposite.this.cbTarget.select(FolderFilter.Target.FILES.toInt());
                    AttributeFilterComposite.this.cbTarget.setEnabled(false);
                } else {
                    AttributeFilterComposite.this.cbTarget.setEnabled(true);
                }
            }
        });
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.createActionCombo();
        this.createAttributeCombo();
        this.createTargetCombo();
        this.initializeControls();
    }

    private AttributeFilter.Attribute getSelectedAttribute() {
        return AttributeFilter.Attribute.fromInt((int)this.cbAttribs.getSelectionIndex());
    }

    @Override
    public FolderFilter.Type getType() {
        return FolderFilter.Type.SIZE;
    }

    @Override
    public String helpTopic() {
        return "folder-comparison-attribute-filter";
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        AttributeFilter attributeFilter = (AttributeFilter)this.getFilter();
        if (attributeFilter != null) {
            this.cbAttribs.select(attributeFilter.attribute().toInt());
        }
    }

    @Override
    protected boolean isFilterInfoValid() {
        AttributeFilter attributeFilter = new AttributeFilter(this.getSelectedAction(), this.getSelectedAttribute(), this.getSelectedTarget(), true, "");
        this.setFilter((FolderFilter)attributeFilter);
        return true;
    }
}

