/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.dialogs;

import com.deltawalker.structure.AlignFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.dialogs.FolderFilterComposite;
import com.deltawalker.ui.UIMsg;
import com.deltopia.util.Const;
import java.util.Comparator;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AlignFilterComposite
extends FolderFilterComposite {
    private Button chbCase;
    private Button chbRegex;
    private Label lblHint;
    final Comparator<String> patternCompar = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            if (string.substring(0, 3).compareToIgnoreCase(string2.substring(0, 3)) == 0) {
                int n;
                int n2 = string.length();
                if (n2 == (n = string2.length())) {
                    return 0;
                }
                return n2 > n ? -1 : 1;
            }
            return string.compareToIgnoreCase(string2);
        }
    };
    private Text txtExp1;
    private Text txtExp2;
    private Text txtFolders;

    public AlignFilterComposite(Composite composite, IPreferenceStore iPreferenceStore, FolderFilter folderFilter) {
        super(composite, iPreferenceStore, folderFilter);
    }

    private void createApplyToControls() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)this.createLayoutData());
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label.setText(NLS.bind((String)StructMsg.AlignFilterComposite_applyTo, (Object)Const.PATTERN_SEPARATOR));
        this.txtFolders = new Text(composite, 2048);
        this.txtFolders.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtFolders.setToolTipText(StructMsg.AlignFilterComposite_applyToTooltip);
    }

    @Override
    protected void createControls() {
        super.createControls();
        GridLayout gridLayout = (GridLayout)this.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        this.createExpressionControls();
        this.createHintControls();
        this.createApplyToControls();
        this.initializeControls();
    }

    private void createExpressionControls() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = this.createLayout();
        gridLayout.verticalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)this.createLayoutData());
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label.setText(StructMsg.AlignFilterComposite_exp1);
        label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label.setText(StructMsg.AlignFilterComposite_exp2);
        this.txtExp1 = new Text(composite, 2048);
        this.txtExp1.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtExp2 = new Text(composite, 2048);
        this.txtExp2.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createHintControls() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = this.createLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)this.createLayoutData());
        this.lblHint = new Label(composite, 64);
        this.lblHint.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblHint.setText(NLS.bind((String)StructMsg.PathFilterComposite_regexHint, (Object)Const.PATTERN_SEPARATOR));
        this.chbRegex = new Button(composite, 32);
        this.chbRegex.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.chbRegex.setText(StructMsg.PathFilterComposite_regexType);
        this.chbRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AlignFilterComposite.this.showHintLabel(!AlignFilterComposite.this.chbRegex.getSelection());
            }
        });
        this.chbCase = new Button(composite, 32);
        this.chbCase.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.chbCase.setText(StructMsg.PathFilterComposite_caseSensitive);
    }

    private GridLayout createLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 20;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        return gridLayout;
    }

    private GridData createLayoutData() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        return gridData;
    }

    @Override
    public FolderFilter.Type getType() {
        return FolderFilter.Type.ALIGN;
    }

    @Override
    public String helpTopic() {
        return "folder-comparison-alignment-override-filter";
    }

    @Override
    protected void initializeControls() {
        AlignFilter alignFilter = (AlignFilter)this.getFilter();
        if (alignFilter != null) {
            boolean bl = alignFilter.isRegexType();
            this.chbRegex.setSelection(bl);
            this.chbCase.setSelection(alignFilter.getCaseSensitive());
            this.txtExp1.setText(alignFilter.getExpression());
            this.txtExp2.setText(alignFilter.getSecondaryExpression());
            this.txtFolders.setText(alignFilter.getApplyToFolders());
            this.showHintLabel(!bl);
        }
    }

    @Override
    protected boolean isFilterInfoValid() {
        String string = this.txtExp1.getText();
        String string2 = this.txtExp2.getText();
        if (string.length() == 0 || string2.length() == 0) {
            return false;
        }
        boolean bl = this.chbRegex.getSelection();
        boolean bl2 = this.chbCase.getSelection();
        try {
            AlignFilter alignFilter = new AlignFilter(string, string2, bl, bl2, this.txtFolders.getText(), true, "");
            this.setFilter((FolderFilter)alignFilter);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.showAlert(true, NLS.bind((String)UIMsg.RegexAlert_invalidRegex, (Object)patternSyntaxException.getMessage()), 1);
            return false;
        }
    }

    private void showHintLabel(boolean bl) {
        this.lblHint.setVisible(bl);
    }
}

