/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.script.Role;
import com.deltawalker.structure.IStructDiffModelImpl;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.TreeFilter;
import com.deltawalker.structure.internal.ui.NodeFilters;
import com.deltawalker.structure.internal.ui.PatternNodeFilter;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltopia.StringUtil;
import java.util.EnumSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class TreeFilterBoss
extends TreeFilter {
    private final PatternNodeFilter patternFilter = new PatternNodeFilter();
    private StructDiffView sdView;

    public TreeFilterBoss(String string) {
        super(string);
    }

    public void dispose() {
        super.dispose();
        this.sdView = null;
    }

    public Font getBoldFont(Object object, PatternNodeFilter patternNodeFilter, Role role) {
        if (this.textChanged && !StringUtil.isEmpty((String)this.text)) {
            patternNodeFilter.setPattern(this.getFilterText());
            if (!patternNodeFilter.matches((IDiffNode)object)) {
                return this.getBoldFont();
            }
        }
        return null;
    }

    protected TreeItem getFirstMatchingItem(TreeItem[] treeItemArray, Role role) {
        PatternNodeFilter patternNodeFilter = this.patternFilter;
        TreeItem[] treeItemArray2 = treeItemArray;
        if (treeItemArray.length != 0) {
            TreeItem treeItem = treeItemArray2[0];
            if (patternNodeFilter.matches((IDiffNode)treeItem.getData())) {
                return treeItem;
            }
            return this.getFirstMatchingItem(treeItem.getItems(), role);
        }
        return null;
    }

    public Font getFont() {
        return this.tree.getFont();
    }

    public PatternNodeFilter getPatternFilter(Role role) {
        return this.patternFilter;
    }

    public void initialize(StructDiffView structDiffView) {
        super.initialize((Composite)structDiffView.treeView(Role.REF));
        this.sdView = structDiffView;
    }

    protected boolean isDisposed() {
        return this.sdView == null || this.tree().isDisposed();
    }

    protected IStatus runRefreshJob(IProgressMonitor iProgressMonitor) {
        if (this.isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        String string = this.getFilterText();
        boolean bl = string != null && string.length() > 0;
        try {
            StructDiffModel structDiffModel = (StructDiffModel)this.sdView.deltaModel();
            NodeFilters nodeFilters = structDiffModel.nodeFilters();
            if (!nodeFilters.contains(this.patternFilter)) {
                nodeFilters.addFilter(this.patternFilter);
            }
            if (this.txtSearch != null) {
                this.patternFilter.setPattern(this.textChanged ? string : null);
                structDiffModel.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
            }
        }
        catch (Throwable throwable) {
            this.sdView.treeView(Role.REF).fullUpdate();
            this.sdView.birdsEye().redraw();
            if (this.textChanged || this.textCleared) {
                this.showClearButton(bl && !this.textCleared);
            }
            throw throwable;
        }
        this.sdView.treeView(Role.REF).fullUpdate();
        this.sdView.birdsEye().redraw();
        if (this.textChanged || this.textCleared) {
            this.showClearButton(bl && !this.textCleared);
        }
        return Status.OK_STATUS;
    }

    public TreeView tree() {
        return this.sdView.treeView(Role.REF);
    }
}

