/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.IStructElement;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IExceptionHandler;
import com.deltawalker.interfaces.IReplaceable;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.internal.resources.local.LocalFolderResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.SyncOp;
import com.deltawalker.structure.internal.ui.ConfirmReplaceDialog;
import com.deltawalker.structure.ui.actions.ElementWorkbenchAdapter;
import com.deltawalker.structure.ui.actions.Select;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.FileType;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.util.ArrayListUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncModel
extends EventManager
implements IMvcModel {
    private static final ExecutorService exec = Executors.newCachedThreadPool();
    private static final Logger LOG = LoggerFactory.getLogger(SyncModel.class);
    private IStructDiffModel sdModel;

    public SyncModel(IStructDiffModel iStructDiffModel) {
        this.sdModel = iStructDiffModel;
    }

    public void addListener(ISyncModelEventListener iSyncModelEventListener) {
        assert (this.getListeners().length == 0);
        this.addListenerObject(iSyncModelEventListener);
    }

    public int collectNodes(SyncOp syncOp, Role role, Role role2, SyncNodes syncNodes) {
        int n = 0;
        switch (syncOp) {
            case UPDATE: {
                if (role == null && role2 == null) {
                    syncNodes.newerIn1 = this.sdModel.getNewer(null, Role.ONE, Role.REF);
                    syncNodes.added = this.sdModel.getDeltasOfKind(Delta.Kind.ADDED);
                    syncNodes.newerIn0 = this.sdModel.getNewer(null, Role.REF, Role.ONE);
                    syncNodes.deleted = this.sdModel.getDeltasOfKind(Delta.Kind.DELETED);
                    n = syncNodes.newerIn1.size() + syncNodes.newerIn0.size() + syncNodes.added.size() + syncNodes.deleted.size();
                    break;
                }
                syncNodes.newerIn1 = this.sdModel.getNewer(null, role, role2);
                Delta.Kind kind = role == Role.ONE ? Delta.Kind.ADDED : Delta.Kind.DELETED;
                syncNodes.added = this.sdModel.getDeltasOfKind(kind);
                n = syncNodes.newerIn1.size() + syncNodes.added.size();
                break;
            }
            case MIRROR: {
                if (role == Role.REF) {
                    syncNodes.newerIn0 = this.sdModel.getNewer(null, role, role2);
                    syncNodes.newerIn1 = this.sdModel.getNewer(null, role2, role);
                } else {
                    syncNodes.newerIn0 = this.sdModel.getNewer(null, role2, role);
                    syncNodes.newerIn1 = this.sdModel.getNewer(null, role, role2);
                }
                Delta.Kind kind = role == Role.ONE ? Delta.Kind.ADDED : Delta.Kind.DELETED;
                syncNodes.added = this.sdModel.getDeltasOfKind(kind);
                kind = role == Role.ONE ? Delta.Kind.DELETED : Delta.Kind.ADDED;
                syncNodes.toDelete = this.sdModel.getDeltasOfKind(kind);
                n = syncNodes.newerIn0.size() + syncNodes.newerIn1.size() + syncNodes.added.size() + syncNodes.toDelete.size();
                break;
            }
        }
        return n;
    }

    public void confirmNodes(SyncNodes syncNodes, Role role, Role role2, ConfirmReplaceDialog.Choice[] choiceArray, IReplaceable iReplaceable, boolean[] blArray) {
        boolean bl = this.isMultiFileOwerwrite(syncNodes, role2);
        if (!this.confirmNodes(syncNodes, syncNodes.newerIn1, role, role2, bl, choiceArray, iReplaceable, blArray)) {
            return;
        }
        if (!this.confirmNodes(syncNodes, syncNodes.newerIn0, role, role2, bl, choiceArray, iReplaceable, blArray)) {
            return;
        }
        if (!this.confirmNodes(syncNodes, syncNodes.nodes, role, role2, bl, choiceArray, iReplaceable, blArray)) {
            return;
        }
    }

    public boolean confirmNodes(SyncNodes syncNodes, Set<IDiffNode> set, Role role, Role role2, boolean bl, ConfirmReplaceDialog.Choice[] choiceArray, IReplaceable iReplaceable, boolean[] blArray) {
        if (!(choiceArray[0] != ConfirmReplaceDialog.Choice.REPLACE_ALL && choiceArray[0] != ConfirmReplaceDialog.Choice.CANCEL || blArray[0])) {
            return false;
        }
        if (set == null) {
            return true;
        }
        Iterator<IDiffNode> iterator = set.iterator();
        while (iterator.hasNext()) {
            IDiffNode iDiffNode = iterator.next();
            if (StructDiffModel.isNullElement((Object)iDiffNode.getElement(role2))) continue;
            this.confirmOverwrite(iDiffNode, role, role2, bl, choiceArray, iReplaceable, blArray);
            if (!blArray[0]) {
                return false;
            }
            if (choiceArray[0] == ConfirmReplaceDialog.Choice.DONT_REPLACE) {
                iterator.remove();
                continue;
            }
            if (choiceArray[0] != ConfirmReplaceDialog.Choice.CANCEL) continue;
            syncNodes.clear();
            return false;
        }
        return true;
    }

    public void confirmNodes(SyncOp syncOp, SyncNodes syncNodes, Role role, Role role2, ConfirmReplaceDialog.Choice[] choiceArray, IReplaceable iReplaceable) {
        boolean[] blArray = new boolean[]{true};
        switch (syncOp) {
            case UPDATE: {
                if (role == null && role2 == null) {
                    Set<IDiffNode> set = syncNodes.newerIn0;
                    syncNodes.newerIn0 = null;
                    this.confirmNodes(syncNodes, Role.ONE, Role.REF, choiceArray, iReplaceable, blArray);
                    syncNodes.newerIn0 = set;
                    set = syncNodes.newerIn1;
                    syncNodes.newerIn1 = null;
                    this.confirmNodes(syncNodes, Role.REF, Role.ONE, choiceArray, iReplaceable, blArray);
                    syncNodes.newerIn1 = set;
                    break;
                }
            }
            case COPY: 
            case DELETE: 
            case MIRROR: {
                this.confirmNodes(syncNodes, role, role2, choiceArray, iReplaceable, blArray);
            }
        }
    }

    private void confirmOverwrite(final IDiffNode iDiffNode, final Role role, final Role role2, final boolean bl, final ConfirmReplaceDialog.Choice[] choiceArray, IReplaceable iReplaceable, boolean[] blArray) {
        boolean bl2;
        IResource iResource = (IResource)iDiffNode.getElement(role);
        IResource iResource2 = (IResource)iDiffNode.getElement(role2);
        boolean bl3 = bl2 = iResource2.getLastModifiedTime() > iResource.getLastModifiedTime();
        if (iReplaceable == null || !bl2 && !iReplaceable.shouldConfirm()) {
            if (choiceArray[0] == ConfirmReplaceDialog.Choice.DONT_REPLACE) {
                choiceArray[0] = ConfirmReplaceDialog.Choice.REPLACE;
            }
            return;
        }
        String string = iResource2.getType() == FileType.FILE ? StructMsg.ResourceMessage_confirmFileReplace : StructMsg.ResourceMessage_confirmFolderReplace;
        final Control control = this.getListener().getControl();
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                String string = SyncModel.this.constructOverwriteMessage(iDiffNode, role, role2, bl, bl2);
                ArrayList<ConfirmReplaceDialog.Choice> arrayList = new ArrayList<ConfirmReplaceDialog.Choice>(ConfirmReplaceDialog.Choice.values().length);
                if (bl) {
                    arrayList.add(ConfirmReplaceDialog.Choice.REPLACE);
                    arrayList.add(ConfirmReplaceDialog.Choice.REPLACE_ALL);
                    arrayList.add(ConfirmReplaceDialog.Choice.DONT_REPLACE);
                    arrayList.add(ConfirmReplaceDialog.Choice.CANCEL);
                } else {
                    arrayList.add(ConfirmReplaceDialog.Choice.REPLACE);
                    arrayList.add(ConfirmReplaceDialog.Choice.DONT_REPLACE);
                    arrayList.add(ConfirmReplaceDialog.Choice.CANCEL);
                }
                ConfirmReplaceDialog confirmReplaceDialog = new ConfirmReplaceDialog(control.getShell(), string2, string, 8, arrayList, ConfirmReplaceDialog.Choice.REPLACE);
                confirmReplaceDialog.create();
                int n = confirmReplaceDialog.open();
                choiceArray[0] = ConfirmReplaceDialog.Choice.fromId(n);
            }
        };
        Display display = control.getDisplay();
        if (!display.getThread().equals(Thread.currentThread())) {
            display.syncExec(runnable);
        } else {
            runnable.run();
        }
        if (blArray[0] && choiceArray[0] == ConfirmReplaceDialog.Choice.REPLACE_ALL && (!iReplaceable.shouldConfirm() && bl2 || !bl2)) {
            blArray[0] = false;
        }
    }

    private String constructOverwriteMessage(IDiffNode iDiffNode, Role role, Role role2, boolean bl, boolean bl2) {
        String string;
        IResource iResource = (IResource)iDiffNode.getElement(role2);
        boolean bl3 = iDiffNode.isSame();
        String string2 = iResource.isWritable() ? "" : StructMsg.ResourceMessage_readOnly;
        String string3 = string = bl2 || bl3 ? StructMsg.ResourceMessage_a : StructMsg.ResourceMessage_an;
        String string4 = bl3 ? "" : (bl2 ? StructMsg.ResourceMessage_newer : StructMsg.ResourceMessage_older);
        String string5 = !string2.isEmpty() && !string4.isEmpty() ? StructMsg.ResourceMessage_comma : "";
        boolean bl4 = this.sdModel.isThreeWay();
        String string6 = iResource.getType() == FileType.FILE ? NLS.bind((String)StructMsg.ResourceMessage_fileReplace, (Object[])new Object[]{string, string4, string5, string2, iResource.getName(), role2.getDisplayName(bl4), role.getDisplayName(bl4)}) : NLS.bind((String)StructMsg.ResourceMessage_folderReplace, (Object[])new Object[]{string, string4, string5, string2, iResource.getName(), role2.getDisplayName(bl4)});
        return string6;
    }

    public Set<IDiffNode> delete(Set<ElementWorkbenchAdapter> set, ISyncProgressMonitor iSyncProgressMonitor, IExceptionHandler iExceptionHandler) {
        HashSet<IDiffNode> hashSet;
        int n = set.size();
        boolean bl = n > 10;
        HashSet<IDiffNode> hashSet2 = hashSet = bl ? new HashSet<IDiffNode>(n) : Collections.emptySet();
        if (iExceptionHandler == null) {
            iExceptionHandler = this.getListener();
        }
        for (ElementWorkbenchAdapter elementWorkbenchAdapter : set) {
            try {
                IDiffNode iDiffNode = elementWorkbenchAdapter.node;
                IDiffNode iDiffNode2 = iDiffNode.getParent();
                if (bl && iDiffNode2 != null) {
                    iDiffNode2.enableUpdate(false);
                    hashSet.add(iDiffNode2);
                }
                iDiffNode.removeElement(elementWorkbenchAdapter.element, true, !bl, iSyncProgressMonitor);
            }
            catch (Throwable throwable) {
                if (iExceptionHandler != null) {
                    iExceptionHandler.handleException(throwable);
                }
                LOG.error("Error deleting resource", throwable);
            }
        }
        return hashSet;
    }

    public void dispose() {
    }

    private void done(final Set<IDiffNode> set) {
        final ISyncModelEventListener iSyncModelEventListener = this.getListener();
        try {
            iSyncModelEventListener.monitor().done();
        }
        catch (Throwable throwable) {
            LOG.error(null, throwable);
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!iSyncModelEventListener.isDisposed()) {
                    iSyncModelEventListener.done();
                }
                SyncModel.this.sdModel.recompare(set, false);
            }
        });
    }

    public Set<ElementWorkbenchAdapter> getElementAdapters(Set<IDiffNode> set, Role role) {
        LinkedHashSet<ElementWorkbenchAdapter> linkedHashSet = new LinkedHashSet<ElementWorkbenchAdapter>();
        for (IDiffNode iDiffNode : set) {
            IStructElement iStructElement = iDiffNode.getElement(role);
            if (iStructElement == null) continue;
            linkedHashSet.add(new ElementWorkbenchAdapter(iStructElement, iDiffNode, null));
        }
        return linkedHashSet;
    }

    public ISyncModelEventListener getListener() {
        Object[] objectArray = this.getListeners();
        assert (objectArray.length <= 1);
        return objectArray.length > 0 ? (ISyncModelEventListener)objectArray[0] : null;
    }

    public String getName() {
        return null;
    }

    public int getNodes(List<IDiffNode> list, Role role, Role role2, SyncNodes syncNodes) {
        syncNodes.nodes = new LinkedHashSet<IDiffNode>(list.size());
        if (list.isEmpty()) {
            return 0;
        }
        for (IDiffNode iDiffNode : list) {
            IStructElement iStructElement = iDiffNode.getElement(role);
            if (StructDiffModel.isNullElement((Object)iStructElement)) continue;
            syncNodes.nodes.add(iDiffNode);
        }
        this.sdModel.removeDescendants(new HashSet<IDiffNode>(syncNodes.nodes));
        return syncNodes.nodes.size();
    }

    public int getResourceCount(FileType fileType, Select select) {
        if (select != Select.CHANGED && select != Select.ADDED && select != Select.DELETED) assert (false);
        return 0;
    }

    public IDiffNode[] getSourceNodes(ElementWorkbenchAdapter[] elementWorkbenchAdapterArray, Role role) {
        IDiffNode[] iDiffNodeArray = new IDiffNode[elementWorkbenchAdapterArray.length];
        int n = 0;
        while (n < elementWorkbenchAdapterArray.length) {
            ElementWorkbenchAdapter elementWorkbenchAdapter = elementWorkbenchAdapterArray[n];
            IDiffNode iDiffNode = elementWorkbenchAdapter.node;
            if (iDiffNode != null && (iDiffNode = iDiffNode.getParent()) != null) {
                ((DiffNode)iDiffNode).deepEnableUpdate(false);
                iDiffNodeArray[n] = iDiffNode;
            }
            ++n;
        }
        return iDiffNodeArray;
    }

    private boolean hasEnoughSpace(IStructElement iStructElement, long l) {
        long l2;
        if (iStructElement instanceof LocalFolderResource && (l2 = ((LocalFolderResource)iStructElement).getUsableSpace()) <= l) {
            this.getListener().handleException(new IOException("No space left on device"));
            return false;
        }
        return true;
    }

    private boolean hasMultiDestinationResources(Set<IDiffNode> set, Role role) {
        if (set == null) {
            return false;
        }
        int n = 0;
        for (IDiffNode iDiffNode : set) {
            IStructElement iStructElement = iDiffNode.getElement(role);
            if (iStructElement == null || ((IResource)iStructElement).getType() == FileType.UNKNOWN || ++n < 2) continue;
            return true;
        }
        return false;
    }

    private boolean isMultiFileOwerwrite(SyncNodes syncNodes, Role role) {
        if (this.hasMultiDestinationResources(syncNodes.newerIn1, role)) {
            return true;
        }
        if (this.hasMultiDestinationResources(syncNodes.newerIn0, role)) {
            return true;
        }
        return this.hasMultiDestinationResources(syncNodes.nodes, role);
    }

    public void removeListener(SyncModelEventAdapter syncModelEventAdapter) {
        this.removeListenerObject(syncModelEventAdapter);
    }

    public void setName(String string) {
    }

    public void sync(final SyncOp syncOp, final Role role, final Role role2, final SyncNodes syncNodes, final long l) {
        final HashSet hashSet = new HashSet();
        exec.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ISyncModelEventListener iSyncModelEventListener = SyncModel.this.getListener();
                        iSyncModelEventListener.synchronizing();
                        ISyncProgressMonitor iSyncProgressMonitor = iSyncModelEventListener.monitor();
                        Map map = SyncModel.this.sdModel.getRootElements();
                        EnumSet<IDiffNode.SyncAction> enumSet = EnumSet.of(IDiffNode.SyncAction.COPY);
                        EnumSet<IDiffNode.SyncAction> enumSet2 = EnumSet.of(IDiffNode.SyncAction.MOVE);
                        switch (syncOp) {
                            case UPDATE: {
                                if (role == null && role2 == null) {
                                    int n = SyncModel.this.totalCount(syncNodes.newerIn1) + SyncModel.this.totalCount(syncNodes.added) + SyncModel.this.totalCount(syncNodes.newerIn0) + SyncModel.this.totalCount(syncNodes.deleted);
                                    iSyncProgressMonitor.beginTask(SyncOp.COPY.progressText(), l, n);
                                    if (!SyncModel.this.hasEnoughSpace((IStructElement)map.get(Role.REF), SyncModel.this.totalSize(syncNodes.newerIn1, Role.ONE))) break;
                                    hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.newerIn1, Role.ONE, Role.REF, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                    if (iSyncProgressMonitor.isCanceled() || !SyncModel.this.hasEnoughSpace((IStructElement)map.get(Role.REF), SyncModel.this.totalSize(syncNodes.added, Role.ONE))) break;
                                    hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.added, Role.ONE, Role.REF, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                    if (iSyncProgressMonitor.isCanceled() || !SyncModel.this.hasEnoughSpace((IStructElement)map.get(Role.ONE), SyncModel.this.totalSize(syncNodes.newerIn0, Role.REF))) break;
                                    hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.newerIn0, Role.REF, Role.ONE, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                    if (iSyncProgressMonitor.isCanceled() || !SyncModel.this.hasEnoughSpace((IStructElement)map.get(Role.ONE), SyncModel.this.totalSize(syncNodes.deleted, Role.REF))) break;
                                    hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.deleted, Role.REF, Role.ONE, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                    break;
                                }
                                int n = SyncModel.this.totalCount(syncNodes.newerIn1) + SyncModel.this.totalCount(syncNodes.added);
                                iSyncProgressMonitor.beginTask(SyncOp.COPY.progressText(), l, n);
                                if (!SyncModel.this.hasEnoughSpace((IStructElement)map.get(role2), SyncModel.this.totalSize(syncNodes.newerIn1, role))) break;
                                hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.newerIn1, role, role2, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                if (iSyncProgressMonitor.isCanceled()) break;
                                hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.added, role, role2, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                break;
                            }
                            case MIRROR: {
                                if (!syncNodes.toDelete.isEmpty()) {
                                    long l2 = SyncModel.this.totalSize(syncNodes.toDelete, role2);
                                    int n = syncNodes.toDelete.size();
                                    iSyncProgressMonitor.beginTask(SyncOp.DELETE.progressText(), l2, n);
                                    hashSet.addAll(SyncModel.this.delete(SyncModel.this.getElementAdapters(syncNodes.toDelete, role2), iSyncProgressMonitor, iSyncModelEventListener));
                                    if (iSyncProgressMonitor.isCanceled()) break;
                                }
                                if (!SyncModel.this.hasEnoughSpace((IStructElement)map.get(role2), SyncModel.this.totalSize(syncNodes.newerIn0, role)) || !SyncModel.this.hasEnoughSpace((IStructElement)map.get(role2), SyncModel.this.totalSize(syncNodes.newerIn1, role))) break;
                                int n = SyncModel.this.totalCount(syncNodes.newerIn0) + SyncModel.this.totalCount(syncNodes.newerIn1) + SyncModel.this.totalCount(syncNodes.added);
                                iSyncProgressMonitor.beginTask(SyncOp.COPY.progressText(), l, n);
                                hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.newerIn0, role, role2, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.newerIn1, role, role2, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                if (iSyncProgressMonitor.isCanceled() || !SyncModel.this.hasEnoughSpace((IStructElement)map.get(role2), SyncModel.this.totalSize(syncNodes.added, role))) break;
                                hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.added, role, role2, enumSet, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                break;
                            }
                            case COPY: 
                            case MOVE: {
                                if (!SyncModel.this.hasEnoughSpace((IStructElement)map.get(role2), l)) break;
                                int n = SyncModel.this.totalCount(syncNodes.nodes);
                                iSyncProgressMonitor.beginTask(syncOp.progressText(), l, n);
                                hashSet.addAll(SyncModel.this.sdModel.sync(syncNodes.nodes, role, role2, syncOp == SyncOp.COPY ? enumSet : enumSet2, iSyncProgressMonitor, (IExceptionHandler)iSyncModelEventListener));
                                break;
                            }
                            case DELETE: {
                                iSyncProgressMonitor.beginTask(SyncOp.DELETE.progressText(), l, syncNodes.elements.size());
                                hashSet.addAll(SyncModel.this.delete(syncNodes.elements, iSyncProgressMonitor, iSyncModelEventListener));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error("Error syncing: ", throwable);
                        SyncModel.this.done(hashSet);
                    }
                }
                finally {
                    SyncModel.this.done(hashSet);
                }
            }
        });
    }

    public int totalCount(Set<IDiffNode> set) {
        this.sdModel.removeDescendants(set);
        int n = 0;
        for (IDiffNode iDiffNode : set) {
            int n2;
            ArrayList<IDiffNode> arrayList = new ArrayList<IDiffNode>();
            arrayList.add(iDiffNode);
            while ((n2 = arrayList.size()) > 0) {
                IDiffNode iDiffNode2 = (IDiffNode)arrayList.remove(n2 - 1);
                Object[] objectArray = iDiffNode2.getChildren(false);
                if (objectArray.length > 0) {
                    ArrayListUtil.addAll(arrayList, (Object[])objectArray);
                    continue;
                }
                ++n;
            }
        }
        return n;
    }

    public long totalSize(Set<IDiffNode> set, Role role) {
        this.sdModel.removeDescendants(set);
        long l = 0L;
        for (IDiffNode iDiffNode : set) {
            IResource iResource = (IResource)iDiffNode.getElement(role);
            if (iResource == null) continue;
            l += iResource.getSize();
        }
        return l;
    }

    public static interface ISyncModelEventListener
    extends IExceptionHandler {
        public void done();

        public Control getControl();

        public String getErrorLabel();

        public boolean isDisposed();

        public ISyncProgressMonitor monitor();

        public void synchronizing();
    }

    public class SyncModelEventAdapter
    implements ISyncModelEventListener {
        @Override
        public void done() {
        }

        @Override
        public Control getControl() {
            return null;
        }

        @Override
        public String getErrorLabel() {
            return null;
        }

        public boolean handleException(Throwable throwable) {
            return false;
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public ISyncProgressMonitor monitor() {
            return null;
        }

        @Override
        public void synchronizing() {
        }
    }

    public class SyncNodes {
        public Set<IDiffNode> added;
        public Set<IDiffNode> deleted;
        public Set<ElementWorkbenchAdapter> elements;
        public Set<IDiffNode> newerIn0;
        public Set<IDiffNode> newerIn1;
        public Set<IDiffNode> nodes;
        public Set<IDiffNode> toDelete;

        public void clear() {
            if (this.newerIn1 != null) {
                this.newerIn1.clear();
            }
            if (this.newerIn0 != null) {
                this.newerIn0.clear();
            }
            if (this.added != null) {
                this.added.clear();
            }
            if (this.deleted != null) {
                this.deleted.clear();
            }
            if (this.toDelete != null) {
                this.toDelete.clear();
            }
            if (this.nodes != null) {
                this.nodes.clear();
            }
            if (this.elements != null) {
                this.elements.clear();
            }
        }

        public SyncNodes clone() {
            SyncNodes syncNodes = new SyncNodes();
            if (this.newerIn1 != null) {
                syncNodes.newerIn1 = new LinkedHashSet<IDiffNode>(this.newerIn1);
            }
            if (this.newerIn0 != null) {
                syncNodes.newerIn0 = new LinkedHashSet<IDiffNode>(this.newerIn0);
            }
            if (this.added != null) {
                syncNodes.added = new LinkedHashSet<IDiffNode>(this.added);
            }
            if (this.deleted != null) {
                syncNodes.deleted = new LinkedHashSet<IDiffNode>(this.deleted);
            }
            if (this.toDelete != null) {
                syncNodes.toDelete = new LinkedHashSet<IDiffNode>(this.toDelete);
            }
            if (this.nodes != null) {
                syncNodes.nodes = new LinkedHashSet<IDiffNode>(this.nodes);
            }
            if (this.elements != null) {
                syncNodes.elements = new LinkedHashSet<ElementWorkbenchAdapter>(this.elements);
            }
            return syncNodes;
        }

        public boolean isEmpty() {
            if (this.newerIn1 != null && this.newerIn1.size() > 0) {
                return false;
            }
            if (this.newerIn0 != null && this.newerIn0.size() > 0) {
                return false;
            }
            if (this.added != null && this.added.size() > 0) {
                return false;
            }
            if (this.deleted != null && this.deleted.size() > 0) {
                return false;
            }
            if (this.toDelete != null && this.toDelete.size() > 0) {
                return false;
            }
            if (this.nodes != null && this.nodes.size() > 0) {
                return false;
            }
            return this.elements == null || this.elements.size() <= 0;
        }
    }
}

