/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.IStructPropertyProvider;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.StructProperty;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.resources.AbstractResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.internal.ui.IRowInfoProvider;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.DiffViewLabelProvider;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.printing.DiffViewPrintOp;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrinter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class StructPrintOp
extends DiffViewPrintOp {
    private static final int CENTER_COL_WIDTH = 0;
    private static final int IMAGE_TEXT_GAP = 5;
    private static int MIN_COL_WIDTH = 1;
    private int centerWidth;
    private final Map<ColumnType, Integer> col2width = new HashMap<ColumnType, Integer>();
    private int depthOffset;
    private List<IDiffNode> dNodes;
    private Point imgDpi;
    private int imgTextGap;
    private int otherColWidths = 0;
    private final Set<StructProperty> props = new LinkedHashSet<StructProperty>();
    private final Relation[] relations;
    private final List<IRowInfoProvider> rowInfos = new ArrayList<IRowInfoProvider>(Role.count());
    private final StructDiffView sdView;
    private int singleLineHeight = 11;
    private Point szImgPrint;
    private int widthFactor = 1;

    public StructPrintOp(StructDiffView structDiffView, IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        super((DiffView)structDiffView, iPrinter, iProgressMonitor);
        Set set;
        Relation[] relationArray;
        this.sdView = structDiffView;
        if (this.threeWay) {
            Relation[] relationArray2 = new Relation[3];
            relationArray2[1] = Relation.REF_ONE;
            relationArray = relationArray2;
            relationArray2[2] = Relation.REF_TWO;
        } else {
            Relation[] relationArray3 = new Relation[2];
            relationArray = relationArray3;
            relationArray3[1] = Relation.REF_ONE;
        }
        this.relations = relationArray;
        this.computeColumnWidths();
        LinkedList linkedList = new LinkedList(AbstractResource.umPROPS);
        Iterator iterator = linkedList.descendingIterator();
        while (iterator.hasNext()) {
            set = (StructProperty)iterator.next();
            if (set == StructProperty.NAME) continue;
            this.props.add((StructProperty)set);
        }
        set = Relation.roles((boolean)this.threeWay);
        for (Role role : set) {
            this.rowInfos.add((DiffViewLabelProvider)this.sdView.treeView(role).getRowInfoProvider());
        }
        structDiffView.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                StructDiffView structDiffView = StructPrintOp.this.sdView;
                TreeView treeView = structDiffView.treeView(Role.REF);
                StructPrintOp.this.setFontData(treeView.getFont().getFontData()[0]);
                StructPrintOp.this.imgDpi = treeView.getDisplay().getDPI();
                StructPrintOp.this.szImgPrint = StructPrintOp.this.toPrinterSize(StructPrintOp.this.imgDpi, 16, 16);
                int n = PrefUtil.getGlobalPrefs().getInt(PrefKey.P_ORIENTATION.toString());
                StructPrintOp.this.widthFactor = n == 1 ? 2 : 1;
                StructPrintOp.this.singleLineHeight = ((StructPrintOp)StructPrintOp.this).textExtent((String)"A").y;
                StructPrintOp.this.centerWidth = 0;
                StructPrintOp.this.imgTextGap = 5;
                StructPrintOp.this.depthOffset = TreeView.DEPTH_OFFSET;
                if (((StructPrintOp)StructPrintOp.this).imgDpi.x != 0) {
                    Point point = StructPrintOp.this.getPrinterDPI();
                    if (point.x != ((StructPrintOp)StructPrintOp.this).imgDpi.x) {
                        double d = (double)point.x / (double)((StructPrintOp)StructPrintOp.this).imgDpi.x;
                        StructPrintOp.this.centerWidth = (int)Math.ceil((double)StructPrintOp.this.centerWidth * d);
                        StructPrintOp.this.imgTextGap = (int)Math.ceil((double)StructPrintOp.this.imgTextGap * d);
                        StructPrintOp.this.depthOffset = (int)Math.ceil((double)StructPrintOp.this.depthOffset * d);
                    }
                }
                StructPrintOp.this.dNodes = structDiffView.deltaModel().getViewable();
            }
        });
    }

    private void computeColumnWidth(ColumnType columnType, boolean bl) {
        int n = 0;
        boolean bl2 = columnType.isVisible();
        switch (columnType) {
            case EXPAND: {
                n = (1 + this.textExtent((String)columnType.textForExtent()).x / 10) * 4;
                break;
            }
            case DIFFS: {
                n = this.sdView.getSashWidth();
                break;
            }
            default: {
                n = bl2 ? this.textExtent((String)columnType.textForExtent()).x : 0;
            }
        }
        this.col2width.put(columnType, n);
        if (bl && columnType.isVisible()) {
            this.otherColWidths += n;
        }
    }

    private void computeColumnWidths() {
        this.computeColumnWidth(ColumnType.EXPAND, false);
        this.computeColumnWidth(ColumnType.DIFFS, false);
        this.computeColumnWidth(ColumnType.ATTRIBUTES, true);
        this.computeColumnWidth(ColumnType.DATE_MODIFIED, true);
        this.computeColumnWidth(ColumnType.DATE_CREATED, true);
        this.computeColumnWidth(ColumnType.DATE_OPENED, true);
        this.computeColumnWidth(ColumnType.SIZE, true);
        this.computeColumnWidth(ColumnType.OWNER, true);
        this.computeColumnWidth(ColumnType.GROUP, true);
    }

    private void drawBackground(IDiffNode iDiffNode, int[] nArray, int n, int n2, int n3) {
        DeltaColor deltaColor = this.diffColor();
        int n4 = 0;
        while (n4 < this.roles.length) {
            Color color;
            Color color2 = this.rowInfos.get(n4).getBackground(iDiffNode, -1);
            if (color2 != null && (color = deltaColor.colorFromRgb(color2.getRGB())) != null) {
                this.fillRectangle(nArray[n4], n, n2, n3, color);
            }
            ++n4;
        }
    }

    private void drawForeground(IDiffNode iDiffNode, int n, int[] nArray, int n2, int n3, int n4, Image[] imageArray) {
        int n5 = this.depthOffset * iDiffNode.depth();
        int n6 = 0;
        Role[] roleArray = this.roles;
        int n7 = this.roles.length;
        int n8 = 0;
        while (n8 < n7) {
            int n9;
            Relation relation;
            Role role = roleArray[n8];
            int n10 = nArray[n6];
            int n11 = n3;
            int n12 = 0;
            String string = "";
            if (n6 == 0) {
                string = String.valueOf(n);
            } else {
                relation = this.relations[n6];
                string = Differencer.getDeltaDetailAsString((IDiffNode)iDiffNode, (Relation)relation);
            }
            n12 = this.getFirstColumnWidth(n6);
            this.drawText(string, n10, n2, n12, n4);
            n10 += n12;
            n11 -= n12;
            n10 += n5;
            n11 -= n5;
            relation = imageArray[n6];
            if (relation != null) {
                this.drawImage((Image)relation, n10, n2, this.szImgPrint.x, this.szImgPrint.y);
                int n13 = this.szImgPrint.x + this.imgTextGap;
                n10 += n13;
                n11 -= n13;
            }
            Rectangle rectangle = new Rectangle(n10, n2, n11, n4);
            IRowInfoProvider iRowInfoProvider = this.rowInfos.get(n6);
            String string2 = iRowInfoProvider.getText(iDiffNode);
            if (!string2.isEmpty()) {
                n9 = rectangle.width - this.getOtherColumnWidths();
                n9 = Math.max(MIN_COL_WIDTH, n9);
                this.drawText(string2, rectangle.x, rectangle.y, n9, rectangle.height);
            }
            n9 = rectangle.x + rectangle.width;
            int n14 = 0;
            for (StructProperty structProperty : this.props) {
                ColumnType columnType = ColumnType.fromStructProperty(structProperty);
                if (this.col2width.get((Object)columnType) <= 0) continue;
                string2 = Differencer.getPropertyValueAsString((IStructPropertyProvider)iDiffNode.getElement(role), (StructProperty)structProperty);
                n14 = this.getColumnWidth(columnType);
                if (string2.isEmpty()) continue;
                this.drawText(string2, n9 -= n14, rectangle.y, n14, rectangle.height);
            }
            ++n6;
            ++n8;
        }
    }

    private int drawNode(IDiffNode iDiffNode, int n, int[] nArray, int n2, int n3) {
        int n4 = this.roles.length;
        Rectangle rectangle = this.getPrintableArea();
        String[] stringArray = new String[n4];
        int n5 = 0;
        Image[] imageArray = new Image[n4];
        int n6 = this.depthOffset;
        int n7 = 0;
        while (n7 < n4) {
            if (!StructDiffModel.isNullElement((Object)iDiffNode.getElement(this.roles[n7]))) {
                IRowInfoProvider iRowInfoProvider = this.rowInfos.get(n7);
                imageArray[n7] = iRowInfoProvider.getImage(iDiffNode);
                Image image = imageArray[n7];
                if (image != null) {
                    if (n5 < this.szImgPrint.y) {
                        n5 = this.szImgPrint.y;
                    }
                    n6 = Math.max(n6, this.szImgPrint.x + this.imgTextGap);
                }
                stringArray[n7] = iRowInfoProvider.getText(iDiffNode);
                int n8 = Math.max(MIN_COL_WIDTH, n3 - this.getOtherColumnWidths() - n6 - this.getFirstColumnWidth(n7));
                Point point = this.textExtent(stringArray[n7], n8);
                if (n2 + point.y > rectangle.y + rectangle.height) {
                    this.endPage();
                    n2 = rectangle.y;
                }
                if (n5 < point.y) {
                    n5 = point.y;
                }
                if (n5 < this.singleLineHeight * this.widthFactor) {
                    n5 = this.singleLineHeight * this.widthFactor;
                }
            }
            ++n7;
        }
        assert (n5 > 0);
        if (n2 == rectangle.y && !this.startPage()) {
            return Integer.MIN_VALUE;
        }
        this.drawBackground(iDiffNode, nArray, n2, n3, n5);
        this.drawForeground(iDiffNode, n, nArray, n2, n3, n5, imageArray);
        return n2 += n5;
    }

    protected int getCenterWidth() {
        return this.centerWidth;
    }

    private int getColumnWidth(ColumnType columnType) {
        int n = this.col2width.get((Object)columnType);
        return n / this.widthFactor;
    }

    private int getFirstColumnWidth(int n) {
        return this.col2width.get((Object)(n == 0 ? ColumnType.EXPAND : ColumnType.DIFFS));
    }

    private int getOtherColumnWidths() {
        return this.otherColWidths / this.widthFactor;
    }

    protected HeaderFooterPrintOp newInstance(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        return new StructPrintOp(this.sdView, iPrinter, iProgressMonitor);
    }

    protected void print(Rectangle rectangle, int[] nArray, int n) {
        int n2 = rectangle.y;
        int n3 = 0;
        for (IDiffNode iDiffNode : this.dNodes) {
            if (this.pm.isCanceled()) break;
            if ((n2 = this.drawNode(iDiffNode, ++n3, nArray, n2, n)) != Integer.MIN_VALUE) continue;
            return;
        }
    }
}

