/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.App;
import com.deltawalker.DiffDoc;
import com.deltawalker.DiffDocAdapter;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.DocType;
import com.deltawalker.IStructElement;
import com.deltawalker.PrefKey;
import com.deltawalker.ScriptBoss;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.sound.SoundPlayer;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.FolderDiffView;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.Expand;
import com.deltawalker.ui.DiffModelListener;
import com.deltawalker.ui.DiffView;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.jface.util.StatusLineUtil;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructDiffModelListener
extends DiffModelListener {
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    private static final Logger LOG = LoggerFactory.getLogger(StructDiffModelListener.class);
    private boolean canUpdate = true;
    private Role[] effectiveRoles;
    private boolean expandDiffs;
    private boolean playSound;
    private final IDiffDocListener onDiffDoc = new DiffDocAdapter(){

        public void threeWayChanged(boolean bl) {
            StructDiffModelListener.this.threeWay = bl;
            StructDiffModelListener.this.computeEffectiveRoles();
            StructDiffModelListener.this.partialCompare = false;
        }
    };
    private final IPropertyChangeListener onPropChange = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if ("INPUT".equals(string)) {
                IPreferenceStore iPreferenceStore = StructDiffModelListener.this.dView.getInput().preferences();
                StructDiffModelListener.this.expandDiffs = iPreferenceStore.getBoolean(PrefKey.D_EXPAND_FOLDERS_ON_END.toString());
                StructDiffModelListener.this.playSound = iPreferenceStore.getBoolean(PrefKey.D_CHIME_ON_END.toString());
                StructDiffModelListener.this.partialCompare = false;
            } else if ("ORIENTATION".equals(string)) {
                StructDiffModelListener.this.computeEffectiveRoles();
                StructDiffModelListener.this.partialCompare = false;
            }
        }
    };
    private boolean partialCompare;
    private long startCompare;
    private boolean stopTimer = false;
    private final String taskMsg;
    private boolean threeWay;

    public StructDiffModelListener(StructDiffView structDiffView) {
        super((DiffView)structDiffView);
        this.threeWay = structDiffView.isThreeWay();
        this.taskMsg = this.isFolderView() ? StructMsg.StructDiffModelListener_diffFolders : StructMsg.StructDiffModelListener_diffXml;
        this.computeEffectiveRoles();
        structDiffView.addPropertyListener(this.onPropChange);
    }

    protected boolean canUpdate() {
        if (this.canUpdate) {
            this.canUpdate = false;
            return true;
        }
        return false;
    }

    private void computeEffectiveRoles() {
        int n = this.dView.getOrientation();
        this.effectiveRoles = 512 == (n & 0x200) ? (512 == n || !this.threeWay ? new Role[]{Role.REF} : new Role[]{Role.REF, Role.ONE}) : (this.threeWay ? new Role[]{Role.ONE, Role.REF, Role.TWO} : new Role[]{Role.REF, Role.ONE});
    }

    protected StructDiffView deltaView() {
        return (StructDiffView)this.dView;
    }

    public Role[] getEffectiveRoles() {
        return this.effectiveRoles;
    }

    public void installInputListeners(boolean bl) {
        if (bl) {
            this.dView.getInput().addDiffDocListener(this.onDiffDoc);
        } else {
            this.dView.getInput().removeDiffDocListener(this.onDiffDoc);
        }
    }

    private boolean isFolderView() {
        return this.dView instanceof FolderDiffView;
    }

    protected void onBeginCompare(Job job) {
        super.onBeginCompare(job);
        this.dView.controller().updateComparisonSummary();
        this.startCompare = System.currentTimeMillis();
        this.stopTimer = false;
        this.updateTrees();
        this.startUpdateTimer();
        this.dView.controller().updateActions();
        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.COMPARE_STARTED, null, this.dView.getInput());
    }

    protected void onEndCompare() {
        super.onEndCompare();
        long l = System.currentTimeMillis() - this.startCompare;
        if (LOG.isInfoEnabled()) {
            LOG.info("Comparison duration: " + l + " ms");
        }
        StructDiffView structDiffView = this.deltaView();
        IDiffDoc iDiffDoc = structDiffView.getInput();
        String string = DiffDoc.constructFullTitle((IDiffDoc)iDiffDoc, (boolean)true);
        IStructDiffModel iStructDiffModel = structDiffView.deltaModel();
        String string2 = NLS.bind((String)structDiffView.getDoneMessage(), (Object[])new String[]{string, INT_FORMAT.format(iStructDiffModel.getAllDeltas().size()), TimeFormatter.formatMilliDelta((long)l)});
        StatusLineUtil.setMessage((IStatusLineManager)this.dView.getStatusLineManager(), (String)string2);
        this.dView.fireDeltasChanged();
        this.dView.controller().updateActions();
        this.updateTrees();
        if (this.expandDiffs && !this.partialCompare) {
            this.dView.controller().getAction(Expand.DIFFS.actionId()).run();
        }
        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.COMPARE_ENDED, null, this.dView.getInput());
        if (this.playSound && !this.partialCompare && iDiffDoc.docType() == DocType.FOLDER) {
            new SoundPlayer(SoundPlayer.Sound.END_COMPARE.toString()).play();
        }
        this.partialCompare = true;
        this.stopTimer = true;
    }

    private void showTaskDescription(Object object) {
        IStatusLineManager iStatusLineManager = this.dView.getStatusLineManager();
        IDiffNode iDiffNode = null;
        if (object instanceof IDiffNode[]) {
            iDiffNode = ((IDiffNode[])object)[0];
        } else if (object instanceof IDiffNode) {
            iDiffNode = (IDiffNode)object;
        }
        if (iDiffNode != null) {
            for (Role role : this.dView.roles()) {
                IStructElement iStructElement = iDiffNode.getElement(role);
                if (!(iStructElement instanceof IResource)) continue;
                iStatusLineManager.setMessage(((IResource)iStructElement).getUri());
                return;
            }
        }
        iStatusLineManager.setMessage(this.taskDescription());
    }

    protected void startUpdateTimer() {
        final Display display = this.dView.getControl().getDisplay();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                StructDiffModelListener.this.canUpdate = true;
                if (!StructDiffModelListener.this.stopTimer) {
                    display.timerExec(1000, (Runnable)this);
                }
            }
        };
        display.timerExec(1000, runnable);
    }

    public String taskDescription() {
        return this.taskMsg;
    }

    protected boolean uiHandleEvent(DiffModelEvent diffModelEvent) {
        if (super.uiHandleEvent(diffModelEvent)) {
            return true;
        }
        boolean bl = false;
        DiffModelEvent.Type type = diffModelEvent.getType();
        StructDiffView structDiffView = this.deltaView();
        Object object = diffModelEvent.getDetail();
        switch (type) {
            case DIFF_INFO_CHANGED: {
                if (this.canUpdate()) {
                    structDiffView.birdsEye().refresh();
                    this.showTaskDescription(diffModelEvent.getDetail());
                }
                bl = true;
                break;
            }
            case EXPANDED_CHANGED: {
                this.updateTrees();
                bl = true;
                break;
            }
            case SELECTED_CHANGED: {
                if (object instanceof IDiffNode) {
                    structDiffView.treeView(Role.REF).updateSelection((IDiffNode)object);
                } else if (object instanceof List) {
                    structDiffView.treeView(Role.REF).updateSelection((List)object);
                }
                structDiffView.birdsEye().redraw();
                structDiffView.reportSelection();
                structDiffView.fireDeltaSelectionChanged(false);
                structDiffView.controller().updateActions();
                bl = true;
                break;
            }
            case VIEW_FILTERS_CHANGED: {
                this.updateTrees();
                bl = true;
                break;
            }
            case CHILDREN_CHANGED: {
                if (this.canUpdate()) {
                    this.showTaskDescription(object);
                    if (object instanceof IDiffNode) {
                        structDiffView.treeView(Role.REF).redrawNow((IDiffNode)object);
                    } else {
                        this.updateTrees();
                    }
                }
                bl = true;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return bl;
    }

    private void updateTrees() {
        TreeView treeView = this.deltaView().treeView(Role.REF);
        treeView.fullUpdate();
    }
}

