/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.Delta;
import com.deltawalker.Relation;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.BirdsEye;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltopia.util.Const;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class StructBirdsEye
extends BirdsEye {
    private volatile int samplingRate = 1;
    private volatile int viewableCount;

    public StructBirdsEye(Composite composite, StructDiffView structDiffView) {
        super(composite, (DiffView)structDiffView);
    }

    private void constructToolTipText(StringBuilder stringBuilder, IDiffNode iDiffNode, Relation relation) {
        String string = Differencer.getDeltaDetailAsString((IDiffNode)iDiffNode, (Relation)relation);
        if (!string.isEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append(Const.LINE_ENDING);
        }
        Set set = relation.toSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            IResource iResource = (IResource)iDiffNode.getElement(role);
            if (iResource != null) {
                String string2 = iResource.getUri();
                stringBuilder.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(Const.LINE_ENDING);
                continue;
            }
            stringBuilder.append("(-)");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(Const.LINE_ENDING);
        }
    }

    protected List<BirdsEye.Marker> createMarkers() {
        IStructDiffModel iStructDiffModel = this.view().deltaModel();
        if (iStructDiffModel != null && iStructDiffModel.getRoot().isSame()) {
            this.markers.clear();
            return this.markers;
        }
        List list = iStructDiffModel.getViewable();
        if (!this.shouldRecreateMarkers() && this.viewableCount == list.size()) {
            return this.markers;
        }
        this.clearMarkers();
        this.viewableCount = list.size();
        StructDiffView structDiffView = this.view();
        Role role = Role.REF;
        TreeView treeView = structDiffView.treeView(role);
        int n = treeView.getItemHeight();
        int n2 = this.viewableCount * n;
        if (n2 <= 0) {
            return this.markers;
        }
        this.scale = n2 > this.height ? (float)this.height / (float)this.viewableCount : (float)n;
        StructMarker structMarker = null;
        int n3 = (int)Math.floor(this.scale);
        this.samplingRate = this.viewableCount / this.height;
        this.samplingRate = Math.max(1, this.samplingRate);
        this.samplingRate = Math.min(100, this.samplingRate);
        ArrayList<StructMarker> arrayList = new ArrayList<StructMarker>();
        int n4 = 0;
        for (IDiffNode iDiffNode : list) {
            if (n4 % this.samplingRate == 0 && !iDiffNode.isSame()) {
                Color color = structDiffView.getColor(role, iDiffNode, DeltaPart.BG);
                Color color2 = structDiffView.getColor(role, iDiffNode, DeltaPart.FG);
                int n5 = (int)Math.floor((float)n4 * this.scale);
                StructMarker structMarker2 = new StructMarker(iDiffNode, color, color2, n5 + 1, n3 - 1);
                if (structMarker != null && structMarker.canMergeWith(structMarker2)) {
                    structMarker.mergeWith(structMarker2);
                } else {
                    arrayList.add(structMarker2);
                    structMarker = structMarker2;
                }
            }
            ++n4;
        }
        this.markers.addAll(arrayList);
        return this.markers;
    }

    protected Color getColor(BirdsEye.Marker marker, DeltaPart deltaPart, boolean bl) {
        StructMarker structMarker = (StructMarker)marker;
        if (!bl) {
            return structMarker.getColor(deltaPart);
        }
        if (deltaPart == DeltaPart.BG) {
            return DeltaColor.getListBackgroundSystemColor();
        }
        return this.view().deltaColor().borderColorFromBgColor(structMarker.getColor(DeltaPart.BG));
    }

    protected String getToolTipText(Event event, Color[] colorArray) {
        IStructDiffModel iStructDiffModel = this.view().deltaModel();
        boolean bl = iStructDiffModel.isThreeWay();
        BirdsEye.Marker marker = this.hitTest(event.y);
        if (marker != null) {
            StructMarker structMarker = (StructMarker)marker;
            colorArray[0] = structMarker.getColor(DeltaPart.BG);
            DiffNode diffNode = structMarker.delta();
            StringBuilder stringBuilder = new StringBuilder();
            Relation relation = Relation.first((boolean)bl);
            this.constructToolTipText(stringBuilder, diffNode, relation);
            if (bl) {
                stringBuilder.append(Const.LINE_ENDING);
                this.constructToolTipText(stringBuilder, diffNode, Relation.last((boolean)true));
            }
            return stringBuilder.toString();
        }
        return UIMsg.BirdsEye_toolTip;
    }

    protected boolean isMarkerSelected(BirdsEye.Marker marker) {
        boolean bl = false;
        List list = this.view().deltaModel().getSelected();
        for (IDiffNode iDiffNode : list) {
            if (!marker.containsDelta((Delta)iDiffNode)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void select(Delta delta) {
        ((IDiffNode)delta).setSelected(true, false);
        this.redraw();
    }

    public StructDiffView view() {
        return (StructDiffView)super.view();
    }

    private class StructMarker
    extends BirdsEye.Marker {
        private Color clrBg;
        private Color clrBorder;
        private final Set<IDiffNode> deltas;

        public StructMarker(IDiffNode iDiffNode, Color color, Color color2, int n, int n2) {
            super((BirdsEye)StructBirdsEye.this, n, n2);
            this.deltas = new HashSet<IDiffNode>();
            if (iDiffNode == null) {
                throw new NullPointerException("delta");
            }
            if (color == null) {
                throw new NullPointerException("clrBg");
            }
            if (color2 == null) {
                throw new NullPointerException("clrBorder");
            }
            this.clrBg = color;
            this.clrBorder = color2;
            this.deltas.add(iDiffNode);
            this.delta = (DiffNode)iDiffNode;
        }

        public boolean containsDelta(Delta delta) {
            return this.deltas.contains(delta);
        }

        public DiffNode delta() {
            return (DiffNode)this.delta;
        }

        public void dispose() {
            this.deltas.clear();
            this.clrBg = null;
            this.clrBorder = null;
        }

        public Color getColor(DeltaPart deltaPart) {
            if (deltaPart == DeltaPart.BORDER) {
                return this.clrBorder;
            }
            if (deltaPart == DeltaPart.BG) {
                return this.clrBg;
            }
            throw new IllegalArgumentException("deltaPart");
        }

        public boolean isUpToDate() {
            for (IDiffNode iDiffNode : this.deltas) {
                if (((Delta)iDiffNode).isOverallKind((com.deltawalker.script.Delta)this.delta)) continue;
                return false;
            }
            return true;
        }

        public void mergeWith(BirdsEye.Marker marker) {
            super.mergeWith(marker);
            IDiffNode iDiffNode = (IDiffNode)marker.delta();
            this.deltas.add(iDiffNode);
            this.delta = (Delta)iDiffNode;
        }
    }
}

