/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.StructException;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.ui.ControlUtil;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.SizeFormatter;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.interfaces.ISyncProgressMonitorUI;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.deltopia.ui.swt.SyncProgressMonitorProxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ProgressView
extends Composite
implements SyncModel.ISyncModelEventListener {
    private static final int DIALOG_AREA_WIDTH_DLUS = 400;
    private Composite cmpError;
    private Table errorTable;
    private boolean margin;
    private ISyncProgressMonitor spm;
    private ISyncProgressMonitorUI spmUI;
    private ToolItem tiStop;

    public ProgressView(Composite composite, int n, boolean bl) {
        super(composite, n);
        this.margin = bl;
    }

    public void createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)gridLayout);
        int n = this.margin ? ControlUtil.convertDLUsToPixels((Control)this, (int)400, (boolean)false) : 0;
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = n;
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginLeft = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = n;
        gridData.horizontalSpan = 3;
        this.setLayoutData(gridData);
        this.spm = this.createProgressMonitor(composite, this.createLabels(composite));
        this.createErrorTable(gridLayout.marginHeight);
    }

    private void createErrorTable(int n) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = n;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData(4, 4, true, true);
        gridData.exclude = true;
        this.cmpError = new Composite((Composite)this, 0);
        this.cmpError.setLayout((Layout)gridLayout);
        this.cmpError.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.heightHint = ControlUtil.convertDLUsToPixels((Control)this, (int)40, (boolean)true);
        this.errorTable = new Table(this.cmpError, 2048);
        this.errorTable.setLayoutData((Object)gridData2);
        this.errorTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.errorTable, 16384);
        tableColumn.setText(this.getErrorLabel());
    }

    private Map<LabelId, Label> createLabels(Composite composite) {
        HashMap<LabelId, Label> hashMap = new HashMap<LabelId, Label>();
        Label label = new Label(composite, 0);
        hashMap.put(LabelId.OPERATION, label);
        label.setText(StructMsg.ProgressView_estimating);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label label2 = new Label(composite, 0){
            private String text;
            {
                this.addListener(11, new Listener(){

                    public void handleEvent(Event event) {
                        this.setText(text);
                        ProgressView.this.handleResize();
                    }
                });
            }

            protected void checkSubclass() {
            }

            public void setText(String string) {
                super.setText(StringUtil.ellipsize((String)string, (Control)this, (int)-1));
                this.text = string;
            }
        };
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        hashMap.put(LabelId.URI, label2);
        Label label3 = new Label(composite, 0);
        label3.setText(StructMsg.SpmUI_timeLabel);
        label3.setLayoutData((Object)new GridData(4, 128, false, false));
        Label label4 = new Label(composite, 0);
        label4.setText(StructMsg.ProgressView_estimating);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        label4.setLayoutData((Object)gridData);
        hashMap.put(LabelId.TIME, label4);
        Label label5 = new Label(composite, 0);
        label5.setText(StructMsg.SpmUI_itemsLabel);
        label5.setLayoutData((Object)new GridData(4, 128, false, false));
        Label label6 = new Label(composite, 0);
        label6.setText(StructMsg.ProgressView_estimating);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        label6.setLayoutData((Object)gridData);
        hashMap.put(LabelId.ITEMS, label6);
        Label label7 = new Label(composite, 0);
        label7.setText(StructMsg.SpmUI_speedLabel);
        label7.setLayoutData((Object)new GridData(4, 128, false, false));
        Label label8 = new Label(composite, 0);
        label8.setText(StructMsg.ProgressView_estimating);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        label8.setLayoutData((Object)gridData);
        hashMap.put(LabelId.SPEED, label8);
        return hashMap;
    }

    private ISyncProgressMonitor createProgressMonitor(Composite composite, Map<LabelId, Label> map) {
        ProgressBar progressBar = new ProgressBar(composite, 256);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        progressBar.setLayoutData((Object)gridData);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        this.tiStop = new ToolItem(toolBar, 8);
        this.tiStop.setImage(ImageCache.getImage((String)ImageConst.STOP));
        this.tiStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProgressView.this.spm.setCanceled(true);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 27) {
                    ProgressView.this.spm.setCanceled(true);
                }
            }
        });
        toolBar.setLayoutData((Object)new GridData());
        this.spmUI = new SyncProgressMonitorUI(progressBar, map);
        this.tiStop.setToolTipText(StructMsg.ProgressView_stop);
        SyncProgressMonitorProxy syncProgressMonitorProxy = new SyncProgressMonitorProxy((Control)composite, this.spmUI);
        return syncProgressMonitorProxy;
    }

    @Override
    public void done() {
        this.spm.setCanceled(true);
        this.spm.subTask(StructMsg.ProgressView_done);
        this.tiStop.setEnabled(false);
        this.spmUI.setRemainingItems(0);
        this.spmUI.setRemainingSize(0L);
        this.spmUI.setRemainingTime(0L);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public String getErrorLabel() {
        return StructMsg.ProgressView_error;
    }

    protected String[] getErrorMessage(StructException structException) {
        return new String[]{structException.getLocalizedMessage(), ""};
    }

    public boolean handleException(Throwable throwable) {
        final String string = throwable.getLocalizedMessage();
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                if (!ProgressView.this.errorTable.isDisposed()) {
                    ProgressView.this.showErrorMessage(string);
                }
            }
        });
        return true;
    }

    private void handleResize() {
        Rectangle rectangle = this.errorTable.getClientArea();
        if (rectangle.isEmpty()) {
            return;
        }
        int n = this.errorTable.getColumnCount();
        int n2 = n > 0 ? rectangle.width / n - 1 : rectangle.width;
        int n3 = 0;
        while (n3 < n) {
            this.errorTable.getColumn(n3).setWidth(n2);
            ++n3;
        }
    }

    public boolean hasErrors() {
        return this.errorTable.getItemCount() > 0;
    }

    @Override
    public ISyncProgressMonitor monitor() {
        return this.spm;
    }

    private void showErrorMessage(String string) {
        if (StringUtil.isEmpty((String)string)) {
            string = StructMsg.ResourceMessage_internalError;
        }
        TableItem tableItem = new TableItem(this.errorTable, 0);
        tableItem.setText(string);
        GridData gridData = (GridData)this.cmpError.getLayoutData();
        if (gridData.exclude) {
            gridData.exclude = false;
            this.cmpError.getParent().layout();
            int n = this.cmpError.computeSize((int)this.cmpError.getSize().x, (int)-1).y;
            Shell shell = this.cmpError.getShell();
            Rectangle rectangle = shell.getBounds();
            rectangle.height += n;
            shell.setBounds(rectangle);
        }
        this.handleResize();
    }

    @Override
    public void synchronizing() {
    }

    private static enum LabelId {
        ITEMS,
        OPERATION,
        SPEED,
        TIME,
        URI;

    }

    private static class SyncProgressMonitorUI
    implements ISyncProgressMonitorUI {
        private boolean canceled;
        private Map<LabelId, Label> id2label;
        private final ProgressBar pb;
        private long remainingSize;
        private int totalItems;
        private long totalSize;

        public SyncProgressMonitorUI(ProgressBar progressBar, Map<LabelId, Label> map) {
            this.pb = progressBar;
            this.id2label = map;
        }

        public void beginTask(String string, int n) {
            int n2 = n != -1 ? 100 : Integer.MAX_VALUE;
            this.pb.setMaximum(n2);
            this.pb.setSelection(0);
            this.setTaskName(string);
            this.pb.getParent().layout();
        }

        public void done() {
            if (this.pb != null) {
                this.pb.setSelection(this.pb.getMaximum());
            }
        }

        public void internalWorked(double d) {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean bl) {
            this.canceled = bl;
        }

        public void setRemainingItems(int n) {
            this.id2label.get((Object)LabelId.ITEMS).setText(NLS.bind((String)StructMsg.SpmUI_items, (Object[])new Object[]{n, SizeFormatter.format((long)this.remainingSize, (int)2), this.totalItems, SizeFormatter.format((long)this.totalSize, (int)2)}));
        }

        public void setRemainingSize(long l) {
            if (l < 0L) {
                l = 0L;
            }
            this.remainingSize = l;
        }

        public void setRemainingTime(long l) {
            this.id2label.get((Object)LabelId.TIME).setText(TimeFormatter.formatDelta((long)l));
        }

        public void setSpeed(long l) {
            this.id2label.get((Object)LabelId.SPEED).setText(NLS.bind((String)StructMsg.SpmUI_speed, (Object)SizeFormatter.format((long)l, (int)1)));
        }

        public void setTaskName(String string) {
            this.id2label.get((Object)LabelId.OPERATION).setText(String.valueOf(StringUtil.makeSafe((String)string)) + ':');
        }

        public void setTotalItems(int n) {
            this.totalItems = n;
        }

        public void setTotalSize(long l) {
            this.totalSize = l;
        }

        public void subTask(String string) {
            this.id2label.get((Object)LabelId.URI).setText(StringUtil.makeSafe((String)string));
        }

        public void worked(int n) {
            this.pb.setSelection(n);
        }
    }
}

