/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.Relation;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.INodeFilter;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.structure.ui.DiffViewLabelProvider;
import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PatternNodeFilter
implements INodeFilter {
    private StringMatcher matcher;

    public INodeFilter.Criterion criterion() {
        return INodeFilter.Criterion.PATTERN;
    }

    private String[] getWords(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n = breakIterator.first();
        while (n != -1 && n < string.length()) {
            int n2 = breakIterator.following(n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (Character.isLetterOrDigit(string.charAt(n))) {
                String string2 = string.substring(n, n2);
                arrayList.add(string2);
            }
            n = n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(string);
    }

    public boolean matches(IDiffNode iDiffNode) {
        IStructDiffModel iStructDiffModel = iDiffNode.model();
        if (iStructDiffModel == null) {
            return true;
        }
        if (this.matcher == null) {
            return false;
        }
        Set set = Relation.roles((boolean)iStructDiffModel.isThreeWay());
        for (Role role : set) {
            if (!this.wordMatches(DiffViewLabelProvider.getText(role, iDiffNode))) continue;
            return false;
        }
        return true;
    }

    public void setPattern(String string) {
        if (string == null || string.equals("")) {
            this.matcher = null;
        } else {
            String string2 = String.valueOf(string) + "*";
            this.matcher = new StringMatcher(string2, true, false);
        }
    }

    protected boolean wordMatches(String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        if (this.match(string)) {
            return true;
        }
        String[] stringArray2 = stringArray = this.getWords(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (this.match(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

