/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.DiffModelEvent;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.INodeFilter;
import com.deltawalker.structure.IStructDiffModelImpl;
import com.deltawalker.structure.StructDiffModel;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFilters {
    private static final Logger LOG = LoggerFactory.getLogger(NodeFilters.class);
    private static final boolean TRACE = LOG.isInfoEnabled();
    private final List<INodeFilter> filters = new CopyOnWriteArrayList<INodeFilter>();
    private final StructDiffModel model;

    public NodeFilters(StructDiffModel structDiffModel) {
        this.model = structDiffModel;
    }

    public void addFilter(INodeFilter iNodeFilter) {
        if (iNodeFilter == null) {
            throw new NullPointerException("filter");
        }
        if (!this.filters.contains(iNodeFilter)) {
            this.filters.add(iNodeFilter);
            this.fireFiltersChanged(iNodeFilter);
        }
    }

    public boolean contains(INodeFilter iNodeFilter) {
        if (iNodeFilter == null) {
            throw new NullPointerException("filter");
        }
        return this.filters.contains(iNodeFilter);
    }

    private void fireFiltersChanged(INodeFilter iNodeFilter) {
        this.model.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
        this.model.fireEvent(DiffModelEvent.Type.VIEW_FILTERS_CHANGED, iNodeFilter);
    }

    private boolean isLeafMatch(IDiffNode iDiffNode) {
        for (INodeFilter iNodeFilter : this.filters) {
            if (!iNodeFilter.matches(iDiffNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatch(IDiffNode iDiffNode) {
        IDiffNode[] iDiffNodeArray = iDiffNode.getChildren(false);
        if (iDiffNodeArray.length > 0) {
            return this.isRecursiveMatch(iDiffNodeArray);
        }
        return this.isLeafMatch(iDiffNode);
    }

    private boolean isRecursiveMatch(IDiffNode[] iDiffNodeArray) {
        boolean bl = false;
        IDiffNode[] iDiffNodeArray2 = iDiffNodeArray;
        int n = iDiffNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffNode iDiffNode = iDiffNodeArray2[n2];
            bl = this.isMatch(iDiffNode);
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return bl;
    }

    public boolean matches(IDiffNode iDiffNode) {
        if (this.filters.isEmpty()) {
            return false;
        }
        boolean bl = this.isMatch(iDiffNode);
        if (TRACE) {
            LOG.info("Overall match=" + bl + "   for:" + iDiffNode);
        }
        return bl;
    }

    public void removeFilter(INodeFilter iNodeFilter) {
        if (this.filters.contains(iNodeFilter)) {
            this.filters.remove(iNodeFilter);
            this.fireFiltersChanged(iNodeFilter);
        }
    }

    public String toString() {
        return this.filters.toString();
    }
}

