/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.DiffMethodUtil;
import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.FolderColumnBoss;
import com.deltawalker.structure.internal.ui.FolderDashboardCenter;
import com.deltawalker.structure.internal.ui.FolderUriChooser;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.FolderDiffController;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UriChooser;
import com.deltawalker.ui.actions.CopyAction;
import com.deltopia.interfaces.IMvcModel;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderDiffView
extends StructDiffView {
    private static final Logger LOG = LoggerFactory.getLogger(FolderDiffView.class);
    private FolderDashboardCenter dbCenter;
    private Set<Comparison.Method> oldMethodGP;
    private Set<Comparison.Method> oldMethodSP;

    public FolderDiffView(Composite composite, int n) {
        super(composite, n);
        if (LOG.isInfoEnabled()) {
            LOG.info("C-tor: " + FolderDiffView.class.getSimpleName());
        }
    }

    public boolean canCopyFrom(boolean bl, Role role, Role role2) {
        return CopyAction.shouldEnable((IStructDiffModel)this.deltaModel(), (boolean)bl, (Role)role, (Role)role2);
    }

    @Override
    public FolderColumnBoss columnBoss(Role role) {
        ColumnBoss columnBoss = (ColumnBoss)this.colBosses.get(role);
        if (columnBoss == null) {
            columnBoss = new FolderColumnBoss(this);
            this.colBosses.put(role, columnBoss);
        }
        return (FolderColumnBoss)columnBoss;
    }

    protected DiffController createController() {
        return new FolderDiffController();
    }

    protected Composite createDashboardCenter() {
        this.dbCenter = new FolderDashboardCenter((Composite)this.dashboard(), 0, this);
        return this.dbCenter;
    }

    public UriChooser createUriChooser(Composite composite, Role role) {
        return new FolderUriChooser(composite, 0, role, this.docType() == DocType.PREVIEW, this);
    }

    private boolean didContentCompareMethodChange(IPreferenceStore iPreferenceStore, Set<Comparison.Method> set, boolean bl) {
        Set<Comparison.Method> set2 = bl ? this.oldMethodSP : this.oldMethodGP;
        boolean bl2 = DiffMethodUtil.isContent(set2);
        if (!set2.equals(set)) {
            if (set2.isEmpty() || set.isEmpty()) {
                return true;
            }
            boolean bl3 = iPreferenceStore.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString());
            if (bl2 || bl3) {
                return true;
            }
        }
        return false;
    }

    private boolean didQuickCompareMethodChange(IPreferenceStore iPreferenceStore, Set<Comparison.Method> set, boolean bl) {
        Set<Comparison.Method> set2 = bl ? this.oldMethodSP : this.oldMethodGP;
        boolean bl2 = DiffMethodUtil.isQuick(set2);
        if (!set2.equals(set)) {
            boolean bl3;
            if (set2.isEmpty() || set.isEmpty()) {
                return true;
            }
            boolean bl4 = bl3 = !iPreferenceStore.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString());
            if (bl2 && bl3) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDoneMessage() {
        return StructMsg.StructDiffModelListener_doneFolders;
    }

    @Override
    protected void inputChanged(Object object, Object object2) {
        super.inputChanged(object, object2);
        IPreferenceStore iPreferenceStore = this.getInput().preferences();
        this.oldMethodSP = DiffMethodUtil.prune((Set)DiffMethodUtil.fromInt((int)iPreferenceStore.getInt(PrefKey.D_COMP_METHOD.toString())), (IPreferenceStore)iPreferenceStore);
        iPreferenceStore = PrefUtil.getGlobalPrefs();
        this.oldMethodGP = DiffMethodUtil.prune((Set)DiffMethodUtil.fromInt((int)iPreferenceStore.getInt(PrefKey.D_COMP_METHOD.toString())), (IPreferenceStore)iPreferenceStore);
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            this.columnBoss(role).inputChanged(object, object2);
            ++n2;
        }
        if (this.dbCenter != null) {
            this.dbCenter.connect((IMvcModel)object, null);
            this.dbCenter.layout(true, true);
        }
    }

    protected boolean propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        boolean bl = false;
        if (string.equals(PrefKey.D_SHOW_SIZE_COLUMN.toString()) || string.equals(PrefKey.D_SHOW_DATE_MODIFIED_COLUMN.toString()) || string.equals(PrefKey.D_SHOW_DATE_CREATED_COLUMN.toString()) || string.equals(PrefKey.D_SHOW_DATE_OPENED_COLUMN.toString()) || string.equals(PrefKey.D_SHOW_ATTRIBUTES_COLUMN.toString()) || string.equals(PrefKey.D_SHOW_OWNER_COLUMN.toString()) || string.equals(PrefKey.D_SHOW_GROUP_COLUMN.toString())) {
            for (Role role : this.roles()) {
                TreeView treeView = this.treeView(role);
                if (treeView != null) {
                    if (!ColumnBoss.get((Control)treeView).setColumnVisibility(propertyChangeEvent, this.isThreeWay())) continue;
                    bl = true;
                    continue;
                }
                break;
            }
        } else if (string.equals(PrefKey.D_LIST_FOLDERS_FIRST.toString())) {
            IPreferenceStore iPreferenceStore = (IPreferenceStore)propertyChangeEvent.getSource();
            ColumnBoss columnBoss = ColumnBoss.get((Control)this.treeView(Role.REF));
            if (columnBoss instanceof FolderColumnBoss) {
                boolean bl2 = iPreferenceStore.getBoolean(string);
                ((FolderColumnBoss)columnBoss).setFoldersFirst(bl2);
                bl = true;
            }
        } else {
            bl = super.propertyChange(propertyChangeEvent);
        }
        return bl;
    }

    public void refresh() {
        super.refresh();
        this.dbCenter.connect((IMvcModel)this.getInput(), null);
    }

    protected DiffView.Recompare shouldRecompare(IPreferenceStore iPreferenceStore, PrefKey prefKey, boolean bl) {
        DiffView.Recompare recompare;
        Set set = DiffMethodUtil.prune((Set)DiffMethodUtil.fromInt((int)iPreferenceStore.getInt(PrefKey.D_COMP_METHOD.toString())), (IPreferenceStore)iPreferenceStore);
        switch (prefKey) {
            case C_FOLLOW_SYMLINKS: {
                return DiffView.Recompare.FULL;
            }
            case D_COLLECT_INFO_EX: {
                return DiffView.Recompare.FULL;
            }
            case C_IGNORE_CHAR_CASE: 
            case C_IGNORE_LINE_ENDINGS: 
            case C_IGNORE_WHITESPACE: 
            case C_USE_OPTIMAL_DIFFERENCER: {
                recompare = set.contains(Comparison.Method.AS_TEXT) ? DiffView.Recompare.FULL : DiffView.Recompare.NONE;
                break;
            }
            default: {
                recompare = DiffView.Recompare.NONE;
            }
        }
        if (recompare != DiffView.Recompare.NONE) {
            return recompare;
        }
        if (this.didQuickCompareMethodChange(iPreferenceStore, set, bl)) {
            if (bl) {
                this.oldMethodSP = set;
            } else {
                this.oldMethodGP = set;
            }
            return DiffView.Recompare.PARTIAL;
        }
        if (this.didContentCompareMethodChange(iPreferenceStore, set, bl)) {
            if (bl) {
                this.oldMethodSP = set;
            } else {
                this.oldMethodGP = set;
            }
            return DiffView.Recompare.FULL;
        }
        return recompare;
    }
}

