/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.Delta;
import com.deltawalker.DeltaUtil;
import com.deltawalker.IStructElement;
import com.deltawalker.Relation;
import com.deltawalker.StructProperty;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.ui.StructDiffSummary;
import com.deltawalker.ui.DiffSummary;
import com.deltawalker.ui.DiffSummaryItem;
import com.deltawalker.ui.IDiffSummary;
import com.deltawalker.ui.IDiffSummaryItem;
import com.deltopia.eclipse.util.SizeFormatter;
import com.deltopia.io.FileType;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class FolderDiffSummary
extends StructDiffSummary {
    private static final String FILES = StructMsg.FolderDiffSummary_files;
    private static final String FOLDERS = StructMsg.FolderDiffSummary_folders;

    public FolderDiffSummary(StructDiffModel structDiffModel) {
        super(structDiffModel);
        this.setTitle(StructMsg.FolderDiffSummary_title);
    }

    private IDiffSummary createCountAndSizeSummary(Set<IDiffNode> set, Delta delta) {
        Role role2;
        Set set2 = Relation.roles((boolean)this.threeWay);
        IDiffSummaryItem[] iDiffSummaryItemArray = new IDiffSummaryItem[set2.size()];
        int n = 0;
        for (Role role2 : set2) {
            IDiffSummaryItem iDiffSummaryItem = this.createCountAndSizeSummaryItem(role2, set, delta);
            if (iDiffSummaryItem == null) continue;
            iDiffSummaryItemArray[n++] = iDiffSummaryItem;
        }
        if (n > 0) {
            role2 = new DiffSummary(new String[]{FILES, FOLDERS}, this.threeWay);
            int n2 = 0;
            while (n2 < n) {
                role2.addItem(iDiffSummaryItemArray[n2]);
                ++n2;
            }
        } else {
            role2 = null;
        }
        return role2;
    }

    private IDiffSummaryItem createCountAndSizeSummaryItem(Role role, Set<IDiffNode> set, Delta delta) {
        int n = 0;
        long l = 0L;
        int n2 = 0;
        for (IDiffNode diffSummaryItem2 : set) {
            IStructElement iStructElement = diffSummaryItem2.getElement(role);
            if (!(iStructElement instanceof IResource)) continue;
            IResource iResource = (IResource)iStructElement;
            FileType fileType = iResource.getType();
            if (fileType == FileType.FILE) {
                ++n;
                l += iResource.getSize();
                continue;
            }
            if (fileType != FileType.FOLDER) continue;
            ++n2;
        }
        final DiffSummaryItem diffSummaryItem = new DiffSummaryItem();
        diffSummaryItem.setName(StructMsg.FolderDiffSummary_count);
        diffSummaryItem.setValue(FILES, (Object)n);
        diffSummaryItem.setValue(FOLDERS, (Object)n2);
        final DiffSummaryItem diffSummaryItem3 = new DiffSummaryItem();
        diffSummaryItem3.setName(StructProperty.SIZE.toString());
        diffSummaryItem3.setValue(FILES, (Object)SizeFormatter.format((long)l, (int)2));
        return new DiffSummaryItem(role.getDisplayName(this.threeWay), new IDiffSummaryItem[]{diffSummaryItem, diffSummaryItem3}){

            public Object getValue(String string) {
                if (FOLDERS.equals(string)) {
                    return diffSummaryItem.getValue(string);
                }
                if (FILES.equals(string)) {
                    return NLS.bind((String)StructMsg.FolderDiffSummary_countInSize, (Object)diffSummaryItem.getValue(string), (Object)diffSummaryItem3.getValue(string));
                }
                return super.getValue(string);
            }
        };
    }

    @Override
    protected void createItems(StructDiffModel structDiffModel) {
        this.createDeltaSubItems(StructMsg.FolderDiffSummary_files, structDiffModel, new StructDiffSummary.IDeltaItemFilter(){

            @Override
            public boolean matches(IDiffNode iDiffNode) {
                return !iDiffNode.isStructure();
            }
        });
        Set set = DeltaUtil.deltas();
        for (Delta delta : set) {
            Set<IDiffNode> set2 = structDiffModel.getDeltasOfOverallKind(delta);
            IDiffSummary iDiffSummary = this.createCountAndSizeSummary(set2, delta);
            if (iDiffSummary == null) continue;
            this.setNextSummary(iDiffSummary);
        }
    }
}

