/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.structure.internal.ui.FolderActionsExpandable;
import com.deltawalker.structure.internal.ui.FolderDiffView;
import com.deltawalker.structure.internal.ui.FolderPrefsExpandable;
import com.deltawalker.ui.DashboardCenter;
import com.deltawalker.ui.DiffView;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public class FolderDashboardCenter
extends DashboardCenter {
    private FolderActionsExpandable expActions;
    private FolderPrefsExpandable expSettings;

    public FolderDashboardCenter(Composite composite, int n, DiffView diffView) {
        super(composite, n, diffView);
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        super.connect(iMvcModel, iMvcController);
        this.createSettingsExpandable();
        this.createActionsExpandable();
        this.expActions.connect(iMvcModel, iMvcController);
        this.expSettings.connect(iMvcModel, iMvcController);
    }

    public void createActionsExpandable() {
        if (this.expActions != null) {
            return;
        }
        this.expActions = new FolderActionsExpandable((Composite)this, this.deltaView());
    }

    public void createSettingsExpandable() {
        if (this.expSettings != null) {
            return;
        }
        this.expSettings = new FolderPrefsExpandable((Composite)this, this.deltaView());
    }

    protected FolderDiffView deltaView() {
        return (FolderDiffView)super.deltaView();
    }

    public void disconnect() {
        this.expActions.disconnect();
        this.expSettings.disconnect();
        super.disconnect();
    }

    public void dispose() {
        try {
            this.disconnect();
            if (this.expActions != null) {
                this.expActions.dispose();
                this.expActions = null;
            }
            if (this.expSettings != null) {
                this.expSettings.dispose();
                this.expSettings = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected boolean prefChanged(IPreferenceStore iPreferenceStore, String string) {
        boolean bl = true;
        if (string.equals(PrefKey.D_EXPAND_ACTIONS.toString())) {
            this.expActions.setExpanded(iPreferenceStore.getBoolean(PrefKey.D_EXPAND_ACTIONS.toString()));
        } else if (string.equals(PrefKey.D_EXPAND_SETTINGS.toString())) {
            this.expSettings.setExpanded(iPreferenceStore.getBoolean(PrefKey.D_EXPAND_SETTINGS.toString()));
        } else {
            bl = this.expSettings.prefChanged(iPreferenceStore, string);
            if (!bl) {
                bl = this.expActions.prefChanged(iPreferenceStore, string);
            }
        }
        return bl;
    }
}

