/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.AbstractResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ResourceComparator;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.StructDiffView;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.TreeColumn;

public class FolderColumnBoss
extends ColumnBoss {
    private static final double FUDGE_WIDTH_FACTOR = 1.1;
    private boolean foldersFirst = true;

    public FolderColumnBoss(StructDiffView structDiffView) {
        super(structDiffView, AbstractResource.umPROPS);
        IPreferenceStore iPreferenceStore = structDiffView.getInput().preferences();
        this.foldersFirst = iPreferenceStore.getBoolean(PrefKey.D_LIST_FOLDERS_FIRST.toString());
    }

    private int adjustWidth(int n) {
        return (int)((double)n * 1.1);
    }

    @Override
    public String getExpandColumnTitle(int n) {
        return NLS.bind((String)StructMsg.FolderView_expandColumnTitle, (Object)this.getColumnRole(n).getDisplayName(this.structView().isThreeWay()));
    }

    @Override
    protected void initializeColumnWidths(Role role) {
        GC gC = new GC((Drawable)this.treeView);
        try {
            gC.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            ColumnType columnType = ColumnType.DATE_MODIFIED;
            ColumnBoss.TreeColumnEx treeColumnEx = this.getColumn(role, columnType);
            int n = gC.stringExtent((String)columnType.textForExtent()).x;
            treeColumnEx.setDefaultWidth(this.adjustWidth(n));
            treeColumnEx = this.getColumn(role, ColumnType.DATE_CREATED);
            if (treeColumnEx != null) {
                treeColumnEx.setDefaultWidth(this.adjustWidth(n));
            }
            if ((treeColumnEx = this.getColumn(role, ColumnType.DATE_OPENED)) != null) {
                treeColumnEx.setDefaultWidth(this.adjustWidth(n));
            }
            columnType = ColumnType.SIZE;
            treeColumnEx = this.getColumn(role, columnType);
            treeColumnEx.setDefaultWidth(gC.stringExtent((String)columnType.textForExtent()).x);
            columnType = ColumnType.ATTRIBUTES;
            treeColumnEx = this.getColumn(role, columnType);
            treeColumnEx.setDefaultWidth(this.adjustWidth(gC.stringExtent((String)columnType.textForExtent()).x));
            columnType = ColumnType.OWNER;
            treeColumnEx = this.getColumn(role, columnType);
            treeColumnEx.setDefaultWidth(this.adjustWidth(gC.stringExtent((String)columnType.textForExtent()).x));
            columnType = ColumnType.GROUP;
            treeColumnEx = this.getColumn(role, columnType);
            treeColumnEx.setDefaultWidth(this.adjustWidth(gC.stringExtent((String)columnType.textForExtent()).x));
            Role role2 = Relation.lastRole((boolean)this.structView().isThreeWay());
            if (role != role2) {
                treeColumnEx = this.getColumn(role, ColumnType.DIFFS);
                treeColumnEx.setDefaultWidth(this.structView().getSashWidth());
            }
        }
        finally {
            gC.dispose();
        }
    }

    @Override
    public void resizeColumns(List<ColumnBoss.TreeColumnEx> list, int n) {
        int n2;
        int n3 = 0;
        int n4 = n2 = list.size() - 1;
        while (n4 >= 0) {
            int n5;
            ColumnBoss.TreeColumnEx treeColumnEx = list.get(n4);
            if (n4 > 0 && treeColumnEx.isVisible()) {
                n5 = treeColumnEx.getDefaultWidth();
                treeColumnEx.setWidth(n5);
                n3 += n5;
            }
            if (n4 == 0) {
                n5 = n - n3;
                if (treeColumnEx.getWidth() != n5) {
                    treeColumnEx.setWidth(n5);
                }
            }
            --n4;
        }
    }

    public void setFoldersFirst(boolean bl) {
        if (this.foldersFirst != bl) {
            this.foldersFirst = bl;
            this.sortByColumn((ColumnBoss.TreeColumnEx)this.treeView.getSortColumn());
        }
    }

    @Override
    protected void sortByColumn(ColumnBoss.TreeColumnEx treeColumnEx) {
        TreeColumn[] treeColumnArray;
        if (treeColumnEx.type == ColumnType.DIFFS) {
            return;
        }
        int n = this.treeView.getSortDirection();
        n = this.treeView.getSortColumn() == treeColumnEx ? (n == 128 ? 1024 : 128) : (treeColumnEx.getSortDirection() == 128 ? 1024 : 128);
        this.sortDiffModel(treeColumnEx, n);
        this.treeView.setSortColumn(treeColumnEx);
        this.treeView.setSortDirection(n);
        TreeColumn[] treeColumnArray2 = treeColumnArray = this.treeView.getColumns();
        int n2 = treeColumnArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TreeColumn treeColumn = treeColumnArray2[n3];
            ColumnBoss.TreeColumnEx treeColumnEx2 = (ColumnBoss.TreeColumnEx)treeColumn;
            if (treeColumnEx2 != treeColumnEx && treeColumnEx2.type == treeColumnEx.type) {
                treeColumnEx2.setSortDirection(n);
            }
            ++n3;
        }
        App.instance().stateBoss().saveState();
    }

    @Override
    protected void sortDiffModel(ColumnBoss.TreeColumnEx treeColumnEx, int n) {
        IStructDiffModel iStructDiffModel = this.structView().deltaModel();
        if (iStructDiffModel != null) {
            iStructDiffModel.setSorter((Comparator)new ResourceComparator(treeColumnEx.role, treeColumnEx.type(), this.foldersFirst, n));
        }
    }
}

