/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.structure.StructMsg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConfirmReplaceDialog
extends FormDialog {
    private Button checkbox;
    private List<Choice> choices;
    private Choice defChoice;
    private Image image;
    private int MARGIN = 15;
    private String message;
    private String title;

    public ConfirmReplaceDialog(Shell shell, String string, String string2, int n, List<Choice> list, Choice choice) {
        super(shell);
        this.title = string;
        this.choices = list;
        this.defChoice = choice;
        this.message = string2;
        this.image = this.getSWTImage(n);
    }

    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        this.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        this.setHelpAvailable(false);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        for (Choice object2 : this.choices) {
            this.createButton(composite, object2.id(), object2.label(), this.defChoice == object2);
        }
        Button button = this.getShell().getDefaultButton();
        if (button != null) {
            button.setFocus();
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        tableWrapLayout.leftMargin = this.MARGIN;
        tableWrapLayout.topMargin = this.MARGIN;
        tableWrapLayout.rightMargin = this.MARGIN;
        tableWrapLayout.bottomMargin = 0;
        tableWrapLayout.horizontalSpacing = this.MARGIN;
        Composite composite = iManagedForm.getForm().getBody();
        composite.setLayout((Layout)tableWrapLayout);
        composite.setForeground(JFaceColors.getActiveHyperlinkText((Display)composite.getDisplay()));
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Label label = formToolkit.createLabel(composite, null, 0);
        label.setImage(this.image);
        label.setLayoutData((Object)new TableWrapData(4, 32));
        FormText formText = formToolkit.createFormText(composite, true);
        formText.setLayoutData((Object)new TableWrapData(128));
        formText.setText(this.message, true, false);
        Label label2 = formToolkit.createLabel(composite, null, 0);
        label2.setLayoutData((Object)new TableWrapData());
        label2 = formToolkit.createLabel(composite, null, 0);
        label2.setLayoutData((Object)new TableWrapData());
        this.checkbox = formToolkit.createButton(composite, StructMsg.ConfirmReplaceDialog_showWhenShiftDown, 32);
        this.checkbox.setLayoutData((Object)new TableWrapData(2, 64, 1, 2));
        final IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        this.checkbox.setSelection(iPreferenceStore.getBoolean(PrefKey.D_CONFIRM_REPLACE.toString()));
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iPreferenceStore.setValue(PrefKey.D_CONFIRM_REPLACE.toString(), ConfirmReplaceDialog.this.checkbox.getSelection());
            }
        });
    }

    private Image getSWTImage(final int n) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] imageArray = new Image[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                imageArray[0] = display.getSystemImage(n);
            }
        });
        return imageArray[0];
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        int n = super.open();
        return n == 1 ? Choice.CANCEL.id() : n;
    }

    public static enum Choice {
        CANCEL(StructMsg.Choice_cancel, 0),
        DONT_REPLACE(StructMsg.Choice_dontReplace, 1),
        REPLACE(StructMsg.Choice_replace, 2),
        REPLACE_ALL(StructMsg.Choice_replaceAll, 3);

        private static final int ID_BASE = 770000;
        private static final Map<Integer, Choice> intToEnum;
        private final int id;
        private final String label;

        static {
            intToEnum = new HashMap<Integer, Choice>();
            Choice[] choiceArray = Choice.values();
            int n = choiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Choice choice = choiceArray[n2];
                intToEnum.put(choice.id, choice);
                ++n2;
            }
        }

        public static Choice fromId(int n) {
            return intToEnum.get(n);
        }

        private Choice(String string2, int n2) {
            this.label = string2;
            this.id = 770000 + n2;
        }

        public int id() {
            return this.id;
        }

        public String label() {
            return this.label;
        }
    }

    static enum Icon {
        ERROR(1),
        INFO(2),
        NONE(0),
        QUESTION(3),
        WARNING(4);

        private int id;

        private Icon(int n2) {
            this.id = n2;
        }

        public int id() {
            return this.id;
        }
    }
}

