/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.IStructElement;
import com.deltawalker.Relation;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.differencer.range.ITextDeltaProvider;
import com.deltawalker.differencer.range.RangeDifferencerJob;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructDiffModel;
import com.deltopia.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class TextDeltaProvider
implements ITextDeltaProvider {
    private final Map<Role, IDocument> documents = new EnumMap<Role, IDocument>(Role.class);
    private final IDiffNode node;
    private final Map<Role, IDocument> umDocuments = Collections.unmodifiableMap(this.documents);

    private static IDocument createDocument(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        finally {
            reader.close();
        }
        return new Document(stringBuffer.toString());
    }

    private static String resourceName(Role role, IDiffNode iDiffNode) {
        String string;
        IStructElement iStructElement = iDiffNode.getElement(role);
        if (iStructElement != null && (string = iStructElement.getName()) != null) {
            return string;
        }
        return "";
    }

    public TextDeltaProvider(IDiffNode iDiffNode, boolean bl, String string) throws IOException {
        this.node = iDiffNode;
        Set set = Relation.roles((boolean)iDiffNode.model().isThreeWay());
        for (Role role : set) {
            Reader reader = Differencer.getContents((Object)iDiffNode.getElement(role), (String)string);
            if (reader != null) {
                this.documents.put(role, TextDeltaProvider.createDocument(reader));
                continue;
            }
            if (!bl) continue;
            this.documents.put(role, (IDocument)new Document());
        }
    }

    public DiffRange[] deltas() {
        DiffRange[] diffRangeArray;
        StructDiffModel structDiffModel = (StructDiffModel)this.node.model();
        RangeDifferencerJob rangeDifferencerJob = new RangeDifferencerJob(this.documents, null, structDiffModel.isThreeWay(), structDiffModel.deltaDoc().preferences(), structDiffModel.filters());
        try {
            rangeDifferencerJob.run();
            diffRangeArray = rangeDifferencerJob.getDeltas();
        }
        finally {
            rangeDifferencerJob.dispose();
        }
        return diffRangeArray;
    }

    public IDocument document(Role role) {
        return this.documents.get(role);
    }

    public Map<Role, IDocument> documents() {
        return this.umDocuments;
    }

    public Date lastModifiedTime(Role role) {
        IStructElement iStructElement = this.node.getElement(role);
        if (iStructElement instanceof IResource) {
            return new Date(((IResource)iStructElement).getLastModifiedTime());
        }
        return null;
    }

    public String name(Role role) {
        IDiffNode iDiffNode = this.node;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iDiffNode != null) {
            String string = TextDeltaProvider.resourceName(role, iDiffNode);
            if (StringUtil.isEmpty((String)string)) break;
            arrayList.add(0, string);
            iDiffNode = iDiffNode.getParent();
        }
        return StringUtil.join((Object[])arrayList.toArray(), (String)"/");
    }
}

