/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.interfaces.IFilterBoss;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.PathFilter;
import com.deltawalker.text.Filters;
import com.deltopia.StringUtil;
import com.deltopia.regex.RegexUtil;
import com.deltopia.util.OS;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructPlugin
extends AbstractUIPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(StructPlugin.class);
    private static StructPlugin plugin;

    public static StructPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return StructPlugin.getDefault().getId();
    }

    public StructPlugin() {
        plugin = this;
        LOG.info(String.valueOf(StructPlugin.getPluginId()) + " loaded");
    }

    protected ImageRegistry createImageRegistry() {
        return ImageCache.getImageRegistry();
    }

    public String getId() {
        return this.getBundle().getSymbolicName();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        ArrayList<PathFilter> arrayList = new ArrayList<PathFilter>(6);
        arrayList.add(new PathFilter(FolderFilter.Action.INCLUDE, FolderFilter.Target.BOTH, "*", false, false, true, "f1"));
        PathFilter pathFilter = new PathFilter(FolderFilter.Action.INCLUDE, FolderFilter.Target.FILES, StringUtil.join((Object[])PathFilter.INCLUDE_FILES, (String)RegexUtil.SUB_EXPRESSION_SEPARATOR), false, false, false, "f2");
        arrayList.add(pathFilter);
        pathFilter = new PathFilter(FolderFilter.Action.EXCLUDE, FolderFilter.Target.FILES, StringUtil.join((Object[])PathFilter.EXCLUDE_FILES, (String)RegexUtil.SUB_EXPRESSION_SEPARATOR), false, false, false, "f3");
        arrayList.add(pathFilter);
        arrayList.add(new PathFilter(FolderFilter.Action.EXCLUDE, FolderFilter.Target.FOLDERS, StringUtil.join((Object[])PathFilter.EXCLUDE_FOLDERS, (String)RegexUtil.SUB_EXPRESSION_SEPARATOR), false, false, true, "f4"));
        if (OS.OSX) {
            arrayList.add(new PathFilter(FolderFilter.Action.EXCLUDE, FolderFilter.Target.FILES, StringUtil.join((Object[])PathFilter.EXCLUDE_SYS_FILES_OSX, (String)RegexUtil.SUB_EXPRESSION_SEPARATOR), false, false, true, "f5"));
        }
        IFilterBoss iFilterBoss = App.instance().filterBoss();
        iFilterBoss.setFactoryDefaultFilters((IFilters)new Filters(arrayList, DocType.FOLDER));
    }
}

