/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.reports.IFilterInfoReporter;
import com.deltawalker.structure.StructDiffModel;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructFilterReporter
implements IFilterInfoReporter {
    private static final String FILTERS = "filters";
    private final StructDiffModel dModel;

    public StructFilterReporter(StructDiffModel structDiffModel) {
        this.dModel = structDiffModel;
    }

    public void reportFilterInfo(Node node) {
        IFilters iFilters = this.dModel.filters();
        NodeList nodeList = node.getOwnerDocument().getElementsByTagName("configuration");
        if (nodeList.getLength() != 1) {
            throw new IllegalStateException("configuration");
        }
        this.reportStructureFilters(iFilters, nodeList.item(0));
    }

    private void reportStructureFilters(IFilters iFilters, Node node) {
        Document document = node.getOwnerDocument();
        if (iFilters.getCount() > 0) {
            Element element = document.createElement(FILTERS);
            element.setAttribute("class", "folders");
            node.appendChild(element);
            List list = iFilters.getAllAsList();
            for (IFilter iFilter : list) {
                if (!iFilter.isEnabled()) continue;
                iFilter.report(element);
            }
        }
    }
}

