/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.IStructElement;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IElement;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.ui.ColumnType;
import com.deltopia.eclipse.util.AttributesFormatter;
import com.deltopia.interfaces.IPrincipal;
import com.deltopia.io.FileType;
import java.util.Comparator;

public class ResourceComparator
implements Comparator<IDiffNode> {
    private final ColumnType colType;
    private final boolean foldersFirst;
    private final Role role;
    private final int sort;

    public ResourceComparator(Role role) {
        this(role, ColumnType.EXPAND, true, 128);
    }

    public ResourceComparator(Role role, ColumnType columnType, boolean bl, int n) {
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (columnType == null) {
            throw new NullPointerException("colType");
        }
        if (n != 1024 && n != 128) {
            throw new IllegalArgumentException("sort");
        }
        this.colType = columnType;
        this.foldersFirst = bl;
        this.role = role;
        this.sort = n;
    }

    @Override
    public int compare(IDiffNode iDiffNode, IDiffNode iDiffNode2) {
        if (iDiffNode == null) {
            return -1;
        }
        if (iDiffNode2 == null) {
            return 1;
        }
        int n = 0;
        IStructElement iStructElement = iDiffNode.getElement(this.role);
        IStructElement iStructElement2 = iDiffNode2.getElement(this.role);
        if (iStructElement == null) {
            iStructElement = this.findValidElement(iDiffNode);
        }
        if (iStructElement2 == null) {
            iStructElement2 = this.findValidElement(iDiffNode2);
        }
        if (iStructElement instanceof IResource || iStructElement2 instanceof IResource) {
            IResource iResource = (IResource)iStructElement;
            IResource iResource2 = (IResource)iStructElement2;
            n = this.ensureFoldersFirst(iResource, iResource2);
            if (n != 0) {
                return -n;
            }
            n = this.compareResources(iDiffNode, iDiffNode2, iResource, iResource2);
        }
        return this.sort == 128 ? n : -n;
    }

    private int compareDates(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        return l > l2 ? 1 : 0;
    }

    private int compareResources(IDiffNode iDiffNode, IDiffNode iDiffNode2, IResource iResource, IResource iResource2) {
        int n = 0;
        switch (this.colType) {
            case DATE_MODIFIED: {
                long l = iResource != null ? iResource.getLastModifiedTime() : 0L;
                long l2 = iResource2 != null ? iResource2.getLastModifiedTime() : 0L;
                n = this.compareDates(l, l2);
                break;
            }
            case DIFFS: {
                break;
            }
            case EXPAND: {
                n = iResource.getName().compareToIgnoreCase(iResource2.getName());
                break;
            }
            case ATTRIBUTES: {
                n = AttributesFormatter.format((int)iResource.attributes(), (boolean)false).compareTo(AttributesFormatter.format((int)iResource2.attributes(), (boolean)false));
                n = Integer.valueOf(iResource.attributes()).compareTo(iResource2.attributes());
                break;
            }
            case SIZE: {
                long l = 0L;
                if (iResource != null) {
                    l = iResource.getSize();
                }
                long l3 = 0L;
                if (iResource2 != null) {
                    l3 = iResource2.getSize();
                }
                if (l < l3) {
                    n = -1;
                    break;
                }
                n = l > l3 ? 1 : 0;
                break;
            }
            case OWNER: {
                IPrincipal iPrincipal = null;
                if (iResource != null) {
                    iPrincipal = iResource.getOwner();
                }
                IPrincipal iPrincipal2 = null;
                if (iResource2 != null) {
                    iPrincipal2 = iResource2.getOwner();
                }
                if (iPrincipal == null || iPrincipal2 == null) break;
                n = iPrincipal.getName().compareTo(iPrincipal2.getName());
                break;
            }
            case GROUP: {
                IPrincipal iPrincipal = null;
                if (iResource != null) {
                    iPrincipal = iResource.getGroup();
                }
                IPrincipal iPrincipal3 = null;
                if (iResource2 != null) {
                    iPrincipal3 = iResource2.getGroup();
                }
                if (iPrincipal == null || iPrincipal3 == null) break;
                n = iPrincipal.getName().compareTo(iPrincipal3.getName());
                break;
            }
            case DATE_CREATED: {
                long l = iResource != null ? iResource.createdTime() : 0L;
                long l4 = iResource2 != null ? iResource2.createdTime() : 0L;
                n = this.compareDates(l, l4);
                break;
            }
            case DATE_OPENED: {
                long l = iResource != null ? iResource.lastOpenedTime() : 0L;
                long l5 = iResource2 != null ? iResource2.lastOpenedTime() : 0L;
                n = this.compareDates(l, l5);
            }
        }
        return n;
    }

    private int ensureFoldersFirst(IResource iResource, IResource iResource2) {
        int n = 0;
        if (this.foldersFirst) {
            if (iResource != null && iResource2 != null) {
                n = FileType.compare((FileType)iResource.getType(), (FileType)iResource2.getType());
            } else if (iResource == null && iResource2 != null && iResource2.getType() == FileType.FILE || iResource != null && iResource2 == null && iResource.getType() == FileType.FILE) {
                n = -1;
            } else if (iResource == null && iResource2 != null && iResource2.getType() == FileType.FOLDER || iResource != null && iResource2 == null && iResource.getType() == FileType.FOLDER) {
                n = 1;
            }
            assert (iResource != null || iResource2 != null);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ResourceComparator)) {
            return false;
        }
        ResourceComparator resourceComparator = (ResourceComparator)object;
        return this.colType == resourceComparator.colType && this.foldersFirst == resourceComparator.foldersFirst && this.sort == resourceComparator.sort;
    }

    private IElement findValidElement(IDiffNode iDiffNode) {
        IStructElement iStructElement = iDiffNode.getElement(Role.REF);
        if (iStructElement != null) {
            return iStructElement;
        }
        iStructElement = iDiffNode.getElement(Role.ONE);
        if (iStructElement != null) {
            return iStructElement;
        }
        return iDiffNode.getElement(Role.TWO);
    }

    public boolean foldersFirst() {
        return this.foldersFirst;
    }

    public int sort() {
        return this.sort;
    }
}

