/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.INodeFilter;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFilter
implements INodeFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NodeFilter.class);
    private static final boolean TRACE = LOG.isInfoEnabled();
    private INodeFilter.Criterion criterion;

    public NodeFilter(INodeFilter.Criterion criterion) {
        this.criterion = criterion;
    }

    public INodeFilter.Criterion criterion() {
        return this.criterion;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NodeFilter)) {
            return false;
        }
        if (this.criterion == ((NodeFilter)object).criterion) {
            return true;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.criterion.hashCode();
    }

    public boolean matches(IDiffNode iDiffNode) {
        boolean bl = false;
        switch (this.criterion) {
            case ADDED: {
                bl = iDiffNode.isOverallKind(Delta.Kind.ADDED);
                break;
            }
            case DELETED: {
                bl = iDiffNode.isOverallKind(Delta.Kind.DELETED);
                break;
            }
            case SAME: {
                bl = iDiffNode.isOverallKind(Delta.Kind.SAME);
                break;
            }
            case NEWER: {
                IResource iResource = (IResource)iDiffNode.getElement(Role.REF);
                IResource iResource2 = (IResource)iDiffNode.getElement(Role.ONE);
                if (iResource == null || iResource2 == null) break;
                bl = iResource2.getLastModifiedTime() > iResource.getLastModifiedTime();
                break;
            }
            case OLDER: {
                IResource iResource = (IResource)iDiffNode.getElement(Role.REF);
                IResource iResource3 = (IResource)iDiffNode.getElement(Role.ONE);
                if (iResource == null || iResource3 == null) break;
                boolean bl2 = bl = iResource3.getLastModifiedTime() < iResource.getLastModifiedTime();
            }
        }
        if (TRACE) {
            LOG.info("match=" + bl + "   for:" + iDiffNode);
        }
        return bl;
    }

    public String toString() {
        return this.criterion.toString();
    }
}

