/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.NullStructElement;
import com.deltawalker.Relation;
import com.deltawalker.StructException;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.IStructDiffModelImpl;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class FolderDiffNode
extends DiffNode {
    private final long[] sizes = new long[Role.count()];

    public FolderDiffNode(IStructDiffModelImpl iStructDiffModelImpl, Map<Role, IStructElement> map) {
        super(iStructDiffModelImpl, map);
    }

    @Override
    protected Runnable disposeChildren(boolean bl) {
        Runnable runnable;
        try {
            this.invalidateSizes();
        }
        finally {
            runnable = super.disposeChildren(bl);
        }
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRun(DiffNode.Pass pass, IProgressMonitor iProgressMonitor) throws IOException, StructException {
        if (this.sdModel == null) {
            return false;
        }
        boolean bl = super.doRun(pass, iProgressMonitor);
        if (bl && pass == DiffNode.Pass.COMPARE && !this.hasChildren(true)) {
            Set set = Relation.roles((boolean)this.sdModel.isThreeWay());
            for (Role role : set) {
                IStructElement iStructElement = this.getElement(role);
                if (iStructElement == null || iStructElement instanceof NullStructElement) continue;
                IResource iResource = (IResource)iStructElement;
                long l = iResource.getSize();
                this.setSize(role, l);
                DiffNode diffNode = this.getParent();
                while (diffNode != null) {
                    DiffNode diffNode2 = diffNode;
                    synchronized (diffNode2) {
                        if (diffNode.model() == null) {
                        } else {
                            FolderDiffNode folderDiffNode = (FolderDiffNode)diffNode;
                            long l2 = folderDiffNode.getSize(role);
                            folderDiffNode.setSize(role, l2 + l);
                        }
                    }
                    diffNode = diffNode.getParent();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRunX(DiffNode.Pass pass, IProgressMonitor iProgressMonitor) throws IOException, StructException {
        boolean bl = super.doRun(pass, iProgressMonitor);
        if (bl && pass == DiffNode.Pass.COMPARE && !this.hasChildren(true)) {
            Set set = Relation.roles((boolean)this.sdModel.isThreeWay());
            for (Role role : set) {
                DiffNode diffNode = this.getParent();
                while (diffNode != null) {
                    DiffNode diffNode2 = diffNode;
                    synchronized (diffNode2) {
                        if (diffNode.model() == null) {
                        } else {
                            IResource iResource = (IResource)diffNode.getElement(role);
                            if (iResource == null) {
                            } else {
                                long l = iResource.getSize();
                                if (iResource.getSize() > 0L) {
                                } else {
                                    IDiffNode[] iDiffNodeArray;
                                    IDiffNode[] iDiffNodeArray2 = iDiffNodeArray = diffNode.getChildren(false);
                                    int n = iDiffNodeArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IDiffNode iDiffNode = iDiffNodeArray2[n2];
                                        IResource iResource2 = (IResource)iDiffNode.getElement(role);
                                        if (iResource2 != null) {
                                            l += iResource2.getSize();
                                        }
                                        ++n2;
                                    }
                                    iResource.setSize(l);
                                }
                            }
                        }
                    }
                    diffNode = diffNode.getParent();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize(Role role) {
        long[] lArray = this.sizes;
        synchronized (this.sizes) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.sizes[this.getIndex(role)];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSizes() {
        if (this.sdModel == null) {
            return;
        }
        Set set = Relation.roles((boolean)this.sdModel.isThreeWay());
        for (Role role : set) {
            long l = this.getSize(role);
            if (l == 0L) continue;
            this.setSize(role, 0L);
            DiffNode diffNode = this.getParent();
            while (diffNode != null) {
                DiffNode diffNode2 = diffNode;
                synchronized (diffNode2) {
                    if (diffNode.model() == null) {
                    } else {
                        FolderDiffNode folderDiffNode = (FolderDiffNode)diffNode;
                        long l2 = Math.max(0L, folderDiffNode.getSize(role) - l);
                        folderDiffNode.setSize(role, l2);
                    }
                }
                diffNode = diffNode.getParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSizesX() {
        Set set = Relation.roles((boolean)this.sdModel.isThreeWay());
        for (Role role : set) {
            long l;
            IResource iResource = (IResource)this.getElement(role);
            if (iResource == null || (l = iResource.getSize()) == 0L) continue;
            if (iResource.isDirectory()) {
                iResource.setSize(0L);
            }
            DiffNode diffNode = this.getParent();
            while (diffNode != null) {
                DiffNode diffNode2 = diffNode;
                synchronized (diffNode2) {
                    if (diffNode.model() == null) {
                    } else {
                        IResource iResource2 = (IResource)diffNode.getElement(role);
                        iResource2.setSize(0L);
                    }
                }
                diffNode = diffNode.getParent();
            }
        }
    }

    @Override
    protected boolean preserveChildOrder() {
        return false;
    }

    @Override
    public boolean removeChild(IDiffNode iDiffNode, boolean bl) {
        if (super.removeChild(iDiffNode, bl)) {
            this.invalidateSizes();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(Role role, long l) {
        Object object = this.sizes;
        synchronized (this.sizes) {
            this.sizes[this.getIndex((Role)role)] = l;
            // ** MonitorExit[var4_3 /* !! */ ] (shouldn't be in output)
            object = (IResource)this.getElement(role);
            if (object instanceof IStruct) {
                object.setSize(l);
            }
            return;
        }
    }

    private final int getIndex(Role role) {
        int n = role.toInt();
        if (n >= this.sizes.length) {
            throw new IllegalArgumentException("Invalid role: " + role + " in array size " + this.sizes.length);
        }
        return n;
    }
}

