/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.App;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModelVisitor;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.IFiltersListener;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.interfaces.IReplaceable;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.Role;
import com.deltawalker.script.SortBy;
import com.deltawalker.script.SortDirection;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.IStructDiffModelImpl;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.internal.FolderDiffNode;
import com.deltawalker.structure.internal.IDiffNodeImpl;
import com.deltawalker.structure.internal.ResourceComparator;
import com.deltawalker.structure.internal.SyncOp;
import com.deltawalker.structure.internal.ui.ConfirmReplaceDialog;
import com.deltawalker.structure.internal.ui.FolderDiffSummary;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.structure.internal.ui.dialogs.ProgressDialog;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.FolderDiffController;
import com.deltawalker.structure.ui.actions.CopySelectedAction;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.IDiffSummary;
import com.deltawalker.ui.UIUtil;
import com.deltopia.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderDiffModel
extends StructDiffModel {
    private static final Logger LOG = LoggerFactory.getLogger(FolderDiffModel.class);
    private final IFiltersListener onFilters = new IFiltersListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyFilters() {
            FolderDiffModel folderDiffModel = FolderDiffModel.this;
            synchronized (folderDiffModel) {
                final HashSet<IDiffNode> hashSet = new HashSet<IDiffNode>();
                FolderDiffModel.this.getRoot().accept(new IDiffModelVisitor(){

                    public boolean visit(IDiffNode iDiffNode) {
                        DiffNode diffNode = (DiffNode)iDiffNode;
                        if (FolderDiffModel.this.runByFilter(diffNode.getElements())) {
                            if (diffNode.isExcluded()) {
                                hashSet.add(diffNode);
                            }
                            diffNode.setExcluded(false);
                            return true;
                        }
                        if (!diffNode.isExcluded()) {
                            hashSet.add(diffNode);
                        }
                        diffNode.setExcluded(true);
                        return false;
                    }
                });
                try {
                    FolderDiffModel.this.recompare(hashSet, false);
                }
                finally {
                    FolderDiffModel.this.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
                    FolderDiffModel.this.fireEvent(DiffModelEvent.Type.VIEW_FILTERS_CHANGED, null);
                }
            }
        }

        private void checkInclusionFilters() {
            List list = FolderDiffModel.this.deltaDoc().filters().getAllAsList();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (IFilter iFilter : list) {
                IFolderFilter iFolderFilter;
                if (!(iFilter instanceof IFolderFilter) || (iFolderFilter = (IFolderFilter)iFilter).action() != FolderFilter.Action.INCLUDE || !iFolderFilter.isEnabled()) continue;
                if (iFolderFilter.target() == FolderFilter.Target.BOTH) {
                    bl = true;
                    break;
                }
                if (iFolderFilter.target() == FolderFilter.Target.FOLDERS) {
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    bl3 = true;
                    continue;
                }
                if (iFolderFilter.target() != FolderFilter.Target.FILES) continue;
                if (bl3) {
                    bl = true;
                    break;
                }
                bl2 = true;
            }
            final boolean bl4 = !bl && (!bl3 || !bl2);
            Display display = UIUtil.display();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    List list = App.instance().viewBoss().viewsOnDoc(FolderDiffModel.this.deltaDoc().getId());
                    if (!$assertionsDisabled && list.isEmpty()) {
                        throw new AssertionError();
                    }
                    FolderDiffController folderDiffController = (FolderDiffController)((DiffView)list.get(0)).controller();
                    folderDiffController.alerts().showNoInclusionFilters(bl4);
                }
            });
        }

        public void filtersChanged(Set<? extends IFilter> set) {
            this.checkInclusionFilters();
            IDiffNode iDiffNode = FolderDiffModel.this.getRoot();
            Collection collection = iDiffNode.getElements().values();
            ArrayList<IFolderFilter> arrayList = new ArrayList<IFolderFilter>();
            for (IFilter object2 : set) {
                if (!object2.isEnabled() || !(object2 instanceof IFolderFilter)) continue;
                arrayList.add((IFolderFilter)object2);
            }
            for (IStructElement iStructElement : collection) {
                ((IStruct)iStructElement).setFilters(arrayList);
            }
            if (this.shouldDoFullRecompare(set)) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        FolderDiffModel.this.fullRecompare();
                    }
                };
                thread.setDaemon(true);
                thread.start();
            } else {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        this.applyFilters();
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }

        private boolean shouldDoFullRecompare(Set<? extends IFilter> set) {
            boolean bl = false;
            for (IFilter iFilter : set) {
                if (!(iFilter instanceof ITextFilter)) continue;
                bl = true;
                break;
            }
            Set set2 = FolderDiffModel.this.differencer().method();
            if (bl && set2.contains(Comparison.Method.AS_TEXT)) {
                return true;
            }
            for (IFilter iFilter : set) {
                if (!(iFilter instanceof IFolderFilter) || !((IFolderFilter)iFilter).requiresRecompare()) continue;
                return true;
            }
            return false;
        }
    };
    private Comparator<IDiffNode> sorter;

    public FolderDiffModel(IDiffDoc iDiffDoc) {
        super(iDiffDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("create() for " + this.hashCode());
        }
        this.sorter = new ResourceComparator(Relation.firstRole((boolean)iDiffDoc.isThreeWay()));
        this.filters().addFilterListener(this.onFilters);
    }

    public void copy(final Role role, final Role role2, final boolean bl, IReplaceable iReplaceable) {
        final Shell shell = UIUtil.getActiveWindowShell();
        final SyncModel syncModel = new SyncModel(this);
        List<IDiffNode> list = this.getSelected();
        SyncModel syncModel2 = syncModel;
        ((Object)((Object)syncModel2)).getClass();
        SyncModel.SyncModelEventAdapter syncModelEventAdapter = new SyncModel.SyncModelEventAdapter(syncModel2){

            @Override
            public Control getControl() {
                return shell;
            }
        };
        syncModel.addListener(syncModelEventAdapter);
        SyncModel.SyncNodes syncNodes = new SyncModel.SyncNodes(syncModel);
        syncModel.getNodes(list, role, role2, syncNodes);
        final SyncModel.SyncNodes syncNodes2 = syncNodes.clone();
        ConfirmReplaceDialog.Choice[] choiceArray = new ConfirmReplaceDialog.Choice[]{ConfirmReplaceDialog.Choice.DONT_REPLACE};
        syncModel.confirmNodes(SyncOp.COPY, syncNodes, role, role2, choiceArray, iReplaceable);
        syncModel.removeListener(syncModelEventAdapter);
        if (choiceArray[0] == ConfirmReplaceDialog.Choice.CANCEL) {
            return;
        }
        final long l = syncModel.totalSize(syncNodes.nodes, role);
        ProgressDialog progressDialog = new ProgressDialog(shell){

            @Override
            public String getErrorLabel() {
                return SyncOp.COPY.errorLabel();
            }

            @Override
            protected void run() {
                syncModel.sync(bl ? SyncOp.MOVE : SyncOp.COPY, role, role2, syncNodes2, l);
            }
        };
        boolean bl2 = this.isThreeWay();
        progressDialog.setTitle(CopySelectedAction.constructActionLabel(role, role2, bl, bl2));
        syncModel.addListener(progressDialog);
        progressDialog.open();
    }

    @Override
    public IDiffNodeImpl createNode(Map<Role, IStructElement> map) {
        return new FolderDiffNode(this, map);
    }

    public IDiffSummary createSummary() {
        return new FolderDiffSummary(this);
    }

    @Override
    public void dispose() {
        IFilters iFilters;
        if (LOG.isDebugEnabled()) {
            LOG.debug("dispose() for " + this.hashCode());
        }
        if ((iFilters = this.filters()) != null) {
            iFilters.removeFilterListener(this.onFilters);
        }
        this.sorter = null;
        super.dispose();
    }

    public synchronized Comparator<IDiffNode> getSorter() {
        return this.sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSorter(Comparator<IDiffNode> comparator) {
        Object object = this;
        synchronized (object) {
            if (ObjectUtil.areEqual(this.sorter, comparator)) {
                return;
            }
            this.sorter = comparator;
        }
        this.getRoot().sort();
        object = this.getAllDeltas();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IDiffNode iDiffNode = (IDiffNode)iterator.next();
            iDiffNode.sort();
        }
        this.fireEvent(DiffModelEvent.Type.EXPANDED_CHANGED, this);
    }

    public void sort(Role role, SortBy sortBy, SortDirection sortDirection) {
        int n = sortDirection == SortDirection.ASCENDING ? 128 : 1024;
        boolean bl = PrefUtil.getGlobalPrefs().getBoolean(PrefKey.D_LIST_FOLDERS_FIRST.toString());
        this.setSorter(new ResourceComparator(role, ColumnType.fromSortBy(sortBy), bl, n));
    }
}

