/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal;

import com.deltawalker.IStructElement;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffNodeWorker {
    private static final Logger LOG = LoggerFactory.getLogger(DiffNodeWorker.class);
    private static final boolean toLOG_DETAILS = LOG.isDebugEnabled();
    private static final boolean NODE_TO_SHORT_STRING = true;
    private Job job;
    private boolean jobDone;
    private IDiffNode node;
    private final ISafeRunnable nodeRunnable = new ISafeRunnable(){

        public void handleException(Throwable throwable) {
            LOG.error("nodeRunnable.run() error: ", throwable);
        }

        public void run() throws Exception {
            IDiffNode[] iDiffNodeArray = DiffNodeWorker.this.node.scan(DiffNodeWorker.this.pm);
            if (toLOG_DETAILS) {
                LOG.debug(DiffNodeWorker.toStr(DiffNodeWorker.this.node, iDiffNodeArray, new StringBuilder("Scan: ")).toString());
            }
            if (iDiffNodeArray.length > 0) {
                DiffNodeWorker.this.node.compare(DiffNodeWorker.this.pm);
                IDiffNode[] iDiffNodeArray2 = iDiffNodeArray;
                int n = iDiffNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDiffNode iDiffNode = iDiffNodeArray2[n2];
                    DiffNodeWorker.this.queue(iDiffNode, false);
                    ++n2;
                }
            } else {
                DiffNodeWorker.this.node.compare(DiffNodeWorker.this.pm);
            }
        }
    };
    private IProgressMonitor pm;
    private final List<IDiffNode> queue = new ArrayList<IDiffNode>();
    private final Set<IDiffNode> queueSet = new TreeSet<IDiffNode>(new Comparator<IDiffNode>(){

        @Override
        public int compare(IDiffNode iDiffNode, IDiffNode iDiffNode2) {
            int n = Integer.compare(iDiffNode.hashCode(), iDiffNode2.hashCode());
            if (n == 0 && !iDiffNode.equals(iDiffNode2)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Different objects with same hash " + iDiffNode + " & " + iDiffNode2);
                }
                n = -1;
            }
            return n;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int getQueueSize() {
        List<IDiffNode> list = this.queue;
        synchronized (list) {
            return this.queue.size();
        }
    }

    public boolean isJobDone() {
        return this.jobDone;
    }

    protected void jobAboutToRun(Job job) {
    }

    protected void jobDone(IStatus iStatus) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus jobRun(IProgressMonitor iProgressMonitor) {
        IStatus iStatus;
        assert (iProgressMonitor != null);
        this.pm = iProgressMonitor;
        try {
            while (!iProgressMonitor.isCanceled() && (this.node = this.next()) != null) {
                SafeRunner.run((ISafeRunnable)this.nodeRunnable);
            }
        }
        finally {
            this.pm = null;
            this.node = null;
        }
        if (iProgressMonitor.isCanceled()) {
            iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        iStatus = Status.OK_STATUS;
        return iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiffNode next() {
        List<IDiffNode> list = this.queue;
        synchronized (list) {
            IDiffNode iDiffNode;
            if (this.queue.size() == 0) {
                iDiffNode = null;
            } else {
                iDiffNode = this.queue.remove(0);
                this.queueSet.remove(iDiffNode);
            }
            return iDiffNode;
        }
    }

    private void queue(IDiffNode iDiffNode, boolean bl) {
        this.queue(iDiffNode, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(IDiffNode iDiffNode, boolean bl, boolean bl2) {
        if (iDiffNode == null) {
            throw new IllegalArgumentException("node");
        }
        List<IDiffNode> list = this.queue;
        synchronized (list) {
            if (!this.queueSet.add(iDiffNode)) {
                if (toLOG_DETAILS) {
                    LOG.debug(DiffNodeWorker.toStr(iDiffNode, new StringBuilder("* Queue already added " + (bl ? "first" : "last") + ": ")).toString());
                }
                if (!bl) {
                    return;
                }
                this.queue.remove(iDiffNode);
            }
            if (toLOG_DETAILS) {
                LOG.debug(DiffNodeWorker.toStr(iDiffNode, new StringBuilder("+ Queue add " + (bl ? "first" : "last") + ": ")).toString());
            }
            if (bl) {
                this.queue.add(0, iDiffNode);
            } else {
                this.queue.add(iDiffNode);
            }
        }
        this.startJob(bl2);
    }

    private synchronized void startJob(final boolean bl) {
        if (this.job != null && !this.jobDone || this.jobDone && !bl) {
            return;
        }
        this.jobDone = false;
        this.job = new Job(StructMsg.DiffNodeWorker_comparingFolders){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                return DiffNodeWorker.this.jobRun(iProgressMonitor);
            }
        };
        this.job.setUser(true);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
                DiffNodeWorker.this.jobAboutToRun(iJobChangeEvent.getJob());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent iJobChangeEvent) {
                DiffNodeWorker diffNodeWorker = DiffNodeWorker.this;
                synchronized (diffNodeWorker) {
                    if (iJobChangeEvent.getJob() == DiffNodeWorker.this.job) {
                        DiffNodeWorker.this.job = null;
                        DiffNodeWorker.this.jobDone = true;
                    }
                }
                DiffNodeWorker.this.jobDone(iJobChangeEvent.getResult());
                int n = iJobChangeEvent.getResult().getSeverity();
                if ((n & 8) != 8 && DiffNodeWorker.this.getQueueSize() > 0) {
                    DiffNodeWorker.this.startJob(bl);
                }
            }
        });
        this.job.schedule();
    }

    private static final StringBuilder toStr(IDiffNode iDiffNode, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (iDiffNode == null) {
            stringBuilder.append("<null>");
        } else {
            IStructElement iStructElement = iDiffNode.getElement(Role.REF);
            if (iStructElement == null && (iStructElement = iDiffNode.getElement(Role.ONE)) == null) {
                iStructElement = iDiffNode.getElement(Role.TWO);
            }
            stringBuilder.append(iStructElement != null ? iStructElement.getName() : "<???>");
        }
        return stringBuilder;
    }

    private static final StringBuilder toStr(IDiffNode iDiffNode, IDiffNode[] iDiffNodeArray, StringBuilder stringBuilder) {
        stringBuilder = DiffNodeWorker.toStr(iDiffNode, stringBuilder);
        if (iDiffNodeArray != null && iDiffNodeArray.length > 0) {
            stringBuilder.append("', children=").append(iDiffNodeArray.length).append(": [");
            int n = 0;
            while (n < iDiffNodeArray.length) {
                IDiffNode iDiffNode2 = iDiffNodeArray[n];
                DiffNodeWorker.toStr(iDiffNode2, stringBuilder);
                if (n < iDiffNodeArray.length - 1) {
                    stringBuilder.append(", ");
                }
                ++n;
            }
            stringBuilder.append("]");
        }
        return stringBuilder;
    }
}

