/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.App;
import com.deltawalker.Delta;
import com.deltawalker.DiffMethodUtil;
import com.deltawalker.DiffModel;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.IStructElement;
import com.deltawalker.MergeException;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.ScriptBoss;
import com.deltawalker.StructException;
import com.deltawalker.SyncOpInfo;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.differencer.range.ITextDeltaProvider;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModelVisitor;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IExceptionHandler;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.reports.IFilterInfoReporter;
import com.deltawalker.resources.FolderResource;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.script.SyncOp;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.IStructDiffModelImpl;
import com.deltawalker.structure.internal.DiffNodeWorker;
import com.deltawalker.structure.internal.IDiffNodeImpl;
import com.deltawalker.structure.internal.StructFilterReporter;
import com.deltawalker.structure.internal.StructPlugin;
import com.deltawalker.structure.internal.ui.NodeFilters;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.structure.internal.ui.dialogs.SyncNonConflictsDialog;
import com.deltawalker.structure.ui.actions.ElementWorkbenchAdapter;
import com.deltawalker.text.TextDiffModel;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.IDeltaNotifier;
import com.deltawalker.ui.UIUtil;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.IFile;
import com.deltopia.io.NullSyncProgressMonitor;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public abstract class StructDiffModel
extends DiffModel
implements IStructDiffModelImpl,
IFilterInfoReporter,
IDeltaNotifier {
    private static int INIT_CAPACITY = 2048;
    private static int INIT_CAPACITY_VIEWABLE = 512;
    private static final Logger LOG = LoggerFactory.getLogger(StructDiffModel.class);
    private final IDiffDoc dDoc;
    private Differencer differencer;
    private List<IDiffNode> filtered = Collections.emptyList();
    private final NodeFilters viewFilters = new NodeFilters(this);
    private IDiffNode oldSelected = null;
    private final Map<Role, IStructElement> rootElements = new ConcurrentHashMap<Role, IStructElement>();
    private IDiffNodeImpl rootNode;
    private final List<IDiffNode> selected = new CopyOnWriteArrayList<IDiffNode>();
    private SyncModel syncer = new SyncModel(this);
    private final Map<Role, IStructElement> umRoots = Collections.unmodifiableMap(this.rootElements);
    private final List<IDiffNode> umSelected;
    private int updateCounter;
    private EnumSet<IStructDiffModelImpl.Update> updates = EnumSet.noneOf(IStructDiffModelImpl.Update.class);
    private List<IDiffNode> viewable = Collections.emptyList();
    private DiffNodeWorker worker;

    private static boolean isAncestor(IDiffNode iDiffNode, IDiffNode iDiffNode2) {
        while (iDiffNode2 != null) {
            if (iDiffNode2 == iDiffNode) {
                return true;
            }
            iDiffNode2 = iDiffNode2.getParent();
        }
        return false;
    }

    public static void setExpanded(IDiffNode iDiffNode, boolean bl) {
        int n;
        ArrayList<IDiffNode> arrayList = new ArrayList<IDiffNode>();
        arrayList.add(iDiffNode);
        while ((n = arrayList.size()) > 0) {
            DiffNode diffNode = (DiffNode)arrayList.remove(n - 1);
            diffNode.setExpanded(bl);
            IDiffNode[] iDiffNodeArray = diffNode.getChildren(false);
            if (iDiffNodeArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(iDiffNodeArray));
        }
    }

    public StructDiffModel(IDiffDoc iDiffDoc) {
        super(iDiffDoc);
        this.umSelected = Collections.unmodifiableList(this.selected);
        this.dDoc = iDiffDoc;
        this.setSummary(this.createSummary());
    }

    public void addDeltaListener(IDeltaListener iDeltaListener) {
        if (iDeltaListener == null) {
            throw new NullPointerException("listener");
        }
        this.addListenerObject(iDeltaListener);
    }

    private List<IDiffNode> buildList(IDiffNode iDiffNode, boolean bl) {
        IDiffNode iDiffNode2;
        ArrayList<IDiffNode> arrayList = new ArrayList<IDiffNode>(INIT_CAPACITY);
        if (iDiffNode == null) {
            iDiffNode = this.getRoot();
        }
        if (iDiffNode.getParent() == null) {
            iDiffNode2 = iDiffNode.getChildren(false);
            int n = ((IDiffNode[])iDiffNode2).length - 1;
            while (n >= 0) {
                arrayList.add(iDiffNode2[n]);
                --n;
            }
        } else {
            arrayList.add(iDiffNode);
        }
        iDiffNode2 = null;
        ArrayList<IDiffNode> arrayList2 = null;
        while (true) {
            if (iDiffNode2 != null && (!bl || iDiffNode2.isExpanded())) {
                IDiffNode[] iDiffNodeArray = iDiffNode2.getChildren(false);
                int n = iDiffNodeArray.length - 1;
                while (n >= 0) {
                    arrayList.add(iDiffNodeArray[n]);
                    --n;
                }
            }
            if (arrayList.isEmpty()) break;
            iDiffNode2 = (IDiffNode)arrayList.remove(arrayList.size() - 1);
            if (iDiffNode2.isExcluded()) continue;
            if (bl) {
                if (this.viewFilters.matches(iDiffNode2)) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList(INIT_CAPACITY_VIEWABLE);
                }
                arrayList2.add(iDiffNode2);
                continue;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<IDiffNode>(INIT_CAPACITY);
            }
            arrayList2.add(iDiffNode2);
        }
        return arrayList2 != null ? Collections.unmodifiableList(arrayList2) : Collections.emptyList();
    }

    public boolean canMergeNonConflicts() {
        return this.isThreeWay() && !this.getRoot().isSame();
    }

    protected synchronized boolean canUpdate() {
        return this.updateCounter == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        StructDiffModel structDiffModel = this;
        synchronized (structDiffModel) {
            this.filtered = Collections.emptyList();
            this.viewable = Collections.emptyList();
        }
        this.selected.clear();
    }

    public void clearSelection() {
        Object object2;
        for (Object object2 : this.selected) {
            ((IDiffNodeImpl)object2).setSelected(false);
        }
        object2 = new ArrayList<IDiffNode>(this.selected);
        this.fireEvent(DiffModelEvent.Type.SELECTED_CHANGED, object2);
        this.selected.clear();
    }

    @Override
    public IDiffNodeImpl createNode(Map<Role, IStructElement> map) {
        return new DiffNode(this, map);
    }

    private DiffNodeWorker createWorker(IDiffNode iDiffNode) {
        DiffNodeWorker diffNodeWorker = new DiffNodeWorker(){

            @Override
            protected void jobAboutToRun(Job job) {
                StructDiffModel.this.setSummary(StructDiffModel.this.createSummary());
                StructDiffModel.this.fireEvent(DiffModelEvent.Type.BEGIN_COMPARE, job);
            }

            @Override
            protected void jobDone(IStatus iStatus) {
                StructDiffModel.this.setSummary(StructDiffModel.this.createSummary());
                StructDiffModel.this.fireEvent(DiffModelEvent.Type.END_COMPARE, iStatus);
            }
        };
        return diffNodeWorker;
    }

    public void delete(final Set<IDiffNode> set, final Set<Role> set2, final ISyncProgressMonitor iSyncProgressMonitor, final IExceptionHandler iExceptionHandler) throws IOException {
        final LinkedHashSet linkedHashSet = new LinkedHashSet();
        StructJob structJob = new StructJob("Delete", this.deltaDoc().getId()){

            @Override
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                for (Role role : set2) {
                    Set<ElementWorkbenchAdapter> set3 = StructDiffModel.this.syncer.getElementAdapters(set, role);
                    linkedHashSet.addAll(StructDiffModel.this.syncer.delete(set3, iSyncProgressMonitor, iExceptionHandler));
                }
                return iSyncProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        structJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                IStatus iStatus = iJobChangeEvent.getResult();
                if (iStatus.isOK()) {
                    StructDiffModel.this.recompare(linkedHashSet, false);
                }
            }
        });
        structJob.schedule();
        try {
            structJob.join();
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("Sync job interrupted.", (Throwable)interruptedException);
        }
    }

    public int descendantCount(IDiffNode iDiffNode, boolean bl) {
        return this.getNodes(iDiffNode, bl).size();
    }

    @Override
    public synchronized Differencer differencer() {
        if (this.differencer == null) {
            IPreferenceStore iPreferenceStore = this.dDoc.preferences();
            Set set = DiffMethodUtil.fromInt((int)iPreferenceStore.getInt(PrefKey.D_COMP_METHOD.toString()));
            set = DiffMethodUtil.prune((Set)set, (IPreferenceStore)iPreferenceStore);
            this.differencer = new Differencer(set, iPreferenceStore, this.dDoc.filters());
        }
        return this.differencer;
    }

    public void dispose() {
        this.disposeRoot();
        this.clearCache();
        LinkedList<IStructElement> linkedList = new LinkedList<IStructElement>(this.rootElements.values());
        Iterator<IStructElement> iterator = linkedList.descendingIterator();
        while (iterator.hasNext()) {
            IStructElement iStructElement = iterator.next();
            iStructElement.dispose();
        }
        this.rootElements.clear();
        this.oldSelected = null;
        super.dispose();
    }

    private synchronized void disposeRoot() {
        this.worker = null;
        if (this.rootNode != null) {
            this.rootNode.dispose();
            this.rootNode = null;
        }
        this.differencer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableUpdate(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        StructDiffModel structDiffModel = this;
        synchronized (structDiffModel) {
            int n = this.updateCounter = bl ? (this.updateCounter = this.updateCounter - 1) : (this.updateCounter = this.updateCounter + 1);
            if (this.updateCounter == 0) {
                bl2 = this.updates.contains((Object)IStructDiffModelImpl.Update.EXPANDED);
                bl3 = this.updates.contains((Object)IStructDiffModelImpl.Update.SELECTED);
            }
        }
        if (bl2) {
            this.fireEvent(DiffModelEvent.Type.EXPANDED_CHANGED, this);
        }
        if (bl3) {
            this.fireEvent(DiffModelEvent.Type.SELECTED_CHANGED, this.selected);
        }
    }

    public void fullRecompare() {
        this.disposeRoot();
        this.getChildren(null, false);
    }

    public List<IDiffNode> getAllDeltas() {
        return this.getNodes(this.getRoot(), false);
    }

    public List<IDiffNode> getChildren(IDiffNode iDiffNode) {
        if (iDiffNode == null) {
            iDiffNode = this.getRoot();
        } else {
            this.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
        }
        return this.getNodes(iDiffNode, false);
    }

    public IDiffNode[] getChildren(IDiffNode iDiffNode, boolean bl) {
        if (this.isEmpty()) {
            return IDiffNode.NO_CHILDREN;
        }
        if (iDiffNode == null) {
            iDiffNode = this.rootNodeImpl();
        }
        return iDiffNode.getChildren(bl);
    }

    public Set<IDiffNode> getDeltasOfKind(Delta.Kind kind) {
        List<IDiffNode> list = this.getAllDeltas();
        LinkedHashSet<IDiffNode> linkedHashSet = new LinkedHashSet<IDiffNode>();
        for (IDiffNode iDiffNode : list) {
            if (!iDiffNode.isOverallKind(kind)) continue;
            linkedHashSet.add(iDiffNode);
        }
        return linkedHashSet;
    }

    public Set<IDiffNode> getDeltasOfKind(Set<IDiffNode> set, Delta.Kind kind) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IDiffNode> linkedHashSet = new LinkedHashSet<IDiffNode>();
        for (IDiffNode iDiffNode : set) {
            if (!iDiffNode.isOverallKind(kind)) continue;
            linkedHashSet.add(iDiffNode);
        }
        return linkedHashSet;
    }

    public Set<IDiffNode> getDeltasOfKindsForRelation(Set<IDiffNode> set, Set<Delta.Kind> set2, Relation relation) {
        if (set2 == null) {
            throw new NullPointerException("kinds");
        }
        LinkedHashSet<IDiffNode> linkedHashSet = new LinkedHashSet<IDiffNode>();
        for (IDiffNode iDiffNode : set) {
            Delta.Kind kind;
            if (iDiffNode.isConflict() || iDiffNode.isPseudoConflict() || !set2.contains(kind = ((Delta)iDiffNode).getKind(relation))) continue;
            linkedHashSet.add(iDiffNode);
        }
        return linkedHashSet;
    }

    public Set<IDiffNode> getDeltasOfOverallKind(Delta delta) {
        List<IDiffNode> list = this.getAllDeltas();
        LinkedHashSet<IDiffNode> linkedHashSet = new LinkedHashSet<IDiffNode>();
        for (IDiffNode iDiffNode : list) {
            if (!((Delta)iDiffNode).isOverallKind((com.deltawalker.script.Delta)delta)) continue;
            linkedHashSet.add(iDiffNode);
        }
        return linkedHashSet;
    }

    public Set<IDiffNode> getNewer(Set<IDiffNode> set, Role role, Role role2) {
        if (set == null || set.isEmpty()) {
            set = new LinkedHashSet<IDiffNode>(this.getAllDeltas());
        }
        LinkedHashSet<IDiffNode> linkedHashSet = new LinkedHashSet<IDiffNode>();
        for (IDiffNode iDiffNode : set) {
            if (role == null || role2 == null || !iDiffNode.isChanged() || !((DiffNode)iDiffNode).isSourceNewer(role, role2)) continue;
            linkedHashSet.add(iDiffNode);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IDiffNode> getNodes(IDiffNode iDiffNode, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("-> Get " + (bl ? "viewable" : "filtered"));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        StructDiffModel structDiffModel = this;
        synchronized (structDiffModel) {
            bl2 = this.updates.remove((Object)IStructDiffModelImpl.Update.FILTERED);
            bl3 = this.updates.remove((Object)IStructDiffModelImpl.Update.EXPANDED);
            if (bl2) {
                bl3 = true;
            }
            if (bl2) {
                this.filtered = Collections.emptyList();
            }
            if (bl3) {
                this.viewable = Collections.emptyList();
            }
            if (bl) {
                if (!this.viewable.isEmpty()) {
                    return this.viewable;
                }
            } else if (!this.filtered.isEmpty()) {
                if (bl3) {
                    LOG.warn("Viewable not updated");
                }
                return this.filtered;
            }
        }
        boolean bl4 = LOG.isInfoEnabled();
        long l = 0L;
        if (bl4) {
            l = System.nanoTime();
        }
        List<IDiffNode> list = this.buildList(iDiffNode, bl);
        StructDiffModel structDiffModel2 = this;
        synchronized (structDiffModel2) {
            if (bl) {
                this.viewable = list;
            } else {
                this.filtered = list;
            }
            if (bl4) {
                long l2 = System.nanoTime() - l;
                LOG.info("<- Update viewable=" + bl + " viewable size=" + this.viewable.size() + " filtered size=" + this.filtered.size() + " for " + String.format("%.3f", Float.valueOf((float)l2 / 1000000.0f)) + " ms");
            }
        }
        return list;
    }

    private IDiffNode[] getNodesOfKind(final Delta.Kind kind, final boolean bl) {
        final LinkedList linkedList = new LinkedList();
        this.getRoot().accept(new IDiffModelVisitor(){

            public boolean visit(IDiffNode iDiffNode) {
                if (!iDiffNode.isSame() || kind == Delta.Kind.SAME) {
                    boolean bl3;
                    boolean bl2 = iDiffNode.isOverallKind(kind) ? !bl : (bl3 = bl);
                    if (bl3 && !iDiffNode.isExcluded()) {
                        linkedList.add(iDiffNode);
                    }
                    return true;
                }
                return false;
            }
        });
        return linkedList.toArray(new IDiffNode[linkedList.size()]);
    }

    public IDiffNode getOldSelected() {
        return this.oldSelected;
    }

    public Object getParent(Role role, Object object) {
        return object instanceof DiffNode ? ((DiffNode)object).getParent() : null;
    }

    public IDiffNode getRoot() {
        return this.rootNodeImpl();
    }

    public Map<Role, IStructElement> getRootElements() {
        return this.umRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDiffNode> getSelected() {
        StructDiffModel structDiffModel = this;
        synchronized (structDiffModel) {
            if (this.updates.contains((Object)IStructDiffModelImpl.Update.SELECTED)) {
                this.selected.clear();
                this.updates.remove((Object)IStructDiffModelImpl.Update.SELECTED);
            }
        }
        return this.umSelected;
    }

    public List<IStructElement> getSelectedElements(Role role) {
        List<IDiffNode> list = this.getSelected();
        ArrayList<IStructElement> arrayList = new ArrayList<IStructElement>(list.size());
        for (IDiffNode iDiffNode : list) {
            arrayList.add(iDiffNode.getElement(role));
        }
        return arrayList;
    }

    public List<IDiffNode> getViewable() {
        return this.getNodes(this.getRoot(), true);
    }

    @Override
    public synchronized DiffNodeWorker getWorker() {
        return this.worker;
    }

    public boolean gotoDelta(Goto goto_, boolean bl, Set<Delta> set) {
        List<IDiffNode> list = this.getAllDeltas();
        if (list.isEmpty()) {
            return false;
        }
        List<IDiffNode> list2 = this.getSelected();
        int n = 0;
        IDiffNode iDiffNode = null;
        boolean bl2 = list2.isEmpty();
        if (bl2) {
            IDiffNode iDiffNode2 = iDiffNode = goto_ == Goto.NEXT ? list.get(0) : list.get(list.size() - 1);
            if (goto_ == Goto.PREVIOUS) {
                n = list.indexOf(iDiffNode);
            }
        } else {
            iDiffNode = goto_ == Goto.NEXT ? list2.get(list2.size() - 1) : list2.get(0);
            n = list.indexOf(iDiffNode);
        }
        IDiffNode iDiffNode3 = iDiffNode;
        while (iDiffNode3 != null) {
            if (!iDiffNode3.isSame()) {
                Delta.Kind kind = null;
                if (set.size() == 1) {
                    kind = set.iterator().next().getKind(Relation.REF_ONE);
                }
                if ((set.isEmpty() || iDiffNode3.isOverallKind(kind) || set.size() > 1) && !iDiffNode3.isStructure() && (iDiffNode3 != iDiffNode || bl2)) {
                    if (!bl) {
                        IDiffNode iDiffNode4 = iDiffNode3.getParent();
                        while (iDiffNode4 != null) {
                            if (!iDiffNode4.isExpanded()) {
                                iDiffNode4.setExpanded(true);
                            }
                            iDiffNode4 = iDiffNode4.getParent();
                        }
                        iDiffNode3.setSelected(true, false);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Selecting node: " + iDiffNode3);
                        }
                    }
                    return true;
                }
            }
            if (goto_ == Goto.NEXT) {
                iDiffNode3 = ++n < list.size() ? list.get(n) : null;
                continue;
            }
            IDiffNode iDiffNode5 = iDiffNode3 = --n >= 0 ? list.get(n) : null;
        }
        return false;
    }

    public void invertSelected(IDiffNode iDiffNode) {
        this.selected.clear();
        List<IDiffNode> list = this.getChildren(iDiffNode);
        for (IDiffNode iDiffNode2 : list) {
            IDiffNodeImpl iDiffNodeImpl = (IDiffNodeImpl)iDiffNode2;
            if (iDiffNodeImpl.hasChildren()) continue;
            boolean bl = iDiffNode2.isSelected();
            iDiffNodeImpl.setSelected(!bl);
            if (!bl) continue;
            this.selected.add(iDiffNode2);
        }
        this.fireEvent(DiffModelEvent.Type.SELECTED_CHANGED, this.selected);
    }

    public boolean isEmpty() {
        for (IStructElement iStructElement : this.rootElements.values()) {
            if (StructDiffModel.isNullElement((Object)iStructElement)) continue;
            return false;
        }
        return true;
    }

    public SyncOpInfo mergeNonConflicts(IDiffNode iDiffNode, boolean bl, ISyncProgressMonitor iSyncProgressMonitor, IPreferenceStore iPreferenceStore) throws IOException {
        Object object;
        Role role;
        if (iDiffNode == null) {
            throw new NullPointerException("node");
        }
        if (!DiffMethodUtil.isTextCompare((IPreferenceStore)iPreferenceStore)) {
            return null;
        }
        IDocument iDocument = Role.values();
        int n = ((Role[])iDocument).length;
        int n2 = 0;
        while (n2 < n) {
            role = iDocument[n2];
            object = (IResource)iDiffNode.getElement(role);
            if (StructDiffModel.isNullElement((Object)object)) {
                return null;
            }
            if (!object.contentType().isText(true)) {
                return null;
            }
            ++n2;
        }
        if (bl) {
            return new SyncOpInfo(iDiffNode, SyncOpInfo.Type.MERGE, null, Role.REF, null);
        }
        role = (IPersistableResource)iDiffNode.getElement(Role.REF);
        ITextDeltaProvider iTextDeltaProvider = ((IDiffNodeImpl)iDiffNode).createTextDeltaProvider(false, iPreferenceStore);
        Map map = iTextDeltaProvider.documents();
        try {
            TextDiffModel.mergeNonConflicts((Map)map, (DiffRange[])iTextDeltaProvider.deltas());
            iDocument = (IDocument)map.get(Role.REF);
            object = iDocument.get().getBytes();
            role.save(null, (InputStream)new ByteArrayInputStream((byte[])object), (IProgressMonitor)iSyncProgressMonitor);
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected void mergeNonConflicts(IProgressMonitor iProgressMonitor) throws MergeException {
        ISyncProgressMonitor iSyncProgressMonitor = iProgressMonitor instanceof ISyncProgressMonitor ? (ISyncProgressMonitor)iProgressMonitor : new NullSyncProgressMonitor();
        try {
            final ArrayList<SyncOpInfo> arrayList = new ArrayList<SyncOpInfo>();
            if (!this.syncNonConflicts(arrayList, iSyncProgressMonitor) || arrayList.isEmpty()) {
                return;
            }
            final int[] nArray = new int[]{1};
            GuiExecutor.instance().execute(new Runnable(){

                @Override
                public void run() {
                    SyncNonConflictsDialog syncNonConflictsDialog = new SyncNonConflictsDialog(UIUtil.getActiveWindowShell());
                    syncNonConflictsDialog.setMergeOps(arrayList);
                    nArray[0] = syncNonConflictsDialog.open();
                }
            });
            if (nArray[0] == 0) {
                this.syncNonConflicts(null, iSyncProgressMonitor);
            }
        }
        catch (Throwable throwable) {
            throw new MergeException(throwable);
        }
    }

    public int nodeCount(boolean bl) {
        return this.descendantCount(this.getRoot(), bl);
    }

    @Override
    public final NodeFilters nodeFilters() {
        return this.viewFilters;
    }

    public void recompare(Set<IDiffNode> set, boolean bl) {
        if (set.isEmpty()) {
            return;
        }
        this.removeDescendants(set);
        for (IDiffNode iDiffNode : set) {
            Map map = iDiffNode.getElements();
            Set set2 = Relation.roles((boolean)true);
            HashSet<IStructElement> hashSet = new HashSet<IStructElement>(Role.count());
            for (Role role : set2) {
                IStructElement iStructElement = (IStructElement)map.get(role);
                if (bl && iStructElement instanceof IResource) {
                    ((IResource)iStructElement).updateFileInfo();
                }
                hashSet.add(iStructElement);
            }
            iDiffNode.update(hashSet, true);
        }
    }

    public void removeDeltaListener(IDeltaListener iDeltaListener) {
        if (iDeltaListener == null) {
            throw new NullPointerException("listener");
        }
        this.removeListenerObject(iDeltaListener);
    }

    public void removeDescendants(Set<IDiffNode> set) {
        int n = set.size();
        IDiffNode[] iDiffNodeArray = set.toArray(new IDiffNode[n]);
        boolean bl = false;
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n3) {
            IDiffNode iDiffNode = iDiffNodeArray[n2];
            if (iDiffNode != null) {
                int n4 = n2 + 1;
                while (n4 < n) {
                    IDiffNode iDiffNode2 = iDiffNodeArray[n4];
                    if (iDiffNode2 != null) {
                        if (StructDiffModel.isAncestor(iDiffNode, iDiffNode2)) {
                            iDiffNodeArray[n4] = null;
                            bl = true;
                        } else if (StructDiffModel.isAncestor(iDiffNode2, iDiffNode)) {
                            iDiffNodeArray[n2] = null;
                            bl = true;
                            break;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (bl) {
            set.clear();
            n2 = 0;
            while (n2 < n) {
                IDiffNode iDiffNode = iDiffNodeArray[n2];
                if (iDiffNode != null) {
                    set.add(iDiffNode);
                }
                ++n2;
            }
        }
    }

    public void reportFilterInfo(Node node) {
        new StructFilterReporter(this).reportFilterInfo(node);
    }

    private synchronized IDiffNodeImpl rootNodeImpl() {
        if (this.rootNode == null) {
            boolean bl = this.deltaDoc().preferences().getBoolean(PrefKey.D_COLLECT_INFO_EX.toString());
            for (IStructElement iStructElement : this.rootElements.values()) {
                if (!(iStructElement instanceof FolderResource)) continue;
                ((FolderResource)iStructElement).setListFieldMask(bl);
            }
            this.rootNode = this.createNode(this.rootElements);
            if (!this.isEmpty()) {
                this.worker = this.createWorker(this.rootNode);
            }
        }
        return this.rootNode;
    }

    public boolean runByFilter(Map<Role, IStructElement> map) {
        if (map == null) {
            throw new NullPointerException("elements");
        }
        IFilters iFilters = this.dDoc.filters();
        for (IStructElement iStructElement : map.values()) {
            if (iStructElement == null) continue;
            if (iStructElement instanceof IResource) {
                IFile iFile = ((IResource)iStructElement).file();
                if (!iFilters.matches(iFile)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void select(IDiffNode iDiffNode, boolean bl, boolean bl2, boolean bl3) {
        if (iDiffNode == null) {
            throw new NullPointerException("node");
        }
        if (!bl2) {
            this.clearSelection();
        }
        if (bl) {
            if (!this.selected.contains(iDiffNode)) {
                this.selected.add(iDiffNode);
            }
        } else {
            this.selected.remove(iDiffNode);
        }
        if (bl3) {
            this.fireEvent(DiffModelEvent.Type.SELECTED_CHANGED, iDiffNode);
        }
    }

    public void select(IDiffNode iDiffNode, Delta.Kind kind, boolean bl, boolean bl2) {
        if (kind == null) {
            throw new NullPointerException("kind");
        }
        if (iDiffNode == null) {
            throw new NullPointerException("topNode");
        }
        if (!bl2) {
            this.clearSelection();
        }
        boolean bl3 = false;
        List<IDiffNode> list = this.getChildren(iDiffNode);
        for (IDiffNode iDiffNode2 : list) {
            IDiffNodeImpl iDiffNodeImpl = (IDiffNodeImpl)iDiffNode2;
            if (iDiffNode2.hasChildren() || iDiffNode2.isSame() && kind != Delta.Kind.SAME) continue;
            if (iDiffNode2.isOverallKind(kind)) {
                if (bl || !this.selectNodeImpl(iDiffNodeImpl)) continue;
                bl3 = true;
                continue;
            }
            if (!bl || !this.selectNodeImpl(iDiffNodeImpl)) continue;
            bl3 = true;
        }
        this.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
        this.fireEvent(DiffModelEvent.Type.SELECTED_CHANGED, this.selected);
        if (bl3) {
            this.update(EnumSet.of(IStructDiffModelImpl.Update.EXPANDED));
            this.fireEvent(DiffModelEvent.Type.EXPANDED_CHANGED, this);
        }
    }

    public void select(List<IDiffNode> list, boolean bl) {
        if (!bl) {
            this.clearSelection();
        }
        ArrayList arrayList = null;
        for (IDiffNode iDiffNode : list) {
            IDiffNodeImpl iDiffNodeImpl = (IDiffNodeImpl)iDiffNode;
            if (iDiffNodeImpl.hasChildren()) continue;
            iDiffNodeImpl.setSelected(true);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            this.selected.add(iDiffNode);
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            this.selected.addAll(arrayList);
        }
        this.fireEvent(DiffModelEvent.Type.SELECTED_CHANGED, this.selected);
    }

    private boolean selectNodeImpl(IDiffNodeImpl iDiffNodeImpl) {
        IDiffNodeImpl iDiffNodeImpl2;
        if (!iDiffNodeImpl.hasChildren()) {
            iDiffNodeImpl.setSelected(true);
            this.selected.add(iDiffNodeImpl);
        }
        if ((iDiffNodeImpl2 = (IDiffNodeImpl)iDiffNodeImpl.getParent()) != null && !iDiffNodeImpl2.isExpanded()) {
            iDiffNodeImpl2.setExpandedImpl(true);
            return true;
        }
        return false;
    }

    public void setOldSelected(IDiffNode iDiffNode) {
        this.oldSelected = iDiffNode;
    }

    public void setRootElements(Map<Role, IStructElement> map) {
        this.disposeRoot();
        this.rootElements.clear();
        this.rootElements.putAll(map);
    }

    public Set<IDiffNode> sync(Set<IDiffNode> set, Role role, Role role2, Set<IDiffNode.SyncAction> set2, ISyncProgressMonitor iSyncProgressMonitor, IExceptionHandler iExceptionHandler) throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("sync(src=" + role + ", dst=" + role2 + "sync actions=" + set2 + ")");
        }
        HashSet<IDiffNode> hashSet = new HashSet<IDiffNode>(set.size());
        if (iExceptionHandler == null) {
            iExceptionHandler = this.syncer.getListener();
        }
        for (IDiffNode iDiffNode : set) {
            if (iSyncProgressMonitor.isCanceled()) break;
            SyncOpInfo syncOpInfo = iDiffNode.syncElements(role, role2, set2, iSyncProgressMonitor, iExceptionHandler);
            if (syncOpInfo == null) continue;
            hashSet.add(iDiffNode);
        }
        return hashSet;
    }

    public void synchronize(final SyncOp syncOp, final Set<IDiffNode> set, final Role role, final Role role2, final ISyncProgressMonitor iSyncProgressMonitor) {
        if (LOG.isInfoEnabled()) {
            LOG.info("synchronize(" + syncOp + ", src=" + role + ", dst=" + role2);
        }
        if (syncOp == null) {
            throw new NullPointerException("syncOp");
        }
        if (!(this.isThreeWay() || role != Role.TWO && role2 != Role.TWO)) {
            throw new IllegalArgumentException("Role.TWO specified in a 2-way comparison");
        }
        final LinkedHashSet linkedHashSet = new LinkedHashSet();
        StructJob structJob = null;
        switch (syncOp) {
            case COPY: {
                structJob = new StructJob("Copy", this.deltaDoc().getId()){

                    @Override
                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            linkedHashSet.addAll(StructDiffModel.this.sync(set, role, role2, EnumSet.of(IDiffNode.SyncAction.COPY), iSyncProgressMonitor, null));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (IOException iOException) {
                            return new Status(4, StructPlugin.getPluginId(), String.valueOf(syncOp.toString()) + " failed", (Throwable)iOException);
                        }
                        return iSyncProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                    }
                };
                break;
            }
            case MIRROR: {
                structJob = new StructJob("Mirror", this.deltaDoc().getId()){

                    @Override
                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        Set<IDiffNode> set4 = StructDiffModel.this.getDeltasOfKindsForRelation(set, EnumSet.of(Delta.Kind.CHANGED, Delta.Kind.ADDED), Relation.fromRoles((Role)role, (Role)role2));
                        try {
                            linkedHashSet.addAll(StructDiffModel.this.sync(set4, role, role2, EnumSet.of(IDiffNode.SyncAction.COPY), iSyncProgressMonitor, null));
                            Set<IDiffNode> set2 = StructDiffModel.this.getDeltasOfKind(set, Delta.Kind.DELETED);
                            Set<ElementWorkbenchAdapter> set3 = StructDiffModel.this.syncer.getElementAdapters(set2, role2);
                            linkedHashSet.addAll(StructDiffModel.this.syncer.delete(set3, iSyncProgressMonitor, null));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (IOException iOException) {
                            return new Status(4, StructPlugin.getPluginId(), String.valueOf(syncOp.toString()) + " failed", (Throwable)iOException);
                        }
                        return iSyncProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                    }
                };
                break;
            }
            case MOVE: {
                structJob = new StructJob("Move", this.deltaDoc().getId()){

                    @Override
                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            linkedHashSet.addAll(StructDiffModel.this.sync(set, role, role2, EnumSet.of(IDiffNode.SyncAction.MOVE), iSyncProgressMonitor, null));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (IOException iOException) {
                            return new Status(4, StructPlugin.getPluginId(), String.valueOf(syncOp.toString()) + " failed", (Throwable)iOException);
                        }
                        return iSyncProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                    }
                };
                break;
            }
            case SYNC: {
                structJob = new StructJob("Sync non-conflicts", this.deltaDoc().getId()){

                    @Override
                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            NullSyncProgressMonitor nullSyncProgressMonitor = new NullSyncProgressMonitor();
                            StructDiffModel.this.syncNonConflicts(null, (ISyncProgressMonitor)nullSyncProgressMonitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (Exception exception) {
                            return new Status(4, StructPlugin.getPluginId(), String.valueOf(syncOp.toString()) + " failed", (Throwable)exception);
                        }
                        return iSyncProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                    }
                };
                break;
            }
            case UPDATE: {
                structJob = new StructJob("Update", this.deltaDoc().getId()){

                    @Override
                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        Set<IDiffNode> set2 = StructDiffModel.this.getNewer(set, role, role2);
                        set2.addAll(StructDiffModel.this.getDeltasOfKindsForRelation(set, EnumSet.of(Delta.Kind.ADDED), Relation.fromRoles((Role)role, (Role)role2)));
                        try {
                            linkedHashSet.addAll(StructDiffModel.this.sync(set2, role, role2, EnumSet.of(IDiffNode.SyncAction.COPY), iSyncProgressMonitor, null));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (Exception exception) {
                            return new Status(4, StructPlugin.getPluginId(), String.valueOf(syncOp.toString()) + " failed", (Throwable)exception);
                        }
                        return iSyncProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                    }
                };
            }
        }
        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.SYNC_STARTED, null, this.deltaDoc());
        structJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                App.instance().scriptBoss().fireEvent(ScriptBoss.Event.SYNC_ENDED, null, StructDiffModel.this.deltaDoc());
                IStatus iStatus = iJobChangeEvent.getResult();
                if (iStatus.isOK()) {
                    StructDiffModel.this.recompare(linkedHashSet, false);
                } else {
                    LOG.error(iStatus.getMessage());
                }
            }
        });
        structJob.schedule();
        try {
            structJob.join();
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("Sync job interrupted.", (Throwable)interruptedException);
        }
    }

    private SyncOpInfo syncNode(IDiffNode iDiffNode, boolean bl, ISyncProgressMonitor iSyncProgressMonitor, IPreferenceStore iPreferenceStore) throws IOException, StructException {
        if (iSyncProgressMonitor != null && iSyncProgressMonitor.isCanceled()) {
            return null;
        }
        SyncOpInfo syncOpInfo = null;
        EnumSet<IDiffNode.SyncAction> enumSet = EnumSet.of(IDiffNode.SyncAction.RECOMPARE);
        if (bl) {
            enumSet.add(IDiffNode.SyncAction.DRY_RUN);
        }
        Delta delta = (Delta)iDiffNode;
        if (iDiffNode.isConflict()) {
            if (iDiffNode.isPseudoConflict()) {
                enumSet.add(IDiffNode.SyncAction.COPY);
                syncOpInfo = iDiffNode.syncElements(Role.ONE, Role.REF, enumSet, iSyncProgressMonitor, null);
            } else {
                syncOpInfo = this.mergeNonConflicts(iDiffNode, bl, iSyncProgressMonitor, iPreferenceStore);
            }
        } else if (iDiffNode.isChanged()) {
            enumSet.add(IDiffNode.SyncAction.COPY);
            Role role = Role.ONE;
            if (delta.getKind(Relation.REF_TWO) == Delta.Kind.CHANGED) {
                role = Role.TWO;
            }
            syncOpInfo = iDiffNode.syncElements(role, Role.REF, enumSet, iSyncProgressMonitor, null);
        } else if (iDiffNode.isAdded()) {
            Delta.Kind kind = ((Delta)iDiffNode).getKind(Relation.REF_ONE);
            Role role = kind == Delta.Kind.ADDED ? Role.ONE : Role.TWO;
            enumSet.add(IDiffNode.SyncAction.COPY);
            syncOpInfo = iDiffNode.syncElements(role, Role.REF, enumSet, iSyncProgressMonitor, null);
        } else if (iDiffNode.isDeleted()) {
            if (bl) {
                syncOpInfo = new SyncOpInfo(iDiffNode, SyncOpInfo.Type.DELETE, null, Role.REF);
            } else {
                HashSet<IDiffNode> hashSet = new HashSet<IDiffNode>(1);
                hashSet.add(iDiffNode);
                this.delete(hashSet, Relation.roles((boolean)true), iSyncProgressMonitor, null);
            }
        }
        return syncOpInfo;
    }

    public boolean syncNonConflicts(List<SyncOpInfo> list, ISyncProgressMonitor iSyncProgressMonitor) throws IOException, StructException {
        if (!this.isThreeWay()) {
            throw new IllegalStateException("'syncNonConflicts' can only be performed in a three-way comparsion");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("syncNonConflicts(opInfos=" + list + ")");
        }
        boolean bl = list != null;
        LinkedList<IDiffNode> linkedList = new LinkedList<IDiffNode>();
        List<IDiffNode> list2 = this.getSelected();
        if (list2.isEmpty()) {
            list2 = this.getAllDeltas();
        }
        for (IDiffNode iDiffNode : list2) {
            if (iDiffNode.isSame() || iDiffNode.hasChildren()) continue;
            linkedList.add(iDiffNode);
        }
        IPreferenceStore iPreferenceStore = this.dDoc.preferences();
        for (IDiffNode iDiffNode : linkedList) {
            SyncOpInfo syncOpInfo = this.syncNode(iDiffNode, bl, iSyncProgressMonitor, iPreferenceStore);
            if (!bl || syncOpInfo == null) continue;
            list.add(syncOpInfo);
        }
        return !linkedList.isEmpty();
    }

    @Override
    public synchronized void update(EnumSet<IStructDiffModelImpl.Update> enumSet) {
        this.updates.addAll(enumSet);
    }

    class StructJob
    extends Job {
        private UUID ddid;

        public StructJob(String string, UUID uUID) {
            super(string);
            this.ddid = uUID;
        }

        public boolean belongsTo(Object object) {
            return this.ddid.equals(object);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            return Status.OK_STATUS;
        }
    }
}

