/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.App;
import com.deltawalker.Delta;
import com.deltawalker.DeltaNodeDetail;
import com.deltawalker.DiffModel;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.EncodingUtil;
import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.IStructPropertyProvider;
import com.deltawalker.Relation;
import com.deltawalker.ResourceDelta;
import com.deltawalker.StructException;
import com.deltawalker.SyncOpInfo;
import com.deltawalker.UriInfo;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.differencer.range.ITextDeltaProvider;
import com.deltawalker.differencer.range.RangeDiff;
import com.deltawalker.differencer.range.RangeDifferencer;
import com.deltawalker.interfaces.IContentChangeNotifier;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffModelVisitor;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IEditableStruct;
import com.deltawalker.interfaces.IElement;
import com.deltawalker.interfaces.IExceptionHandler;
import com.deltawalker.interfaces.IFileContentListener;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Resource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.AlignFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.IStructComparator;
import com.deltawalker.structure.IStructDiffModelImpl;
import com.deltawalker.structure.RoleArray;
import com.deltawalker.structure.StructComparator;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.internal.ArrayComparator;
import com.deltawalker.structure.internal.DiffNodeWorker;
import com.deltawalker.structure.internal.IDiffNodeImpl;
import com.deltawalker.structure.internal.TextDeltaProvider;
import com.deltawalker.text.TextDiffModel;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.FileType;
import com.deltopia.util.ArrayUtil;
import com.deltopia.util.BitUtil;
import com.deltopia.util.Checker;
import com.deltopia.util.IDisposable;
import com.deltopia.util.LifecycleUtil;
import com.deltopia.util.OS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffNode
extends Delta
implements IDiffNodeImpl,
IAdaptable,
IFileContentListener {
    private static final byte CAN_UPDATE = 8;
    private static final byte DO_RUN = 32;
    private static final byte EXCLUDED = 1;
    private static final byte EXPANDED = 2;
    private static final byte HAS_TRUE_CONFLICTS = 16;
    private static final Logger LOG = LoggerFactory.getLogger(DiffNode.class);
    private static final byte PASS_COMPARE = 64;
    private static final byte PASS_SCAN = -128;
    private static final byte ALL_PASSES = -64;
    private static final byte SELECTED = 4;
    private static final long WAIT_SCAN_AND_COMPARE_TIMEOUT = 500L;
    private List<IDiffNode> children;
    private IStructComparator[][] comparCache;
    private final IStructComparator[] compars;
    private DeltaNodeDetail[] details;
    private final IStructElement[] elements;
    private byte flags = 0;
    protected final IStructDiffModelImpl sdModel;
    private Set<IStructElement> updates;

    public DiffNode(IStructDiffModelImpl iStructDiffModelImpl, Map<Role, IStructElement> map) {
        Checker.notNull((Object)iStructDiffModelImpl, (String)"sdModel");
        this.sdModel = iStructDiffModelImpl;
        int n = iStructDiffModelImpl.roleCount();
        this.compars = new IStructComparator[n];
        this.elements = new IStructElement[n];
        this.setElements(map);
        if (iStructDiffModelImpl.isThreeWay()) {
            this.setKind(Relation.REF_TWO, Delta.Kind.SAME);
            this.setKind(Relation.ONE_TWO, Delta.Kind.SAME);
        }
        this.details = new DeltaNodeDetail[this.detailCount()];
    }

    private int detailCount() {
        return this.isThreeWay() ? 4 : 1;
    }

    public void accept(IDiffModelVisitor iDiffModelVisitor) {
        if (iDiffModelVisitor.visit((IDiffNode)this)) {
            IDiffNode[] iDiffNodeArray;
            IDiffNode[] iDiffNodeArray2 = iDiffNodeArray = this.getChildren(false);
            int n = iDiffNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffNode iDiffNode = iDiffNodeArray2[n2];
                iDiffNode.accept(iDiffModelVisitor);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(IDiffNode iDiffNode) {
        IDiffNode iDiffNode2 = iDiffNode;
        synchronized (iDiffNode2) {
            ((DiffNode)iDiffNode).parent = this;
        }
        iDiffNode2 = this;
        synchronized (iDiffNode2) {
            if (this.children == null) {
                this.children = new ArrayList<IDiffNode>(2);
            }
            this.children.add(iDiffNode);
        }
    }

    private void addPass(Pass pass) {
        Checker.notNull((Object)((Object)pass), (String)"pass");
        boolean bl = this.setFlags(pass.flag, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(bl ? "Add pass: " : "Pass already added: ") + (Object)((Object)pass));
        }
    }

    private int applyAlignFilters(IProgressMonitor iProgressMonitor, IStructComparator[] iStructComparatorArray, IStructComparator[] iStructComparatorArray2, IStructComparator[] iStructComparatorArray3, boolean bl) {
        int n = 0;
        Map<Role, IStructElement> map = this.getElements();
        List list = null;
        for (IStructElement object : map.values()) {
            if (!(object instanceof IStruct)) continue;
            list = ((IStruct)object).getFilters();
            break;
        }
        if (list != null) {
            String string;
            IFolderFilter iFolderFilter;
            LinkedList<IFolderFilter> linkedList = new LinkedList<IFolderFilter>();
            Object[] n2 = list.iterator();
            while (n2.hasNext()) {
                iFolderFilter = (IFolderFilter)n2.next();
                if (!iFolderFilter.isEnabled() || iFolderFilter.type() != FolderFilter.Type.ALIGN) continue;
                boolean bl2 = true;
                for (IStructElement iStructElement : map.values()) {
                    if (iStructElement != null && !StringUtil.isEmpty((String)(string = iStructElement.getName())) && !(bl2 = ((AlignFilter)iFolderFilter).appliesToFolder(string))) break;
                }
                if (!bl2) continue;
                linkedList.add(iFolderFilter);
            }
            iFolderFilter = new String[iStructComparatorArray2.length];
            if (((IFolderFilter)iFolderFilter).length > 0 && !linkedList.isEmpty()) {
                int n3 = 0;
                while (n3 < ((IFolderFilter)iFolderFilter).length) {
                    IStructComparator n32 = iStructComparatorArray2[n3];
                    if (n32 != null) {
                        iFolderFilter[n3] = n32.getElement().getName();
                    }
                    ++n3;
                }
            }
            if ((n2 = new String[bl ? iStructComparatorArray3.length : 0]).length > 0 && !linkedList.isEmpty()) {
                int iFolderFilter2 = 0;
                while (iFolderFilter2 < n2.length) {
                    IStructElement iStructElement;
                    iStructElement = iStructComparatorArray3[iFolderFilter2];
                    if (iStructElement != null) {
                        n2[iFolderFilter2] = iStructElement.getElement().getName();
                    }
                    ++iFolderFilter2;
                }
            }
            for (IFolderFilter iFolderFilter2 : linkedList) {
                int n4 = 0;
                while (n4 < iStructComparatorArray.length) {
                    string = iStructComparatorArray[n4];
                    if (string != null) {
                        String string2 = string.getElement().getName();
                        int n5 = 0;
                        while (n5 < iStructComparatorArray2.length) {
                            IStructComparator iStructComparator = iStructComparatorArray2[n5];
                            if (iStructComparator != null) {
                                IStructComparator iStructComparator2;
                                boolean bl3;
                                String string3 = iStructComparator.getElement().getName();
                                int n6 = Arrays.binarySearch((Object[])iFolderFilter, string2);
                                if (n6 >= 0) {
                                    iFolderFilter[n6] = "";
                                }
                                IStructComparator iStructComparator3 = n6 >= 0 ? iStructComparatorArray2[n6] : null;
                                boolean bl4 = bl3 = n6 >= 0;
                                if (iFolderFilter2.matches(string2, string3)) {
                                    iStructComparator3 = iStructComparator;
                                    bl3 = true;
                                }
                                int n7 = bl ? Arrays.binarySearch(n2, string2) : -1;
                                boolean bl5 = n7 >= 0;
                                IStructComparator iStructComparator4 = iStructComparator2 = n7 >= 0 ? iStructComparatorArray3[n7] : null;
                                if (bl) {
                                    int n8 = 0;
                                    while (n8 < iStructComparatorArray3.length) {
                                        IStructComparator iStructComparator5 = iStructComparatorArray3[n8];
                                        if (iStructComparator5 != null) {
                                            String string4 = iStructComparator5.getElement().getName();
                                            if (iFolderFilter2.matches(string2, string4)) {
                                                iStructComparator2 = iStructComparator5;
                                                bl5 = true;
                                            }
                                            if (n7 >= 0) {
                                                n2[n7] = "";
                                            }
                                        }
                                        ++n8;
                                    }
                                }
                                if (bl3 || bl5) {
                                    this.createAndAddNode((IStructComparator)string, iStructComparator3, iStructComparator2, bl);
                                    if (n6 >= 0) {
                                        iStructComparatorArray2[n6] = null;
                                    }
                                    string = null;
                                    iStructComparatorArray[n4] = null;
                                    iStructComparatorArray2[n5] = null;
                                    if (bl5) {
                                        iStructComparatorArray3[n5] = null;
                                    }
                                    ++n;
                                }
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
            }
        }
        return n;
    }

    private synchronized boolean areFlagsSet(byte by) {
        return BitUtil.areBitsSet((byte)this.flags, (byte)by);
    }

    public void compare(IProgressMonitor iProgressMonitor) throws IOException, StructException {
        if (this.isExcluded()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("DeltaNode.compare()... Pass.COMPARE is present: " + this.containsPass(Pass.COMPARE) + "  for  " + this.toString());
            }
            if (this.containsPass(Pass.COMPARE)) {
                this.resetResult();
            }
            return;
        }
        this.run(Pass.COMPARE, iProgressMonitor);
    }

    private boolean containsAllPasses() {
        return this.areFlagsSet((byte)-64);
    }

    private boolean containsPass(Pass pass) {
        Checker.notNull((Object)((Object)pass), (String)"pass");
        boolean bl = this.areFlagsSet(pass.flag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Contains pass " + (Object)((Object)pass) + "=" + bl);
        }
        return bl;
    }

    public void contentChanged(IStructElement iStructElement, boolean bl) {
        this.update(iStructElement, bl);
    }

    private IDiffNode createAndAddNode(IStructComparator iStructComparator, IStructComparator iStructComparator2, IStructComparator iStructComparator3, boolean bl) {
        EnumMap<Role, IStructElement> enumMap = new EnumMap<Role, IStructElement>(Role.class);
        EnumMap<Role, IStructComparator> enumMap2 = new EnumMap<Role, IStructComparator>(Role.class);
        enumMap2.put(Role.REF, iStructComparator);
        enumMap.put(Role.REF, iStructComparator != null ? iStructComparator.getElement() : null);
        enumMap2.put(Role.ONE, iStructComparator2);
        enumMap.put(Role.ONE, iStructComparator2 != null ? iStructComparator2.getElement() : null);
        if (bl) {
            enumMap2.put(Role.TWO, iStructComparator3);
            enumMap.put(Role.TWO, iStructComparator3 != null ? iStructComparator3.getElement() : null);
        }
        IDiffNodeImpl iDiffNodeImpl = this.sdModel.createNode(enumMap);
        boolean bl2 = this.isExcluded() ? true : !this.sdModel.runByFilter(enumMap);
        iDiffNodeImpl.setExcluded(bl2);
        iDiffNodeImpl.setComparators(enumMap2);
        this.addChild(iDiffNodeImpl);
        return iDiffNodeImpl;
    }

    private void createComparators(boolean bl, IProgressMonitor iProgressMonitor) throws IOException {
        IStructComparator[] iStructComparatorArray;
        IStructComparator[] iStructComparatorArray2;
        IStructComparator[] iStructComparatorArray3 = !iProgressMonitor.isCanceled() ? this.getChildComparators(Role.REF, iProgressMonitor) : StructComparator.EMPTY_ARRAY;
        if (!iProgressMonitor.isCanceled()) {
            iStructComparatorArray2 = this.getChildComparators(Role.ONE, iProgressMonitor);
        } else {
            iStructComparatorArray2 = StructComparator.EMPTY_ARRAY;
            iStructComparatorArray3 = StructComparator.EMPTY_ARRAY;
        }
        if (bl && !iProgressMonitor.isCanceled()) {
            iStructComparatorArray = this.getChildComparators(Role.TWO, iProgressMonitor);
        } else if (iProgressMonitor.isCanceled()) {
            iStructComparatorArray = StructComparator.EMPTY_ARRAY;
            iStructComparatorArray3 = iStructComparatorArray2 = StructComparator.EMPTY_ARRAY;
        } else {
            iStructComparatorArray = StructComparator.EMPTY_ARRAY;
        }
        if (iStructComparatorArray3.length + iStructComparatorArray2.length + iStructComparatorArray.length != 0) {
            if (this.preserveChildOrder()) {
                this.scanWithStrictOrder(iProgressMonitor, iStructComparatorArray3, iStructComparatorArray2, iStructComparatorArray, bl);
            } else {
                this.scanWithoutStrictOrder(iProgressMonitor, iStructComparatorArray3, iStructComparatorArray2, iStructComparatorArray, bl);
            }
        }
    }

    @Override
    public ITextDeltaProvider createTextDeltaProvider(boolean bl, IPreferenceStore iPreferenceStore) throws IOException {
        if (this.isStructure()) {
            return null;
        }
        return new TextDeltaProvider(this, bl, EncodingUtil.getEncoding((IPreferenceStore)iPreferenceStore));
    }

    public ITextDiffModel createTextDiffModel() throws IOException, StructException {
        Role role2;
        if (this.hasChildren(true)) {
            return null;
        }
        EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
        int n = 0;
        Set set = this.sdModel.deltaDoc().roles();
        for (Role role2 : set) {
            IStructElement iStructElement = this.getElement(role2);
            if (DiffModel.isNullElement((Object)iStructElement)) {
                enumMap.put(role2, new UriInfo("", FileType.FILE));
                continue;
            }
            if (iStructElement instanceof IResource) {
                IResource iResource = (IResource)iStructElement;
                try {
                    if (iResource.contentType().isText(true)) {
                        enumMap.put(role2, new UriInfo(iResource.getUri(), FileType.FILE));
                        ++n;
                        continue;
                    }
                }
                catch (IOException iOException) {
                    LOG.error(null, (Throwable)iOException);
                    return null;
                }
            }
            return null;
        }
        if (n < 2) {
            return null;
        }
        role2 = this.sdModel.deltaDoc();
        IDiffDoc iDiffDoc = App.instance().docBoss().createLinkedDoc((IDiffDoc)role2, enumMap);
        return new TextDiffModel(iDiffDoc);
    }

    public void deepEnableUpdate(boolean bl) {
        IDiffNode[] iDiffNodeArray;
        if (this.enableUpdate(bl) && bl) {
            return;
        }
        IDiffNode[] iDiffNodeArray2 = iDiffNodeArray = this.getChildren();
        int n = iDiffNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffNode iDiffNode = iDiffNodeArray2[n2];
            iDiffNode.deepEnableUpdate(bl);
            ++n2;
        }
    }

    public int depth() {
        int n = -1;
        DiffNode diffNode = this;
        while ((diffNode = diffNode.getParent()) != null) {
            ++n;
        }
        return n;
    }

    public DeltaNodeDetail detail(Relation relation) {
        if (relation == Relation.ONE_REF) {
            relation = Relation.REF_ONE;
        }
        return this.getDetail(relation);
    }

    public DeltaNodeDetail detail(Role[] roleArray) {
        Relation relation = Relation.fromArray((Role[])roleArray);
        return this.getDetail(relation);
    }

    private Differencer differencer() {
        return this.sdModel.differencer();
    }

    public void dispose() {
        super.dispose();
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean bl) {
        DiffNode diffNode = this.getParent();
        if (diffNode != null) {
            diffNode.removeChild(this, bl);
        }
        this.disposeChildren(false);
        Collection<IStructElement> collection = RoleArray.getAll(this.elements);
        for (IStructElement iStructComparatorArray2 : collection) {
            this.installElementListeners((IElement)iStructComparatorArray2, false);
        }
        IStructComparator[] n = this.compars;
        synchronized (this.compars) {
            IStructComparator[] iStructComparatorArray = RoleArray.clearAll(this.compars, true);
            IStructComparator[][] iStructComparatorArray3 = this.comparCache;
            this.comparCache = null;
            // ** MonitorExit[n] (shouldn't be in output)
            LifecycleUtil.disposeAll((IDisposable[])iStructComparatorArray);
            if (iStructComparatorArray3 != null) {
                int n2 = 0;
                while (n2 < iStructComparatorArray3.length) {
                    LifecycleUtil.disposeAll((IDisposable[])iStructComparatorArray3[n2]);
                    ++n2;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable disposeChildren(boolean bl) {
        List<IDiffNode> list;
        Object object = this;
        synchronized (object) {
            try {
                list = this.children;
                this.children = null;
                this.removeAllPasses();
            }
            finally {
                this.notifyAll();
            }
        }
        object = null;
        if (list != null && !list.isEmpty()) {
            if (bl) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        for (IDiffNode iDiffNode : list) {
                            iDiffNode.dispose();
                        }
                    }
                };
            } else {
                for (IDiffNode iDiffNode : list) {
                    iDiffNode.dispose();
                }
            }
            list.clear();
        }
        return object;
    }

    protected boolean doRun(Pass pass, IProgressMonitor iProgressMonitor) throws IOException, StructException {
        this.setFlags((byte)32, true);
        DiffModelEvent.Type type = null;
        try {
            if (iProgressMonitor.isCanceled()) {
                return false;
            }
            boolean bl = this.sdModel.isThreeWay();
            switch (pass) {
                case SCAN: {
                    this.createComparators(bl, iProgressMonitor);
                    type = DiffModelEvent.Type.CHILDREN_CHANGED;
                    break;
                }
                case COMPARE: {
                    this.addPass(Pass.SCAN);
                    Differencer differencer = this.differencer();
                    if (differencer != null) {
                        IStructComparator iStructComparator = this.getComparator(Role.REF);
                        IStructComparator iStructComparator2 = this.getComparator(Role.ONE);
                        IStructComparator iStructComparator3 = bl ? this.getComparator(Role.TWO) : null;
                        ResourceDelta resourceDelta = differencer.compare(bl, (IStructPropertyProvider)iStructComparator, (IStructPropertyProvider)iStructComparator2, (IStructPropertyProvider)iStructComparator3, iProgressMonitor);
                        this.updateResult(resourceDelta);
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        finally {
            this.setFlags((byte)32, false);
        }
        if (type != null) {
            this.fireEvent(type, this);
        }
        return true;
    }

    public boolean enableUpdate(boolean bl) {
        this.setFlags((byte)8, bl);
        boolean bl2 = false;
        if (bl && this.updates != null) {
            bl2 = this.update(this.updates, null);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiffNode findNode(IStructElement iStructElement) {
        if (!this.hasChildren()) {
            return null;
        }
        IStructComparator iStructComparator = StructComparator.staticCreate(null, (IStructElement)iStructElement);
        Set set = this.sdModel.deltaDoc().roles();
        DiffNode diffNode = this;
        synchronized (diffNode) {
            for (IDiffNode iDiffNode : this.children) {
                for (Role role : set) {
                    if (!iStructElement.equals(iDiffNode.getElement(role))) continue;
                    return iDiffNode;
                }
                for (Role role : set) {
                    IStructComparator iStructComparator2 = ((DiffNode)iDiffNode).getComparator(role);
                    if (iStructComparator2 == null || !iStructComparator.equals(iStructComparator2)) continue;
                    return iDiffNode;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDiffNode findNodeByElementName(String string, Set<Role> set) {
        if (!this.hasChildren()) {
            return null;
        }
        DiffNode diffNode = this;
        synchronized (diffNode) {
            for (IDiffNode iDiffNode : this.children) {
                for (Role role : set) {
                    IStructElement iStructElement = iDiffNode.getElement(role);
                    if (iStructElement == null) {
                        throw new IllegalArgumentException("No element for role " + role + " at " + iDiffNode);
                    }
                    String string2 = iStructElement.getName();
                    if (OS.LINUX) {
                        if (!string.equals(string2)) continue;
                        return iDiffNode;
                    }
                    if (!string.equalsIgnoreCase(string2)) continue;
                    return iDiffNode;
                }
            }
            return null;
        }
    }

    protected void fireEvent(DiffModelEvent.Type type, Object object) {
        if (type == DiffModelEvent.Type.CHILDREN_CHANGED) {
            this.sdModel.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
        }
        this.sdModel.fireEvent(type, object);
    }

    public Object getAdapter(Class clazz) {
        if (IDiffModel.class.equals((Object)clazz)) assert (false);
        if (ITextDeltaProvider.class.equals((Object)clazz)) {
            try {
                return this.createTextDeltaProvider(true, this.preferences());
            }
            catch (IOException iOException) {
                LOG.error("createTextDeltaProvider() failed", (Throwable)iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructComparator[] getChildComparators(Role role, IProgressMonitor iProgressMonitor) throws IOException {
        IStructComparator[] iStructComparatorArray;
        if (this.containsPass(Pass.SCAN)) {
            return StructComparator.EMPTY_ARRAY;
        }
        int n = role.toInt();
        IStructComparator iStructComparator = this.compars;
        synchronized (iStructComparator) {
            if (this.comparCache != null && this.comparCache[n] != null) {
                return this.comparCache[n];
            }
        }
        iStructComparator = this.getComparator(role);
        IStructComparator[] iStructComparatorArray2 = iStructComparatorArray = iStructComparator != null ? iStructComparator.getChildren(iProgressMonitor) : null;
        if (iStructComparatorArray == null) {
            iStructComparatorArray = StructComparator.EMPTY_ARRAY;
        }
        IStructComparator[] iStructComparatorArray3 = this.compars;
        synchronized (this.compars) {
            if (this.comparCache == null) {
                this.comparCache = new IStructComparator[this.compars.length][];
            }
            this.comparCache[n] = iStructComparatorArray;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return iStructComparatorArray;
        }
    }

    public synchronized IDiffNode[] getChildren() {
        if (this.hasChildren()) {
            return this.children.toArray(new IDiffNode[this.children.size()]);
        }
        return NO_CHILDREN;
    }

    public IDiffNode[] getChildren(boolean bl) {
        if (!bl && this.areFlagsSet((byte)32)) {
            return NO_CHILDREN;
        }
        this.scan(bl, bl);
        return this.getChildren();
    }

    private IStructComparator getComparator(Role role) {
        IStructElement iStructElement;
        IStructComparator iStructComparator = RoleArray.getObject(this.compars, role);
        if (iStructComparator == null && !StructDiffModel.isNullElement((Object)(iStructElement = RoleArray.getObject(this.elements, role)))) {
            iStructComparator = StructComparator.staticCreate(null, (IStructElement)iStructElement);
            RoleArray.setObject(this.compars, role, iStructComparator);
        }
        return iStructComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeltaNodeDetail getDetail(Relation relation) {
        Checker.notNull((Object)relation, (String)"relation");
        DiffNode diffNode = this;
        synchronized (diffNode) {
            return this.details[relation.toInt()];
        }
    }

    public IStructElement getElement(Role role) {
        return RoleArray.getObject(this.elements, role);
    }

    public Map<Role, IStructElement> getElements() {
        return RoleArray.getAllAsMap(this.elements, true);
    }

    public synchronized DiffNode getParent() {
        return (DiffNode)this.parent;
    }

    public synchronized boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(boolean bl) throws IOException, StructException {
        if (!bl && this.areFlagsSet((byte)32)) {
            return false;
        }
        DiffNode diffNode = this;
        synchronized (diffNode) {
            Role role;
            boolean bl2 = this.hasChildren();
            if (bl2) return bl2;
            if (this.containsPass(Pass.SCAN)) {
                return bl2;
            }
            if (!bl) return false;
            Set set = this.sdModel.deltaDoc().roles();
            Iterator iterator = set.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (this.getChildComparators(role = (Role)iterator.next(), (IProgressMonitor)new NullProgressMonitor()).length <= 0);
            return true;
        }
    }

    public boolean hasElements() {
        return RoleArray.getValidElementCount(this.elements) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasTrueConflicts() {
        if (this.areFlagsSet((byte)16)) {
            return true;
        }
        if (!this.hasChildren()) {
            return false;
        }
        DiffNode diffNode = this;
        synchronized (diffNode) {
            IDiffNode iDiffNode;
            Iterator<IDiffNode> iterator = this.children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(iDiffNode = iterator.next()).hasTrueConflicts());
            return true;
        }
    }

    public Image image(Role role) {
        IStructElement iStructElement = this.getElement(role);
        return iStructElement != null ? iStructElement.getImage() : null;
    }

    private void installElementListeners(IElement iElement, boolean bl) {
        if (bl) {
            if (iElement instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)iElement).addContentChangeListener((IFileContentListener)this);
            }
        } else if (iElement instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)iElement).removeContentChangeListener((IFileContentListener)this);
        }
    }

    public boolean isConflict() {
        if (this.isStructure()) {
            return false;
        }
        return super.isConflict();
    }

    public boolean isExcluded() {
        return this.areFlagsSet((byte)1);
    }

    public boolean isExpanded() {
        return this.areFlagsSet((byte)2);
    }

    public boolean isFilteredOut() {
        return this.isExcluded() || this.sdModel.nodeFilters().matches(this);
    }

    public boolean isSelected() {
        return this.areFlagsSet((byte)4);
    }

    public boolean isSourceNewer(Role role, Role role2) {
        IResource iResource = (IResource)this.getElement(role);
        IResource iResource2 = (IResource)this.getElement(role2);
        if (iResource != null && iResource2 != null && !iResource.isDirectory() && !iResource2.isDirectory()) {
            return iResource.getLastModifiedTime() > iResource2.getLastModifiedTime();
        }
        return false;
    }

    public boolean isStructure() {
        if (this.hasChildren()) {
            return true;
        }
        Set set = this.sdModel.deltaDoc().roles();
        for (Role role : set) {
            if (!(this.getElement(role) instanceof IStruct)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStructDiffModelImpl model() {
        return this.sdModel;
    }

    public IDiffNode next(boolean bl) {
        assert (false);
        DiffNode diffNode = this.getParent();
        if ((this.hasChildren() || diffNode == null) && this.children instanceof TreeSet) {
            return (IDiffNode)((TreeSet)((Object)this.children)).first();
        }
        return diffNode.nextNode(this, bl);
    }

    @Override
    public IDiffNode nextNode(IDiffNode iDiffNode, boolean bl) {
        DiffNode diffNode;
        IDiffNode iDiffNode2 = null;
        if (this.children instanceof TreeSet) {
            iDiffNode2 = ((TreeSet)((Object)this.children)).higher(iDiffNode);
        }
        if (iDiffNode2 == null && (diffNode = this.getParent()) != null) {
            return diffNode.nextNode(this, bl);
        }
        return iDiffNode2;
    }

    private IPreferenceStore preferences() {
        return this.sdModel.deltaDoc().preferences();
    }

    protected boolean preserveChildOrder() {
        return true;
    }

    public IDiffNode previous() {
        return null;
    }

    public IDiffNode previous(boolean bl) {
        assert (false);
        DiffNode diffNode = this.getParent();
        if (diffNode != null) {
            IDiffNode iDiffNode = diffNode.previousNode(this, bl);
            if (iDiffNode == null) {
                return diffNode;
            }
            IDiffNode[] iDiffNodeArray = iDiffNode.getChildren(false);
            if (iDiffNodeArray.length > 0) {
                return iDiffNodeArray[iDiffNodeArray.length - 1];
            }
            return iDiffNode;
        }
        return this;
    }

    @Override
    public IDiffNode previousNode(IDiffNode iDiffNode, boolean bl) {
        if (this.children instanceof TreeSet) {
            return ((TreeSet)((Object)this.children)).lower(iDiffNode);
        }
        return null;
    }

    private void removeAllPasses() {
        boolean bl = this.setFlags((byte)-64, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(bl ? "Remove all passes" : "All passes already removed") + " flags=0b" + Integer.toBinaryString(this.flags & 0xFF));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeChild(IDiffNode iDiffNode, boolean bl) {
        if (!this.hasChildren()) {
            return false;
        }
        DiffNode diffNode = this;
        synchronized (diffNode) {
            if (!this.children.remove(iDiffNode)) {
                return false;
            }
        }
        diffNode = iDiffNode;
        synchronized (diffNode) {
            ((DiffNode)iDiffNode).parent = null;
        }
        this.sdModel.update(EnumSet.allOf(IStructDiffModelImpl.Update.class));
        if (bl) {
            this.removeAllPasses();
        }
        this.resetResult();
        this.fireEvent(DiffModelEvent.Type.CHILDREN_CHANGED, this);
        return true;
    }

    public boolean removeElement(IStructElement iStructElement, boolean bl, boolean bl2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        if (iSyncProgressMonitor != null) {
            iSyncProgressMonitor.subTask(iStructElement instanceof IResource ? ((IResource)iStructElement).getUri() : iStructElement.getName());
        }
        if (bl) {
            ((IEditableStruct)iStructElement.getParent()).deleteChild(iStructElement, bl2, iSyncProgressMonitor);
        }
        return RoleArray.removeObjectRef(this.elements, iStructElement);
    }

    private void removePass(Pass pass) {
        Checker.notNull((Object)((Object)pass), (String)"pass");
        boolean bl = this.setFlags(pass.flag, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(bl ? "Removed pass: " : "Pass already removed: ") + (Object)((Object)pass));
        }
    }

    public void renameElement(Role role, String string) throws IOException {
        IStructElement iStructElement3;
        Object object2;
        if (role == null) {
            throw new NullPointerException("'role' cannot be null.");
        }
        if (string == null) {
            throw new NullPointerException("'name' cannot be null.");
        }
        IStructElement iStructElement2 = this.getElement(role);
        if (iStructElement2 == null) {
            throw new IllegalArgumentException("An element with the specified role does not exist.");
        }
        Map map = this.model().deltaDoc().uriInfo(role).properties();
        IResource iResource = (IResource)iStructElement2;
        if (string.equals(iResource.getName())) {
            return;
        }
        iResource.renameTo(string, map, false);
        boolean bl = false;
        HashSet<Object> hashSet = new HashSet<Object>();
        Set set = Relation.others((Role)role, (boolean)this.sdModel.isThreeWay());
        IDiffNode iDiffNode = this.getParent().findNodeByElementName(iResource.getName(), set);
        if (iDiffNode != null) {
            for (Object object2 : set) {
                iStructElement3 = iDiffNode.getElement((Role)object2);
                if (iStructElement3 == null) continue;
                hashSet.add(iStructElement3);
            }
        }
        for (Object object2 : set) {
            iStructElement3 = RoleArray.getObject(this.elements, (Role)object2);
            if (iStructElement3 == null) continue;
            hashSet.add(iStructElement3);
            bl = true;
        }
        hashSet.add(iResource);
        object2 = this.getParent();
        if (bl) {
            RoleArray.removeObject(this.elements, role);
            RoleArray.removeObject(this.compars, role);
            if (iDiffNode == null) {
                EnumMap enumMap = new EnumMap(Role.class);
                enumMap.put(role, iResource);
                for (IStructElement iStructElement3 : set) {
                    enumMap.put((Role)iStructElement3, null);
                }
                object2.addChild(this.sdModel.createNode(enumMap));
            }
            object2.update(hashSet, true);
        } else if (iDiffNode != null) {
            object2.removeChild((IDiffNode)this, false);
            object2.update(hashSet, true);
        }
        object2.sort();
    }

    private void resetResult() {
        Set<IDiffNode> set = this.updateResult(new ResourceDelta());
        if (!set.isEmpty()) {
            this.fireEvent(DiffModelEvent.Type.DIFF_INFO_CHANGED, set.toArray(new IDiffNode[set.size()]));
        }
    }

    public Resource resource(Role role) throws NullPointerException, IllegalArgumentException {
        if (role == null) {
            throw new NullPointerException("'role' cannot be null.");
        }
        if (!this.sdModel.deltaDoc().roles().contains(role)) {
            String string = "Role.{0}  is not a valid role for this comparison.";
            throw new IllegalArgumentException(NLS.bind((String)string, (Object)role));
        }
        return (Resource)this.getElement(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(Pass pass, IProgressMonitor iProgressMonitor) {
        if (this.containsPass(pass)) {
            if (!LOG.isInfoEnabled()) return;
            LOG.info("Returning!: " + (Object)((Object)pass) + "  done for " + this.toString());
            return;
        }
        boolean bl = true;
        Set set = this.sdModel.deltaDoc().roles();
        for (Role role : set) {
            if (StructDiffModel.isNullElement((Object)this.getElement(role))) continue;
            bl = false;
            break;
        }
        if (bl) {
            if (this.parent == null) {
                return;
            }
            LOG.warn("Delta node with no elements: " + this.toString());
            assert (false);
        }
        this.enableUpdate(false);
        try {
            try {
                this.doRun(pass, iProgressMonitor);
            }
            catch (Throwable throwable) {
                IDoc iDoc = this.sdModel.deltaDoc().doc(0, Role.REF);
                if (iDoc != null) {
                    iDoc.setUriInfoError(throwable);
                }
                IStructComparator[] iStructComparatorArray = this.compars;
                synchronized (this.compars) {
                    this.comparCache = null;
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    this.addPass(pass);
                    if (LOG.isInfoEnabled()) {
                        if (pass == Pass.SCAN) {
                            LOG.info((Object)((Object)pass) + " done for " + this.toStringElements());
                        } else {
                            LOG.info((Object)((Object)pass) + " done for " + this.toString());
                        }
                    }
                    this.enableUpdate(true);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            IStructComparator[] iStructComparatorArray = this.compars;
            synchronized (this.compars) {
                this.comparCache = null;
                // ** MonitorExit[var8_9] (shouldn't be in output)
                this.addPass(pass);
                if (LOG.isInfoEnabled()) {
                    if (pass == Pass.SCAN) {
                        LOG.info((Object)((Object)pass) + " done for " + this.toStringElements());
                    } else {
                        LOG.info((Object)((Object)pass) + " done for " + this.toString());
                    }
                }
                this.enableUpdate(true);
                throw throwable;
            }
        }
        IStructComparator[] iStructComparatorArray = this.compars;
        synchronized (this.compars) {
            this.comparCache = null;
            // ** MonitorExit[var8_10] (shouldn't be in output)
            this.addPass(pass);
            if (LOG.isInfoEnabled()) {
                if (pass == Pass.SCAN) {
                    LOG.info((Object)((Object)pass) + " done for " + this.toStringElements());
                } else {
                    LOG.info((Object)((Object)pass) + " done for " + this.toString());
                }
            }
            this.enableUpdate(true);
            return;
        }
    }

    private void scan(boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (!this.sdModel.deltaDoc().isEmpty()) {
            DiffNodeWorker diffNodeWorker;
            if (!this.containsPass(Pass.SCAN) && (diffNodeWorker = this.sdModel.getWorker()) != null) {
                diffNodeWorker.queue(this, true, bl ? true : bl2);
                bl3 = bl;
            }
            if (bl && !bl3 && !this.containsAllPasses() && (diffNodeWorker = this.sdModel.getWorker()) != null) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.waitScanAndCompare();
        }
    }

    public IDiffNode[] scan(IProgressMonitor iProgressMonitor) {
        this.run(Pass.SCAN, iProgressMonitor);
        return this.getChildren();
    }

    private int scanWithoutStrictOrder(IProgressMonitor iProgressMonitor, IStructComparator[] iStructComparatorArray, IStructComparator[] iStructComparatorArray2, IStructComparator[] iStructComparatorArray3, boolean bl) {
        IStructComparator iStructComparator;
        int n = this.applyAlignFilters(iProgressMonitor, iStructComparatorArray, iStructComparatorArray2, iStructComparatorArray3, bl);
        int n2 = iStructComparatorArray.length + iStructComparatorArray2.length + iStructComparatorArray3.length;
        LinkedHashSet<IStructComparator> linkedHashSet = new LinkedHashSet<IStructComparator>(n2);
        HashMap<IStructComparator, IStructComparator> hashMap = new HashMap<IStructComparator, IStructComparator>();
        IStructComparator[] iStructComparatorArray4 = iStructComparatorArray;
        int n3 = iStructComparatorArray.length;
        int n4 = 0;
        while (n4 < n3) {
            iStructComparator = iStructComparatorArray4[n4];
            if (iStructComparator != null) {
                hashMap.put(iStructComparator, iStructComparator);
                linkedHashSet.add(iStructComparator);
            }
            ++n4;
        }
        iStructComparator = new HashMap();
        IStructComparator[] iStructComparatorArray5 = iStructComparatorArray2;
        int n5 = iStructComparatorArray2.length;
        n3 = 0;
        while (n3 < n5) {
            IStructComparator iStructComparator2 = iStructComparatorArray5[n3];
            if (iStructComparator2 != null) {
                iStructComparator.put(iStructComparator2, iStructComparator2);
                linkedHashSet.add(iStructComparator2);
            }
            ++n3;
        }
        HashMap<IStructComparator, IStructComparator> hashMap2 = new HashMap<IStructComparator, IStructComparator>();
        IStructComparator[] iStructComparatorArray6 = iStructComparatorArray3;
        int n6 = iStructComparatorArray3.length;
        n5 = 0;
        while (n5 < n6) {
            IStructComparator iStructComparator3 = iStructComparatorArray6[n5];
            if (iStructComparator3 != null) {
                hashMap2.put(iStructComparator3, iStructComparator3);
                linkedHashSet.add(iStructComparator3);
            }
            ++n5;
        }
        for (IStructComparator iStructComparator4 : linkedHashSet) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) break;
            IDiffNode iDiffNode = this.createAndAddNode((IStructComparator)hashMap.get(iStructComparator4), (IStructComparator)iStructComparator.get(iStructComparator4), (IStructComparator)hashMap2.get(iStructComparator4), bl);
            if (iDiffNode == null) continue;
            ++n;
        }
        this.sort();
        Object[][] objectArrayArray = new Object[Role.count()][];
        objectArrayArray[Role.REF.toInt()] = iStructComparatorArray;
        objectArrayArray[Role.ONE.toInt()] = iStructComparatorArray2;
        objectArrayArray[Role.TWO.toInt()] = iStructComparatorArray3;
        return n;
    }

    private int scanWithStrictOrder(IProgressMonitor iProgressMonitor, IStructComparator[] iStructComparatorArray, IStructComparator[] iStructComparatorArray2, IStructComparator[] iStructComparatorArray3, boolean bl) {
        EnumMap<Role, ArrayComparator> enumMap = new EnumMap<Role, ArrayComparator>(Role.class);
        enumMap.put(Role.REF, new ArrayComparator(iStructComparatorArray));
        enumMap.put(Role.ONE, new ArrayComparator(iStructComparatorArray2));
        if (bl) {
            enumMap.put(Role.TWO, new ArrayComparator(iStructComparatorArray3));
        }
        RangeDiff[] rangeDiffArray = new RangeDifferencer(this.preferences()).findAllDeltas(iProgressMonitor, enumMap, RangeDifferencer.Target.LINES);
        int n = 0;
        RangeDiff[] rangeDiffArray2 = rangeDiffArray;
        int n2 = rangeDiffArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            RangeDiff rangeDiff = rangeDiffArray2[n3];
            if (rangeDiff.isSame()) {
                int n6 = rangeDiff.length1();
                n5 = rangeDiff.start0();
                int n7 = rangeDiff.start1();
                n4 = rangeDiff.start2();
                int n8 = 0;
                while (n8 < n6) {
                    IStructComparator iStructComparator = iStructComparatorArray[n5 + n8];
                    IStructComparator iStructComparator2 = iStructComparatorArray2[n7 + n8];
                    IStructComparator iStructComparator3 = bl ? iStructComparatorArray3[n4 + n8] : null;
                    IDiffNode iDiffNode = this.createAndAddNode(iStructComparator, iStructComparator2, iStructComparator3, bl);
                    if (iDiffNode != null) {
                        ++n;
                    }
                    ++n8;
                }
            } else {
                IStructComparator[] iStructComparatorArray4;
                if (bl) {
                    n5 = rangeDiff.length2();
                    iStructComparatorArray4 = new IStructComparator[n5];
                    System.arraycopy(iStructComparatorArray3, rangeDiff.start2(), iStructComparatorArray4, 0, n5);
                } else {
                    iStructComparatorArray4 = StructComparator.EMPTY_ARRAY;
                }
                n5 = rangeDiff.length0();
                IStructComparator[] iStructComparatorArray5 = new IStructComparator[n5];
                System.arraycopy(iStructComparatorArray, rangeDiff.start0(), iStructComparatorArray5, 0, n5);
                n4 = rangeDiff.length1();
                IStructComparator[] iStructComparatorArray6 = new IStructComparator[n4];
                System.arraycopy(iStructComparatorArray2, rangeDiff.start2(), iStructComparatorArray6, 0, n4);
                n += this.scanWithoutStrictOrder(iProgressMonitor, iStructComparatorArray5, iStructComparatorArray6, iStructComparatorArray4, bl);
            }
            ++n3;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComparators(Map<Role, IStructComparator> map) {
        IStructComparator[] iStructComparatorArray = this.compars;
        synchronized (this.compars) {
            RoleArray.clearAll(this.compars, false);
            for (Map.Entry<Role, IStructComparator> entry : map.entrySet()) {
                IStructComparator iStructComparator = entry.getValue();
                if (iStructComparator == null) continue;
                RoleArray.setObject(this.compars, entry.getKey(), iStructComparator);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setElement(Role role, IStructElement iStructElement) {
        IStructElement iStructElement2 = RoleArray.getObject(this.elements, role);
        if (iStructElement2 == iStructElement) {
            return;
        }
        this.installElementListeners((IElement)iStructElement2, false);
        RoleArray.setObject(this.elements, role, iStructElement);
        RoleArray.removeObject(this.compars, role);
        this.installElementListeners((IElement)iStructElement, true);
    }

    @Override
    public void setElements(Map<Role, IStructElement> map) {
        for (Map.Entry<Role, IStructElement> entry : map.entrySet()) {
            this.setElement(entry.getKey(), entry.getValue());
        }
    }

    public void setExcluded(boolean bl) {
        this.setFlags((byte)1, bl);
        Collection<IStructElement> collection = RoleArray.getAll(this.elements);
        for (IStructElement iStructElement : collection) {
            if (!(iStructElement instanceof IStruct)) continue;
            ((IStruct)iStructElement).setExcluded(bl);
        }
    }

    public void setExpanded(boolean bl) {
        if (this.setFlags((byte)2, bl)) {
            this.sdModel.update(EnumSet.of(IStructDiffModelImpl.Update.EXPANDED));
            this.fireEvent(DiffModelEvent.Type.EXPANDED_CHANGED, this);
        }
    }

    @Override
    public void setExpandedImpl(boolean bl) {
        this.setFlags((byte)2, bl);
    }

    private synchronized boolean setFlags(byte by, boolean bl) {
        byte by2 = this.flags;
        this.flags = BitUtil.setBits((byte)this.flags, (byte)by, (boolean)bl);
        return by2 != this.flags;
    }

    public void setSelected(boolean bl) {
        this.setFlags((byte)4, bl);
    }

    public void setSelected(boolean bl, boolean bl2) {
        this.sdModel.select(this, bl, bl2, true);
        this.sdModel.setOldSelected(this);
        this.setFlags((byte)4, bl);
    }

    @Override
    public void setSelected(boolean bl, boolean bl2, boolean bl3) {
        this.sdModel.select(this, bl, bl2, bl3);
        this.setFlags((byte)4, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        if (!this.hasChildren()) {
            return;
        }
        Comparator comparator = this.sdModel.getSorter();
        DiffNode diffNode = this;
        synchronized (diffNode) {
            if (comparator != null) {
                Collections.sort(this.children, comparator);
            }
        }
        this.sdModel.update(EnumSet.of(IStructDiffModelImpl.Update.FILTERED));
    }

    public SyncOpInfo syncElements(Role role, Role role2, Set<IDiffNode.SyncAction> set, ISyncProgressMonitor iSyncProgressMonitor, IExceptionHandler iExceptionHandler) throws IOException {
        if (iSyncProgressMonitor.isCanceled()) {
            return null;
        }
        IStructElement iStructElement = this.getElement(role);
        boolean bl = set.contains(IDiffNode.SyncAction.DRY_RUN);
        SyncOpInfo syncOpInfo = null;
        if (!StructDiffModel.isNullElement((Object)iStructElement)) {
            LinkedHashMap<IStructElement, DiffNode> linkedHashMap = new LinkedHashMap<IStructElement, DiffNode>();
            linkedHashMap.put(iStructElement, this);
            DiffNode diffNode = this.getParent();
            IStructElement iStructElement2 = diffNode.getElement(role2);
            while (StructDiffModel.isNullElement((Object)iStructElement2)) {
                linkedHashMap.put(diffNode.getElement(role), diffNode);
                diffNode = diffNode.getParent();
                iStructElement2 = diffNode.getElement(role2);
            }
            IDiffNode iDiffNode = null;
            ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
            int n = arrayList.size() - 1;
            while (n >= 0) {
                Map.Entry entry = (Map.Entry)arrayList.get(n);
                iStructElement = (IStructElement)entry.getKey();
                diffNode = (IDiffNode)entry.getValue();
                if (LOG.isInfoEnabled()) {
                    LOG.info("srcRole=" + role + "  & srcElement=" + iStructElement + "     belongs to node=" + diffNode + "   this node:" + this);
                }
                if (bl) {
                    syncOpInfo = new SyncOpInfo((IDiffNode)diffNode, SyncOpInfo.Type.ADD, role, role2, syncOpInfo);
                } else {
                    IDiffNode iDiffNode2 = diffNode.getParent();
                    IEditableStruct iEditableStruct = (IEditableStruct)iDiffNode2.getElement(role2);
                    if (iDiffNode == null) {
                        iDiffNode = iDiffNode2;
                    }
                    boolean bl2 = n == 0;
                    boolean bl3 = bl2 && set.contains(IDiffNode.SyncAction.MOVE);
                    boolean bl4 = bl2;
                    boolean bl5 = this.isAdded() || this.isDeleted();
                    IStructElement iStructElement3 = iEditableStruct.addChild(iStructElement, bl5, bl4, bl3, iSyncProgressMonitor, iExceptionHandler);
                    if (iStructElement3 != null) {
                        diffNode.setElement(role2, iStructElement3);
                    }
                    if (bl3) {
                        diffNode.setElement(role, null);
                    }
                }
                --n;
            }
            if (iDiffNode != null) {
                if (set.contains(IDiffNode.SyncAction.RECOMPARE)) {
                    HashSet<IDiffNode> hashSet = new HashSet<IDiffNode>();
                    hashSet.add(iDiffNode);
                    this.sdModel.recompare(hashSet, false);
                } else {
                    syncOpInfo = new SyncOpInfo(iDiffNode, SyncOpInfo.Type.ADD, role, role2);
                }
            }
        } else if (set.contains(IDiffNode.SyncAction.DELETE)) {
            if (bl) {
                syncOpInfo = new SyncOpInfo((IDiffNode)this, SyncOpInfo.Type.DELETE, null, role2);
            } else {
                IEditableStruct iEditableStruct = (IEditableStruct)this.getParent().getElement(role2);
                iEditableStruct.deleteChild(this.getElement(role2), true, iSyncProgressMonitor);
            }
        }
        return syncOpInfo;
    }

    public String toString() {
        if (this.isSame()) {
            return this.toStringElements();
        }
        return String.valueOf(this.toStringElements()) + ": " + super.toString();
    }

    private String toStringElements() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" {");
        String string = ",";
        Set set = Relation.roles((boolean)this.isThreeWay());
        for (Role role : set) {
            IStructElement iStructElement = this.getElement(role);
            if (StructDiffModel.isNullElement((Object)iStructElement)) continue;
            stringBuilder.append(' ');
            stringBuilder.append(role);
            stringBuilder.append('=');
            stringBuilder.append(iStructElement);
            stringBuilder.append(string);
        }
        int n = stringBuilder.lastIndexOf(string);
        if (n > 0) {
            stringBuilder.setLength(n);
            stringBuilder.append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void update(IStructElement iStructElement, boolean bl) {
        if (iStructElement == null) {
            this.update((Set<IStructElement>)null, bl);
            return;
        }
        HashSet<IStructElement> hashSet = null;
        if (iStructElement != null) {
            hashSet = new HashSet<IStructElement>(1);
            hashSet.add(iStructElement);
        }
        this.update(hashSet, bl);
    }

    public void update(Set<IStructElement> set, boolean bl) {
        Runnable[] runnableArray = new Runnable[1];
        try {
            if (this.areFlagsSet((byte)8) || bl) {
                this.update(set, runnableArray);
                return;
            }
            if (set == null || set.isEmpty()) {
                this.updates = null;
            } else {
                if (this.updates == null) {
                    this.updates = new HashSet<IStructElement>(set.size());
                }
                this.updates.addAll(set);
            }
        }
        finally {
            if (runnableArray[0] != null) {
                runnableArray[0].run();
            }
        }
    }

    private boolean update(Set<IStructElement> set, Runnable[] runnableArray) {
        this.removePass(Pass.COMPARE);
        this.updates = null;
        if (set != null && !set.isEmpty() && this.updateChanges(set)) {
            return false;
        }
        if (runnableArray != null) {
            runnableArray[0] = this.disposeChildren(true);
        } else {
            this.disposeChildren(false);
        }
        RoleArray.clearAll(this.compars, false);
        this.scan(false, true);
        this.fireEvent(DiffModelEvent.Type.DIFF_INFO_CHANGED, this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateChange(IStructElement iStructElement) {
        assert (iStructElement != null && !StructDiffModel.isNullElement((Object)iStructElement));
        IStructElement[][] iStructElementArrayArray = new IStructElement[Role.count()][];
        if (!this.hasChildren()) {
            return false;
        }
        IDiffNode iDiffNode = this.findNode(iStructElement);
        if (iDiffNode == null) {
            return false;
        }
        DiffNode diffNode = (DiffNode)iDiffNode;
        Set set = this.sdModel.deltaDoc().roles();
        for (Role role : set) {
            IStructElement iStructElement2 = this.getElement(role);
            if (DiffModel.isNullElement((Object)iStructElement2) || !(iStructElement2 instanceof IStruct)) continue;
            try {
                iStructElementArrayArray[role.toInt()] = ((IStruct)iStructElement2).getChildren(null);
            }
            catch (IOException iOException) {
                LOG.error(null, (Throwable)iOException);
                return false;
            }
        }
        boolean bl = true;
        DiffNode diffNode2 = diffNode;
        synchronized (diffNode2) {
            diffNode.disposeChildren(false);
            RoleArray.clearAll(this.compars, false);
            int n = 0;
            while (n < iStructElementArrayArray.length) {
                Object[] objectArray = iStructElementArrayArray[n];
                if (objectArray != null) {
                    int n2;
                    Role role = Role.fromInt((int)n);
                    Object object = diffNode.getElement(role);
                    if (DiffModel.isNullElement((Object)object)) {
                        object = iStructElement;
                    }
                    if (-1 == (n2 = ArrayUtil.indexOf((Object[])objectArray, (Object)object))) {
                        object = null;
                    } else {
                        object = objectArray[n2];
                        bl = false;
                    }
                    diffNode.setElement(role, (IStructElement)object);
                }
                ++n;
            }
            if (!bl) {
                diffNode.scan(false, true);
                diffNode.fireEvent(DiffModelEvent.Type.DIFF_INFO_CHANGED, diffNode);
            }
        }
        if (bl) {
            diffNode.scan(false, true);
            diffNode.dispose(false);
            this.fireEvent(DiffModelEvent.Type.CHILDREN_CHANGED, this);
        }
        return true;
    }

    private boolean updateChanges(Set<IStructElement> set) {
        for (IStructElement iStructElement : set) {
            if (StructDiffModel.isNullElement((Object)iStructElement) || this.updateChange(iStructElement)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IDiffNode> updateResult(ResourceDelta resourceDelta) {
        HashSet<IDiffNode> hashSet = new HashSet<IDiffNode>();
        if (this.isOverallKind((com.deltawalker.script.Delta)resourceDelta)) {
            hashSet.add(this);
        }
        this.setKinds(resourceDelta.getKinds());
        this.setFlags((byte)16, resourceDelta.hasTrueConflicts);
        DiffNode diffNode = this;
        synchronized (diffNode) {
            this.details = new DeltaNodeDetail[this.detailCount()];
            for (Map.Entry relation2 : resourceDelta.details.entrySet()) {
                int enumSet = ((Relation)relation2.getKey()).toInt();
                this.details[enumSet] = (DeltaNodeDetail)relation2.getValue();
            }
        }
        boolean bl = this.isThreeWay();
        Relation relation = Relation.REF_ONE;
        Relation relation3 = bl ? Relation.REF_TWO : null;
        EnumSet<Delta.Kind> enumSet = EnumSet.noneOf(Delta.Kind.class);
        EnumSet<Delta.Kind> enumSet2 = EnumSet.noneOf(Delta.Kind.class);
        DiffNode diffNode2 = this;
        while (diffNode2 != null) {
            DiffNode diffNode3 = diffNode2;
            synchronized (diffNode3) {
                if (diffNode2.model() == null) {
                    return hashSet;
                }
                Delta.Kind kind = diffNode2.getChildren();
                if (((IDiffNode[])kind).length == 0) {
                } else {
                    enumSet.clear();
                    if (bl) {
                        enumSet2.clear();
                    }
                    Delta.Kind kind2 = kind;
                    int kind3 = ((IDiffNode[])kind2).length;
                    int n = 0;
                    while (n < kind3) {
                        IDiffNode iDiffNode = kind2[n];
                        Delta delta = (Delta)iDiffNode;
                        if (!iDiffNode.isExcluded()) {
                            enumSet.add(delta.getKind(relation));
                            if (bl) {
                                enumSet2.add(delta.getKind(relation3));
                            }
                        }
                        ++n;
                    }
                    boolean iDiffNode = false;
                    if (enumSet.contains(Delta.Kind.SAME)) {
                        enumSet.remove(Delta.Kind.SAME);
                        iDiffNode = true;
                    }
                    Delta n2 = diffNode2;
                    if (enumSet.size() > 1) {
                        n2.setKind(relation, Delta.Kind.CHANGED);
                        hashSet.add(diffNode2);
                    } else if (enumSet.size() == 1) {
                        Delta.Kind kind4 = iDiffNode ? Delta.Kind.CHANGED : (Delta.Kind)enumSet.iterator().next();
                        n2.setKind(relation, kind4);
                        hashSet.add(diffNode2);
                    } else if (enumSet.size() == 0 && !n2.isSame(relation)) {
                        n2.setKind(relation, Delta.Kind.SAME);
                        hashSet.add(diffNode2);
                    }
                    if (bl) {
                        kind3 = 0;
                        if (enumSet2.contains(Delta.Kind.SAME)) {
                            enumSet2.remove(Delta.Kind.SAME);
                            kind3 = 1;
                        }
                        if (enumSet2.size() > 1) {
                            n2.setKind(relation3, Delta.Kind.CHANGED);
                            hashSet.add(diffNode2);
                        } else if (enumSet2.size() == 1) {
                            kind2 = kind3 != 0 ? Delta.Kind.CHANGED : (Delta.Kind)enumSet2.iterator().next();
                            n2.setKind(relation3, kind2);
                            hashSet.add(diffNode2);
                        } else if (enumSet2.size() == 0 && !n2.isSame(relation3)) {
                            n2.setKind(relation3, Delta.Kind.SAME);
                            hashSet.add(diffNode2);
                        }
                    }
                }
            }
            diffNode2 = diffNode2.getParent();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitScanAndCompare() {
        DiffNode diffNode = this;
        synchronized (diffNode) {
            boolean bl = false;
            try {
                while (true) {
                    if (this.containsPass(Pass.SCAN)) {
                        if (this.containsPass(Pass.COMPARE)) return;
                    }
                    if (this.sdModel != null) {
                        DiffNodeWorker diffNodeWorker = this.sdModel.getWorker();
                        if (diffNodeWorker == null) return;
                        if (!diffNodeWorker.isJobDone()) {
                            try {
                                this.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                bl = true;
                            }
                            continue;
                        }
                    }
                    break;
                }
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    protected static enum Pass {
        COMPARE(64),
        SCAN(-128);

        private final byte flag;

        private Pass(byte by) {
            this.flag = by;
        }
    }

    static enum SearchBy {
        NAME,
        URI;

    }
}

