/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.Field;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.internal.console.ConsoleMessages;

public class PatternMatchListenerExtension
implements IPluginContribution {
    private IConfigurationElement fConfig;
    private Expression fEnablementExpression;
    private String fPattern;
    private String fQualifier;
    private int fFlags = -1;

    public PatternMatchListenerExtension(IConfigurationElement iConfigurationElement) {
        this.fConfig = iConfigurationElement;
    }

    public int parseFlags(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        try {
            string = string.replaceAll("Pattern.", "");
            String[] stringArray = string.split("\\s\\|\\s");
            Class<?> clazz = Class.forName("java.util.regex.Pattern");
            int n2 = 0;
            while (n2 < stringArray.length) {
                Field field = clazz.getDeclaredField(stringArray[n2]);
                n |= field.getInt(null);
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ConsolePlugin.log(classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            ConsolePlugin.log(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ConsolePlugin.log(illegalAccessException);
        }
        return n;
    }

    public boolean isEnabledFor(IConsole iConsole) throws CoreException {
        EvaluationContext evaluationContext = new EvaluationContext(null, (Object)iConsole);
        EvaluationResult evaluationResult = this.getEnablementExpression().evaluate((IEvaluationContext)evaluationContext);
        return evaluationResult == EvaluationResult.TRUE;
    }

    public IPatternMatchListenerDelegate createDelegate() throws CoreException {
        return (IPatternMatchListenerDelegate)this.fConfig.createExecutableExtension("class");
    }

    public Expression getEnablementExpression() throws CoreException {
        if (this.fEnablementExpression == null) {
            Object object;
            IConfigurationElement[] iConfigurationElementArray = this.fConfig.getChildren("enablement");
            if (iConfigurationElementArray.length == 0) {
                object = MessageFormat.format((String)("{0} " + this.getLocalId() + " {1} " + this.getPluginId() + " {2}"), (Object[])new String[]{ConsoleMessages.PatternMatchListenerExtension_3, ConsoleMessages.PatternMatchListenerExtension_4, ConsoleMessages.PatternMatchListenerExtension_5});
                ConsolePlugin.log((IStatus)new Status(2, ConsolePlugin.getUniqueIdentifier(), 0, (String)object, null));
            }
            IConfigurationElement iConfigurationElement = object = iConfigurationElementArray.length > 0 ? iConfigurationElementArray[0] : null;
            if (object != null) {
                this.fEnablementExpression = ExpressionConverter.getDefault().perform(object);
            }
        }
        return this.fEnablementExpression;
    }

    public String getPattern() {
        if (this.fPattern == null) {
            this.fPattern = this.fConfig.getAttribute("regex");
            try {
                this.fPattern = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fPattern, false);
            }
            catch (CoreException coreException) {
                ConsolePlugin.log(coreException);
            }
        }
        return this.fPattern;
    }

    public int getCompilerFlags() {
        if (this.fFlags < 0) {
            String string = this.fConfig.getAttribute("flags");
            this.fFlags = this.parseFlags(string);
        }
        return this.fFlags;
    }

    public String getLocalId() {
        return this.fConfig.getAttribute("id");
    }

    public String getPluginId() {
        return this.fConfig.getContributor().getName();
    }

    public String getQuickPattern() {
        if (this.fQualifier == null) {
            this.fQualifier = this.fConfig.getAttribute("qualifier");
            try {
                if (this.fQualifier != null) {
                    this.fQualifier = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fQualifier, false);
                }
            }
            catch (CoreException coreException) {
                ConsolePlugin.log(coreException);
            }
        }
        return this.fQualifier;
    }
}

