/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;

public class OpenConsoleAction
extends Action
implements IMenuCreator {
    private ConsoleFactoryExtension[] fFactoryExtensions = ((ConsoleManager)ConsolePlugin.getDefault().getConsoleManager()).getConsoleFactoryExtensions();
    private Menu fMenu;

    public OpenConsoleAction() {
        this.setText(ConsoleMessages.OpenConsoleAction_0);
        this.setToolTipText(ConsoleMessages.OpenConsoleAction_1);
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_ELCL_NEW_CON"));
        this.setMenuCreator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IConsoleHelpContextIds.CONSOLE_OPEN_CONSOLE_ACTION);
    }

    public void dispose() {
        this.fFactoryExtensions = null;
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar toolBar = toolItem.getParent();
            Menu menu = this.getMenu((Control)toolBar);
            Rectangle rectangle = toolItem.getBounds();
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            menu.setLocation(toolBar.toDisplay(point));
            menu.setVisible(true);
        }
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        int n = 1;
        int n2 = 0;
        while (n2 < this.fFactoryExtensions.length) {
            ConsoleFactoryExtension consoleFactoryExtension = this.fFactoryExtensions[n2];
            if (!WorkbenchActivityHelper.filterItem((Object)consoleFactoryExtension) && consoleFactoryExtension.isEnabled()) {
                String string = consoleFactoryExtension.getLabel();
                ImageDescriptor imageDescriptor = consoleFactoryExtension.getImageDescriptor();
                this.addActionToMenu(this.fMenu, new ConsoleFactoryAction(string, imageDescriptor, consoleFactoryExtension), n);
                ++n;
            }
            ++n2;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu menu, Action action, int n) {
        StringBuffer stringBuffer;
        if (n < 10) {
            stringBuffer = new StringBuffer();
            stringBuffer.append('&');
            stringBuffer.append(n);
            stringBuffer.append(' ');
            stringBuffer.append(action.getText());
            action.setText(stringBuffer.toString());
        }
        stringBuffer = new ActionContributionItem((IAction)action);
        stringBuffer.fill(menu, -1);
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    private class ConsoleFactoryAction
    extends Action {
        private ConsoleFactoryExtension fConfig;
        private IConsoleFactory fFactory;

        public ConsoleFactoryAction(String string, ImageDescriptor imageDescriptor, ConsoleFactoryExtension consoleFactoryExtension) {
            this.setText(string);
            if (imageDescriptor != null) {
                this.setImageDescriptor(imageDescriptor);
            }
            this.fConfig = consoleFactoryExtension;
        }

        public void run() {
            try {
                if (this.fFactory == null) {
                    this.fFactory = this.fConfig.createFactory();
                }
                this.fFactory.openConsole();
            }
            catch (CoreException coreException) {
                ConsolePlugin.log(coreException);
            }
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

