/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class IOConsoleViewer
extends TextConsoleViewer {
    private boolean fAutoScroll = true;
    private IDocumentListener fDocumentListener;

    public IOConsoleViewer(Composite composite, TextConsole textConsole) {
        super(composite, textConsole);
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void setAutoScroll(boolean bl) {
        this.fAutoScroll = bl;
    }

    protected void handleVerifyEvent(VerifyEvent verifyEvent) {
        block11: {
            IDocument iDocument = this.getDocument();
            String[] stringArray = iDocument.getLegalLineDelimiters();
            String string = verifyEvent.text;
            try {
                int n;
                IConsoleDocumentPartitioner iConsoleDocumentPartitioner = (IConsoleDocumentPartitioner)iDocument.getDocumentPartitioner();
                if (!iConsoleDocumentPartitioner.isReadOnly(verifyEvent.start)) {
                    n = 0;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (verifyEvent.text.equals(stringArray[n2])) {
                            n = 1;
                            break;
                        }
                        ++n2;
                    }
                    if (n == 0) {
                        super.handleVerifyEvent(verifyEvent);
                        return;
                    }
                }
                if (verifyEvent.start == (n = iDocument.getLength())) {
                    super.handleVerifyEvent(verifyEvent);
                    break block11;
                }
                try {
                    iDocument.replace(n, 0, string);
                }
                catch (BadLocationException badLocationException) {}
                verifyEvent.doit = false;
            }
            finally {
                StyledText styledText = (StyledText)verifyEvent.widget;
                styledText.setCaretOffset(styledText.getCharCount());
            }
        }
    }

    public void setReadOnly() {
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                StyledText styledText = IOConsoleViewer.this.getTextWidget();
                if (styledText != null && !styledText.isDisposed()) {
                    styledText.setEditable(false);
                }
            }
        });
    }

    public boolean isReadOnly() {
        return !this.getTextWidget().getEditable();
    }

    public void setDocument(IDocument iDocument) {
        IDocument iDocument2 = this.getDocument();
        super.setDocument(iDocument);
        if (iDocument2 != null) {
            iDocument2.removeDocumentListener(this.getDocumentListener());
        }
        if (iDocument != null) {
            iDocument.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocumentListener getDocumentListener() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    if (IOConsoleViewer.this.fAutoScroll) {
                        IOConsoleViewer.this.revealEndOfDocument();
                    }
                }
            };
        }
        return this.fDocumentListener;
    }
}

