/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class IOConsolePartitioner
implements IConsoleDocumentPartitioner,
IDocumentPartitionerExtension {
    private PendingPartition consoleClosedPartition;
    private IDocument document;
    private ArrayList partitions;
    private ArrayList pendingPartitions;
    private ArrayList updatePartitions;
    private IOConsolePartition lastPartition;
    private QueueProcessingJob queueJob;
    private IOConsoleInputStream inputStream;
    private boolean updateInProgress;
    private ArrayList inputPartitions;
    private int firstOffset;
    private String[] lld;
    private int highWaterMark = -1;
    private int lowWaterMark = -1;
    private boolean connected = false;
    private IOConsole console;
    private TrimJob trimJob = new TrimJob();
    private Object overflowLock = new Object();
    private int fBuffer;

    public IOConsolePartitioner(IOConsoleInputStream iOConsoleInputStream, IOConsole iOConsole) {
        this.inputStream = iOConsoleInputStream;
        this.console = iOConsole;
        this.trimJob.setRule(iOConsole.getSchedulingRule());
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void connect(IDocument iDocument) {
        this.document = iDocument;
        this.document.setDocumentPartitioner((IDocumentPartitioner)this);
        this.lld = this.document.getLegalLineDelimiters();
        this.partitions = new ArrayList();
        this.pendingPartitions = new ArrayList();
        this.inputPartitions = new ArrayList();
        this.queueJob = new QueueProcessingJob();
        this.queueJob.setSystem(true);
        this.queueJob.setPriority(10);
        this.queueJob.setRule(this.console.getSchedulingRule());
        this.connected = true;
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setWaterMarks(int n, int n2) {
        this.lowWaterMark = n;
        this.highWaterMark = n2;
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IOConsolePartitioner.this.checkBufferSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamsClosed() {
        this.consoleClosedPartition = new PendingPartition(null, null);
        ArrayList arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            this.pendingPartitions.add(this.consoleClosedPartition);
        }
        this.queueJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.document = null;
            this.partitions.clear();
            this.connected = false;
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public boolean documentChanged(DocumentEvent documentEvent) {
        return this.documentChanged2(documentEvent) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{IOConsolePartition.OUTPUT_PARTITION_TYPE, IOConsolePartition.INPUT_PARTITION_TYPE};
    }

    public String getContentType(int n) {
        return this.getPartition(n).getType();
    }

    /*
     * Unable to fully structure code
     */
    public ITypedRegion[] computePartitioning(int var1_1, int var2_2) {
        var3_3 = var1_1 + var2_2;
        var4_4 = 0;
        var5_5 = this.partitions.size() - 1;
        var6_6 = 0;
        var7_7 = null;
        if (var4_4 != var5_5) ** GOTO lbl23
        return new IOConsolePartition[]{(IOConsolePartition)this.partitions.get(0)};
lbl-1000:
        // 1 sources

        {
            var6_6 = (var4_4 + var5_5) / 2;
            var7_7 = (IOConsolePartition)this.partitions.get(var6_6);
            if (var3_3 < var7_7.getOffset()) {
                if (var4_4 == var6_6) {
                    var5_5 = var4_4;
                    continue;
                }
                var5_5 = var6_6 - 1;
                continue;
            }
            if (var1_1 > var7_7.getOffset() + var7_7.getLength() - 1) {
                if (var5_5 == var6_6) {
                    var4_4 = var5_5;
                    continue;
                }
                var4_4 = var6_6 + 1;
                continue;
            }
            var4_4 = var5_5 = var6_6;
lbl23:
            // 6 sources

            ** while (var4_4 < var5_5)
        }
lbl24:
        // 1 sources

        var8_8 = new ArrayList<IOConsolePartition>();
        var9_9 = var4_4 - 1;
        if (var9_9 >= 0) {
            var7_7 = (IOConsolePartition)this.partitions.get(var9_9);
            while (var9_9 >= 0 && var7_7.getOffset() + var7_7.getLength() > var1_1) {
                if (--var9_9 < 0) continue;
                var7_7 = (IOConsolePartition)this.partitions.get(var9_9);
            }
        }
        var7_7 = (IOConsolePartition)this.partitions.get(++var9_9);
        while (var9_9 < this.partitions.size() && var7_7.getOffset() < var3_3) {
            var8_8.add(var7_7);
            if (++var9_9 >= this.partitions.size()) continue;
            var7_7 = (IOConsolePartition)this.partitions.get(var9_9);
        }
        return var8_8.toArray(new IOConsolePartition[var8_8.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITypedRegion getPartition(int n) {
        int n2 = 0;
        while (n2 < this.partitions.size()) {
            ITypedRegion iTypedRegion = (ITypedRegion)this.partitions.get(n2);
            int n3 = iTypedRegion.getOffset();
            int n4 = n3 + iTypedRegion.getLength();
            if (n >= n3 && n < n4) {
                return iTypedRegion;
            }
            ++n2;
        }
        if (this.lastPartition == null) {
            ArrayList arrayList = this.partitions;
            synchronized (arrayList) {
                this.lastPartition = new IOConsolePartition(this.inputStream, "");
                this.lastPartition.setOffset(n);
                this.partitions.add(this.lastPartition);
                this.inputPartitions.add(this.lastPartition);
            }
        }
        return this.lastPartition;
    }

    private void checkBufferSize() {
        int n;
        if (this.document != null && this.highWaterMark > 0 && (n = this.document.getLength()) > this.highWaterMark && this.trimJob.getState() == 0) {
            this.trimJob.setOffset(n - this.lowWaterMark);
            this.trimJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.trimJob.setOffset(-1);
            this.trimJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion documentChanged2(DocumentEvent documentEvent) {
        int n;
        IOConsolePartition iOConsolePartition;
        if (this.document == null) {
            return null;
        }
        if (this.document.getLength() == 0) {
            if (this.lastPartition != null && this.lastPartition.getType().equals(IOConsolePartition.INPUT_PARTITION_TYPE)) {
                ArrayList arrayList = this.partitions;
                synchronized (arrayList) {
                    this.partitions.remove(this.lastPartition);
                    this.inputPartitions.remove(this.lastPartition);
                }
            }
            this.lastPartition = null;
            return new Region(0, 0);
        }
        if (this.updateInProgress) {
            ArrayList arrayList = this.partitions;
            synchronized (arrayList) {
                if (this.updatePartitions != null) {
                    for (PendingPartition pendingPartition : this.updatePartitions) {
                        if (pendingPartition == this.consoleClosedPartition) continue;
                        int n2 = pendingPartition.text.length();
                        if (this.lastPartition != null && this.lastPartition.getStream() == pendingPartition.stream) {
                            int n3 = this.lastPartition.getLength();
                            this.lastPartition.setLength(n3 + n2);
                        } else {
                            IOConsolePartition iOConsolePartition2 = new IOConsolePartition(pendingPartition.stream, n2);
                            iOConsolePartition2.setOffset(this.firstOffset);
                            this.lastPartition = iOConsolePartition2;
                            this.partitions.add(iOConsolePartition2);
                        }
                        this.firstOffset += n2;
                    }
                }
            }
        }
        int n4 = documentEvent.getLength();
        if (n4 > 0 && (iOConsolePartition = (IOConsolePartition)this.getPartition(n = documentEvent.fOffset)) == this.lastPartition) {
            iOConsolePartition.delete(documentEvent.fOffset - iOConsolePartition.getOffset(), n4);
        }
        ArrayList arrayList = this.partitions;
        synchronized (arrayList) {
            Object object;
            if (this.lastPartition == null || this.lastPartition.isReadOnly()) {
                this.lastPartition = new IOConsolePartition(this.inputStream, documentEvent.fText);
                this.lastPartition.setOffset(documentEvent.fOffset);
                this.partitions.add(this.lastPartition);
                this.inputPartitions.add(this.lastPartition);
            } else {
                this.lastPartition.insert(documentEvent.fText, documentEvent.fOffset - this.lastPartition.getOffset());
            }
            int n5 = -1;
            String string = this.lastPartition.getString();
            int n6 = 0;
            while (n6 < this.lld.length) {
                object = this.lld[n6];
                int n7 = string.lastIndexOf((String)object);
                if (n7 != -1) {
                    n7 += ((String)object).length();
                }
                if (n7 > n5) {
                    n5 = n7;
                }
                ++n6;
            }
            if (n5 != -1) {
                StringBuffer stringBuffer = new StringBuffer();
                object = this.inputPartitions.iterator();
                while (object.hasNext()) {
                    IOConsolePartition iOConsolePartition3 = (IOConsolePartition)object.next();
                    if (iOConsolePartition3.getOffset() + iOConsolePartition3.getLength() <= documentEvent.fOffset + n5) {
                        if (iOConsolePartition3 == this.lastPartition) {
                            this.lastPartition = null;
                        }
                        stringBuffer.append(iOConsolePartition3.getString());
                        iOConsolePartition3.clearBuffer();
                        iOConsolePartition3.setReadOnly();
                        object.remove();
                        continue;
                    }
                    String string2 = string.substring(0, n5);
                    IOConsolePartition iOConsolePartition4 = new IOConsolePartition(this.inputStream, string2);
                    iOConsolePartition4.setOffset(iOConsolePartition3.getOffset());
                    iOConsolePartition4.setReadOnly();
                    iOConsolePartition4.clearBuffer();
                    int n8 = this.partitions.indexOf(iOConsolePartition3);
                    this.partitions.add(n8, iOConsolePartition4);
                    stringBuffer.append(string2);
                    iOConsolePartition3.delete(0, n5);
                    iOConsolePartition3.setOffset(n5 + iOConsolePartition3.getOffset());
                    n5 = 0;
                }
                if (stringBuffer.length() > 0) {
                    this.inputStream.appendData(stringBuffer.toString());
                }
            }
        }
        return new Region(documentEvent.fOffset, documentEvent.fText.length());
    }

    private void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAppended(IOConsoleOutputStream iOConsoleOutputStream, String string) throws IOException {
        if (this.document == null) {
            throw new IOException("Document is closed");
        }
        ArrayList arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            PendingPartition pendingPartition = this.pendingPartitions.size() > 0 ? this.pendingPartitions.get(this.pendingPartitions.size() - 1) : null;
            if (pendingPartition != null && pendingPartition.stream == iOConsoleOutputStream) {
                pendingPartition.append(string);
            } else {
                this.pendingPartitions.add(new PendingPartition(iOConsoleOutputStream, string));
                if (this.fBuffer > 1000) {
                    this.queueJob.schedule();
                } else {
                    this.queueJob.schedule(50L);
                }
            }
            if (this.fBuffer > 160000) {
                if (Display.getCurrent() == null) {
                    try {
                        this.pendingPartitions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.processQueue();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processQueue() {
        Object object = this.overflowLock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            StringBuffer stringBuffer = null;
            boolean bl = false;
            ArrayList arrayList2 = this.pendingPartitions;
            synchronized (arrayList2) {
                arrayList.addAll(this.pendingPartitions);
                this.pendingPartitions.clear();
                this.fBuffer = 0;
                this.pendingPartitions.notifyAll();
            }
            int n = 0;
            for (PendingPartition pendingPartition : arrayList) {
                if (pendingPartition == this.consoleClosedPartition) continue;
                n += pendingPartition.text.length();
            }
            stringBuffer = new StringBuffer(n);
            for (PendingPartition pendingPartition : arrayList) {
                if (pendingPartition != this.consoleClosedPartition) {
                    stringBuffer.append(pendingPartition.text);
                    continue;
                }
                bl = true;
            }
            if (this.connected) {
                this.setUpdateInProgress(true);
                this.updatePartitions = arrayList;
                this.firstOffset = this.document.getLength();
                try {
                    if (stringBuffer != null) {
                        this.document.replace(this.firstOffset, 0, stringBuffer.toString());
                    }
                }
                catch (BadLocationException badLocationException) {}
                this.updatePartitions = null;
                this.setUpdateInProgress(false);
            }
            if (bl) {
                this.console.partitionerFinished();
            }
            this.checkBufferSize();
        }
    }

    @Override
    public boolean isReadOnly(int n) {
        return ((IOConsolePartition)this.getPartition(n)).isReadOnly();
    }

    @Override
    public StyleRange[] getStyleRanges(int n, int n2) {
        if (!this.connected) {
            return new StyleRange[0];
        }
        IOConsolePartition[] iOConsolePartitionArray = (IOConsolePartition[])this.computePartitioning(n, n2);
        StyleRange[] styleRangeArray = new StyleRange[iOConsolePartitionArray.length];
        int n3 = 0;
        while (n3 < iOConsolePartitionArray.length) {
            int n4 = Math.max(iOConsolePartitionArray[n3].getOffset(), n);
            int n5 = iOConsolePartitionArray[n3].getLength();
            styleRangeArray[n3] = iOConsolePartitionArray[n3].getStyleRange(n4, n5);
            ++n3;
        }
        return styleRangeArray;
    }

    private class PendingPartition {
        StringBuffer text = new StringBuffer(8192);
        IOConsoleOutputStream stream;

        PendingPartition(IOConsoleOutputStream iOConsoleOutputStream, String string) {
            this.stream = iOConsoleOutputStream;
            if (string != null) {
                this.append(string);
            }
        }

        void append(String string) {
            this.text.append(string);
            IOConsolePartitioner iOConsolePartitioner = IOConsolePartitioner.this;
            iOConsolePartitioner.fBuffer = iOConsolePartitioner.fBuffer + string.length();
        }
    }

    private class QueueProcessingJob
    extends UIJob {
        QueueProcessingJob() {
            super("IOConsole Updater");
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            IOConsolePartitioner.this.processQueue();
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            boolean bl = IOConsolePartitioner.this.connected && IOConsolePartitioner.this.pendingPartitions != null && IOConsolePartitioner.this.pendingPartitions.size() > 0;
            return bl;
        }
    }

    private class TrimJob
    extends WorkbenchJob {
        private int truncateOffset;

        TrimJob() {
            super("Trim Job");
            this.setSystem(true);
        }

        public void setOffset(int n) {
            this.truncateOffset = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            IJobManager iJobManager = Job.getJobManager();
            try {
                iJobManager.join((Object)IOConsolePartitioner.this.console, iProgressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            if (IOConsolePartitioner.this.document == null) {
                return Status.OK_STATUS;
            }
            int n = IOConsolePartitioner.this.document.getLength();
            if (this.truncateOffset < n) {
                Object object = IOConsolePartitioner.this.overflowLock;
                synchronized (object) {
                    try {
                        if (this.truncateOffset < 0) {
                            IOConsolePartitioner.this.setUpdateInProgress(true);
                            IOConsolePartitioner.this.document.set("");
                            IOConsolePartitioner.this.setUpdateInProgress(false);
                            IOConsolePartitioner.this.partitions.clear();
                        } else {
                            int n2 = IOConsolePartitioner.this.document.getLineOfOffset(this.truncateOffset);
                            int n3 = IOConsolePartitioner.this.document.getLineOffset(n2);
                            IOConsolePartition iOConsolePartition = (IOConsolePartition)IOConsolePartitioner.this.getPartition(n3);
                            iOConsolePartition.setLength(iOConsolePartition.getOffset() + iOConsolePartition.getLength() - n3);
                            IOConsolePartitioner.this.setUpdateInProgress(true);
                            IOConsolePartitioner.this.document.replace(0, n3, "");
                            IOConsolePartitioner.this.setUpdateInProgress(false);
                            int n4 = IOConsolePartitioner.this.partitions.indexOf(iOConsolePartition);
                            int n5 = 0;
                            while (n5 < n4) {
                                IOConsolePartitioner.this.partitions.remove(0);
                                ++n5;
                            }
                            n5 = 0;
                            for (IOConsolePartition iOConsolePartition2 : IOConsolePartitioner.this.partitions) {
                                iOConsolePartition2.setOffset(n5);
                                n5 += iOConsolePartition2.getLength();
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return Status.OK_STATUS;
        }
    }
}

