/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class IOConsolePartition
implements ITypedRegion {
    public static final String OUTPUT_PARTITION_TYPE = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".io_console_output_partition_type";
    public static final String INPUT_PARTITION_TYPE = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".io_console_input_partition_type";
    private StringBuffer buffer;
    private String type;
    private int offset;
    private boolean readOnly;
    private IOConsoleOutputStream outputStream;
    private IOConsoleInputStream inputStream;
    private int length;

    public IOConsolePartition(IOConsoleOutputStream iOConsoleOutputStream, int n) {
        this.outputStream = iOConsoleOutputStream;
        this.length = n;
        this.type = OUTPUT_PARTITION_TYPE;
        this.readOnly = true;
    }

    public IOConsolePartition(IOConsoleInputStream iOConsoleInputStream, String string) {
        this.inputStream = iOConsoleInputStream;
        this.buffer = new StringBuffer(string);
        this.length = string.length();
        this.type = INPUT_PARTITION_TYPE;
        this.readOnly = false;
    }

    public void insert(String string, int n) {
        this.buffer.insert(n, string);
        this.length += string.length();
    }

    public void delete(int n, int n2) {
        this.buffer.delete(n, n + n2);
        this.length -= n2;
    }

    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public String getString() {
        return this.buffer.toString();
    }

    public StyleRange getStyleRange(int n, int n2) {
        return new StyleRange(n, n2, this.getColor(), null, this.getFontStyle());
    }

    private int getFontStyle() {
        if (this.type.equals(INPUT_PARTITION_TYPE)) {
            return this.inputStream.getFontStyle();
        }
        return this.outputStream.getFontStyle();
    }

    public Color getColor() {
        if (this.type.equals(INPUT_PARTITION_TYPE)) {
            return this.inputStream.getColor();
        }
        return this.outputStream.getColor();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void clearBuffer() {
        this.buffer.setLength(0);
    }

    IOConsoleOutputStream getStream() {
        return this.outputStream;
    }
}

