/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.eclipse.ui.internal.console.ScrollLockAction;

public class IOConsolePage
extends TextConsolePage {
    private ScrollLockAction fScrollLockAction;
    private boolean fReadOnly;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (string.equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
                IOConsolePage.this.setReadOnly();
            }
        }
    };

    public IOConsolePage(TextConsole textConsole, IConsoleView iConsoleView) {
        super(textConsole, iConsoleView);
        textConsole.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        if (this.fReadOnly) {
            IOConsoleViewer iOConsoleViewer = (IOConsoleViewer)this.getViewer();
            iOConsoleViewer.setReadOnly();
        }
    }

    @Override
    protected TextConsoleViewer createViewer(Composite composite) {
        return new IOConsoleViewer(composite, (TextConsole)this.getConsole());
    }

    public void setAutoScroll(boolean bl) {
        IOConsoleViewer iOConsoleViewer = (IOConsoleViewer)this.getViewer();
        if (iOConsoleViewer != null) {
            iOConsoleViewer.setAutoScroll(bl);
            this.fScrollLockAction.setChecked(!bl);
        }
    }

    public void setReadOnly() {
        this.fReadOnly = true;
        IOConsoleViewer iOConsoleViewer = (IOConsoleViewer)this.getViewer();
        if (iOConsoleViewer != null) {
            iOConsoleViewer.setReadOnly();
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.fScrollLockAction = new ScrollLockAction(this.getConsoleView());
        this.setAutoScroll(!this.fScrollLockAction.isChecked());
    }

    @Override
    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        super.contextMenuAboutToShow(iMenuManager);
        iMenuManager.add((IAction)this.fScrollLockAction);
        IOConsoleViewer iOConsoleViewer = (IOConsoleViewer)this.getViewer();
        if (!iOConsoleViewer.isReadOnly()) {
            iMenuManager.remove(ActionFactory.CUT.getId());
            iMenuManager.remove(ActionFactory.PASTE.getId());
        }
    }

    @Override
    protected void configureToolBar(IToolBarManager iToolBarManager) {
        super.configureToolBar(iToolBarManager);
        iToolBarManager.appendToGroup("outputGroup", (IAction)this.fScrollLockAction);
    }

    @Override
    public void dispose() {
        if (this.fScrollLockAction != null) {
            this.fScrollLockAction.dispose();
            this.fScrollLockAction = null;
        }
        this.getConsole().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }
}

