/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.console.ConsoleDropDownAction;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsoleWorkbenchPart;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.OpenConsoleAction;
import org.eclipse.ui.internal.console.PinConsoleAction;
import org.eclipse.ui.internal.console.ShowConsoleAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ConsoleView
extends PageBookView
implements IConsoleView,
IConsoleListener,
IPropertyChangeListener,
IPartListener2 {
    private boolean fPinned = false;
    private List fStack = new ArrayList();
    private IConsole fActiveConsole = null;
    private Map fConsoleToPart = new HashMap();
    private Map fConsoleToPageParticipants;
    private Map fPartToConsole = new HashMap();
    private boolean fActive = false;
    private IContextActivation fActivatedContext;
    private PinConsoleAction fPinAction = null;
    private ConsoleDropDownAction fDisplayConsoleAction = null;
    private OpenConsoleAction fOpenConsoleAction = null;
    private boolean fScrollLock;

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof IConsole && propertyChangeEvent.getProperty().equals("org.eclipse.jface.text") && object.equals(this.getConsole())) {
            this.updateTitle();
        }
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        super.partClosed(iWorkbenchPart);
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    @Override
    public IConsole getConsole() {
        return this.fActiveConsole;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        IPage iPage;
        if (this.fActiveConsole != null && pageRec.page != this.getDefaultPage() && this.fPinned && this.fConsoleToPart.size() > 1) {
            IConsole iConsole = (IConsole)this.fPartToConsole.get(pageRec.part);
            if (!this.fStack.contains(iConsole)) {
                this.fStack.add(iConsole);
            }
            return;
        }
        IConsole iConsole = (IConsole)this.fPartToConsole.get(pageRec.part);
        if (iConsole != null && iConsole.equals(this.fActiveConsole)) {
            return;
        }
        super.showPageRec(pageRec);
        this.fActiveConsole = iConsole;
        IConsole iConsole2 = null;
        if (!this.fStack.isEmpty()) {
            iConsole2 = (IConsole)this.fStack.get(0);
        }
        if (iConsole2 != null && !iConsole2.equals(this.fActiveConsole) && this.fActive) {
            this.deactivateParticipants(iConsole2);
        }
        if (this.fActiveConsole != null && !this.fActiveConsole.equals(iConsole2)) {
            this.fStack.remove(this.fActiveConsole);
            this.fStack.add(0, this.fActiveConsole);
            this.activateParticipants(this.fActiveConsole);
        }
        this.updateTitle();
        this.updateHelp();
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
        if ((iPage = this.getCurrentPage()) instanceof IOConsolePage) {
            ((IOConsolePage)iPage).setAutoScroll(!this.fScrollLock);
        }
    }

    private void activateParticipants(IConsole iConsole) {
        ListenerList listenerList;
        if (iConsole != null && this.fActive && (listenerList = this.getParticipants(iConsole)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                final IConsolePageParticipant iConsolePageParticipant = (IConsolePageParticipant)objectArray[n];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        iConsolePageParticipant.activated();
                    }

                    public void handleException(Throwable throwable) {
                        ConsolePlugin.log(throwable);
                        listenerList.remove((Object)iConsolePageParticipant);
                    }
                });
                ++n;
            }
        }
    }

    protected List getConsoleStack() {
        return this.fStack;
    }

    protected void updateTitle() {
        IConsole iConsole = this.getConsole();
        if (iConsole == null) {
            this.setContentDescription(ConsoleMessages.ConsoleView_0);
        } else {
            String string = iConsole.getName();
            String string2 = this.getContentDescription();
            if (string != null && !string.equals(string2)) {
                this.setContentDescription(iConsole.getName());
            }
        }
    }

    protected void updateHelp() {
        IConsole iConsole = this.getConsole();
        String string = null;
        if (iConsole instanceof AbstractConsole) {
            AbstractConsole abstractConsole = (AbstractConsole)iConsole;
            string = abstractConsole.getHelpContextId();
        }
        if (string == null) {
            string = IConsoleHelpContextIds.CONSOLE_VIEW;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook().getParent(), string);
    }

    protected void doDestroyPage(IWorkbenchPart iWorkbenchPart, PageBookView.PageRec pageRec) {
        IPage iPage;
        IConsole iConsole = (IConsole)this.fPartToConsole.get(iWorkbenchPart);
        ListenerList listenerList = (ListenerList)this.fConsoleToPageParticipants.remove(iConsole);
        if (listenerList != null) {
            iPage = listenerList.getListeners();
            int n = 0;
            while (n < ((IPage)iPage).length) {
                final IConsolePageParticipant iConsolePageParticipant = (IConsolePageParticipant)iPage[n];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        iConsolePageParticipant.dispose();
                    }

                    public void handleException(Throwable throwable) {
                        ConsolePlugin.log(throwable);
                    }
                });
                ++n;
            }
        }
        iPage = pageRec.page;
        iPage.dispose();
        pageRec.dispose();
        iConsole.removePropertyChangeListener(this);
        this.fPartToConsole.remove(iWorkbenchPart);
        this.fConsoleToPart.remove(iConsole);
        if (this.fPartToConsole.isEmpty()) {
            this.fActiveConsole = null;
        }
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    private ListenerList getParticipants(IConsole iConsole) {
        return (ListenerList)this.fConsoleToPageParticipants.get(iConsole);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart iWorkbenchPart) {
        ConsoleWorkbenchPart consoleWorkbenchPart = (ConsoleWorkbenchPart)iWorkbenchPart;
        final IConsole iConsole = consoleWorkbenchPart.getConsole();
        final IPageBookViewPage iPageBookViewPage = iConsole.createPage(this);
        this.initPage(iPageBookViewPage);
        iPageBookViewPage.createControl((Composite)this.getPageBook());
        iConsole.addPropertyChangeListener(this);
        IConsolePageParticipant[] iConsolePageParticipantArray = ((ConsoleManager)this.getConsoleManager()).getPageParticipants(iConsole);
        final ListenerList listenerList = new ListenerList();
        int n = 0;
        while (n < iConsolePageParticipantArray.length) {
            listenerList.add((Object)iConsolePageParticipantArray[n]);
            ++n;
        }
        this.fConsoleToPageParticipants.put(iConsole, listenerList);
        Object[] objectArray = listenerList.getListeners();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IConsolePageParticipant iConsolePageParticipant = (IConsolePageParticipant)objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    iConsolePageParticipant.init(iPageBookViewPage, iConsole);
                }

                public void handleException(Throwable throwable) {
                    ConsolePlugin.log(throwable);
                    listenerList.remove((Object)iConsolePageParticipant);
                }
            });
            ++n2;
        }
        PageBookView.PageRec pageRec = new PageBookView.PageRec(iWorkbenchPart, (IPage)iPageBookViewPage);
        return pageRec;
    }

    protected boolean isImportant(IWorkbenchPart iWorkbenchPart) {
        return iWorkbenchPart instanceof ConsoleWorkbenchPart;
    }

    public void dispose() {
        IViewSite iViewSite = this.getViewSite();
        if (iViewSite != null) {
            iViewSite.getPage().removePartListener((IPartListener2)this);
        }
        super.dispose();
        ConsoleManager consoleManager = (ConsoleManager)ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.removeConsoleListener(this);
        consoleManager.unregisterConsoleView(this);
    }

    private IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }

    protected IPage createDefaultPage(PageBook pageBook) {
        MessagePage messagePage = new MessagePage();
        messagePage.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)messagePage);
        return messagePage;
    }

    @Override
    public void consolesAdded(final IConsole[] iConsoleArray) {
        if (this.isAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = 0;
                    while (n < iConsoleArray.length) {
                        if (ConsoleView.this.isAvailable()) {
                            IConsole iConsole = iConsoleArray[n];
                            IConsole[] iConsoleArray2 = ConsoleView.this.getConsoleManager().getConsoles();
                            int n2 = 0;
                            while (n2 < iConsoleArray2.length) {
                                IConsole iConsole2 = iConsoleArray2[n2];
                                if (iConsole2.equals(iConsole)) {
                                    ConsoleWorkbenchPart consoleWorkbenchPart = new ConsoleWorkbenchPart(iConsole, ConsoleView.this.getSite());
                                    ConsoleView.this.fConsoleToPart.put(iConsole, consoleWorkbenchPart);
                                    ConsoleView.this.fPartToConsole.put(consoleWorkbenchPart, iConsole);
                                    ConsoleView.this.partActivated(consoleWorkbenchPart);
                                    break;
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                }
            };
            this.asyncExec(runnable);
        }
    }

    @Override
    public void consolesRemoved(final IConsole[] iConsoleArray) {
        if (this.isAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n = 0;
                    while (n < iConsoleArray.length) {
                        if (ConsoleView.this.isAvailable()) {
                            IConsole[] iConsoleArray2;
                            IConsole iConsole = iConsoleArray[n];
                            ConsoleView.this.fStack.remove(iConsole);
                            ConsoleWorkbenchPart consoleWorkbenchPart = (ConsoleWorkbenchPart)ConsoleView.this.fConsoleToPart.get(iConsole);
                            if (consoleWorkbenchPart != null) {
                                ConsoleView.this.partClosed(consoleWorkbenchPart);
                            }
                            if (ConsoleView.this.getConsole() == null && (iConsoleArray2 = ConsoleView.this.getConsoleManager().getConsoles()).length > 0) {
                                ConsoleView.this.display(iConsoleArray2[iConsoleArray2.length - 1]);
                            }
                        }
                        ++n;
                    }
                }
            };
            this.asyncExec(runnable);
        }
    }

    public ConsoleView() {
        this.fConsoleToPageParticipants = new HashMap();
        ConsoleManager consoleManager = (ConsoleManager)ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.registerConsoleView(this);
    }

    protected void createActions() {
        this.fPinAction = new PinConsoleAction(this);
        this.fDisplayConsoleAction = new ConsoleDropDownAction(this);
        ConsoleFactoryExtension[] consoleFactoryExtensionArray = ((ConsoleManager)ConsolePlugin.getDefault().getConsoleManager()).getConsoleFactoryExtensions();
        if (consoleFactoryExtensionArray.length > 0) {
            this.fOpenConsoleAction = new OpenConsoleAction();
        }
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator("launchGroup"));
        iToolBarManager.add((IContributionItem)new Separator("outputGroup"));
        iToolBarManager.add((IContributionItem)new Separator("fixedGroup"));
        iToolBarManager.add((IAction)this.fPinAction);
        iToolBarManager.add((IAction)this.fDisplayConsoleAction);
        if (this.fOpenConsoleAction != null) {
            iToolBarManager.add((IAction)this.fOpenConsoleAction);
            if (iToolBarManager instanceof ToolBarManager) {
                ToolBarManager toolBarManager = (ToolBarManager)iToolBarManager;
                final ToolBar toolBar = toolBarManager.getControl();
                toolBar.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent mouseEvent) {
                        ActionContributionItem actionContributionItem;
                        IAction iAction;
                        ToolItem toolItem = toolBar.getItem(new Point(mouseEvent.x, mouseEvent.y));
                        if (toolItem != null && toolItem.getData() instanceof ActionContributionItem && (iAction = (actionContributionItem = (ActionContributionItem)toolItem.getData()).getAction()) == ConsoleView.this.fOpenConsoleAction) {
                            Event event = new Event();
                            event.widget = toolItem;
                            event.x = mouseEvent.x;
                            event.y = mouseEvent.y;
                            iAction.runWithEvent(event);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void display(IConsole iConsole) {
        if (this.fPinned && this.fActiveConsole != null) {
            return;
        }
        if (iConsole.equals(this.fActiveConsole)) {
            return;
        }
        ConsoleWorkbenchPart consoleWorkbenchPart = (ConsoleWorkbenchPart)this.fConsoleToPart.get(iConsole);
        if (consoleWorkbenchPart != null) {
            this.partActivated(consoleWorkbenchPart);
        }
    }

    @Override
    public void setPinned(boolean bl) {
        this.fPinned = bl;
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    @Override
    public boolean isPinned() {
        return this.fPinned;
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(runnable);
        }
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        this.updateForExistingConsoles();
        this.getViewSite().getActionBars().updateActionBars();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IConsoleHelpContextIds.CONSOLE_VIEW);
        this.getViewSite().getPage().addPartListener((IPartListener2)this);
        this.initPageSwitcher();
    }

    private void initPageSwitcher() {
        new PageSwitcher((IWorkbenchPart)this){

            public void activatePage(Object object) {
                ShowConsoleAction.showConsole((IConsole)object, ConsoleView.this);
            }

            public ImageDescriptor getImageDescriptor(Object object) {
                return ((IConsole)object).getImageDescriptor();
            }

            public String getName(Object object) {
                return ((IConsole)object).getName();
            }

            public Object[] getPages() {
                return ConsoleView.this.getConsoleManager().getConsoles();
            }

            public int getCurrentPageIndex() {
                IConsole iConsole = ConsoleView.this.getConsole();
                IConsole[] iConsoleArray = ConsoleView.this.getConsoleManager().getConsoles();
                int n = 0;
                while (n < iConsoleArray.length) {
                    if (iConsoleArray[n].equals(iConsole)) {
                        return n;
                    }
                    ++n;
                }
                return super.getCurrentPageIndex();
            }
        };
    }

    private void updateForExistingConsoles() {
        IConsoleManager iConsoleManager = this.getConsoleManager();
        IConsole[] iConsoleArray = iConsoleManager.getConsoles();
        this.consolesAdded(iConsoleArray);
        iConsoleManager.addConsoleListener(this);
    }

    @Override
    public void warnOfContentChange(IConsole iConsole) {
        IWorkbenchSiteProgressService iWorkbenchSiteProgressService;
        IWorkbenchPart iWorkbenchPart = (IWorkbenchPart)this.fConsoleToPart.get(iConsole);
        if (iWorkbenchPart != null && (iWorkbenchSiteProgressService = (IWorkbenchSiteProgressService)iWorkbenchPart.getSite().getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            iWorkbenchSiteProgressService.warnOfContentChange();
        }
    }

    public Object getAdapter(Class clazz) {
        ListenerList listenerList;
        IConsole iConsole;
        Object object = super.getAdapter(clazz);
        if (object == null && (iConsole = this.getConsole()) != null && (listenerList = this.getParticipants(iConsole)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                IConsolePageParticipant iConsolePageParticipant = (IConsolePageParticipant)objectArray[n];
                object = iConsolePageParticipant.getAdapter(clazz);
                if (object != null) {
                    return object;
                }
                ++n;
            }
        }
        return object;
    }

    public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        if (this.isThisPart(iWorkbenchPartReference)) {
            this.fActive = true;
            IContextService iContextService = (IContextService)this.getSite().getService(IContextService.class);
            if (iContextService != null) {
                this.fActivatedContext = iContextService.activateContext("org.eclipse.ui.console.ConsoleView");
                this.activateParticipants(this.fActiveConsole);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        if (this.isThisPart(iWorkbenchPartReference)) {
            this.fActive = false;
            IContextService iContextService = (IContextService)this.getSite().getService(IContextService.class);
            if (iContextService != null) {
                iContextService.deactivateContext(this.fActivatedContext);
                this.deactivateParticipants(this.fActiveConsole);
            }
        }
    }

    protected boolean isThisPart(IWorkbenchPartReference iWorkbenchPartReference) {
        if (iWorkbenchPartReference instanceof IViewReference) {
            IViewReference iViewReference = (IViewReference)iWorkbenchPartReference;
            if (this.getViewSite() != null && iViewReference.getId().equals(this.getViewSite().getId())) {
                String string = iViewReference.getSecondaryId();
                String string2 = null;
                if (this.getSite() instanceof IViewSite) {
                    string2 = ((IViewSite)this.getSite()).getSecondaryId();
                }
                if (string2 == null) {
                    return string == null;
                }
                return string2.equals(string);
            }
        }
        return false;
    }

    private void deactivateParticipants(IConsole iConsole) {
        ListenerList listenerList;
        if (iConsole != null && (listenerList = this.getParticipants(iConsole)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                final IConsolePageParticipant iConsolePageParticipant = (IConsolePageParticipant)objectArray[n];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        iConsolePageParticipant.deactivated();
                    }

                    public void handleException(Throwable throwable) {
                        ConsolePlugin.log(throwable);
                        listenerList.remove((Object)iConsolePageParticipant);
                    }
                });
                ++n;
            }
        }
    }

    public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
    }

    @Override
    public void setScrollLock(boolean bl) {
        this.fScrollLock = bl;
        IPage iPage = this.getCurrentPage();
        if (iPage instanceof IOConsolePage) {
            ((IOConsolePage)iPage).setAutoScroll(!bl);
        }
    }

    @Override
    public boolean getScrollLock() {
        return this.fScrollLock;
    }

    @Override
    public void pin(IConsole iConsole) {
        if (iConsole == null) {
            this.setPinned(false);
        } else {
            if (this.isPinned()) {
                this.setPinned(false);
            }
            this.display(iConsole);
            this.setPinned(true);
        }
    }
}

