/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ConsolePatternMatcher
implements IDocumentListener {
    private MatchJob fMatchJob = new MatchJob();
    private ArrayList fPatterns = new ArrayList();
    private TextConsole fConsole;
    private boolean fFinalMatch;
    private boolean fScheduleFinal;

    public ConsolePatternMatcher(TextConsole textConsole) {
        this.fConsole = textConsole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPatternMatchListener(IPatternMatchListener iPatternMatchListener) {
        ArrayList arrayList = this.fPatterns;
        synchronized (arrayList) {
            Object object2;
            for (Object object2 : this.fPatterns) {
                if (((CompiledPatternMatchListener)object2).listener != iPatternMatchListener) continue;
                return;
            }
            if (iPatternMatchListener == null || iPatternMatchListener.getPattern() == null) {
                throw new IllegalArgumentException("Pattern cannot be null");
            }
            Pattern pattern = Pattern.compile(iPatternMatchListener.getPattern(), iPatternMatchListener.getCompilerFlags());
            object2 = iPatternMatchListener.getLineQualifier();
            Pattern pattern2 = null;
            if (object2 != null) {
                pattern2 = Pattern.compile((String)object2, iPatternMatchListener.getCompilerFlags());
            }
            CompiledPatternMatchListener compiledPatternMatchListener = new CompiledPatternMatchListener(pattern, pattern2, iPatternMatchListener);
            this.fPatterns.add(compiledPatternMatchListener);
            iPatternMatchListener.connect(this.fConsole);
            this.fMatchJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePatternMatchListener(IPatternMatchListener iPatternMatchListener) {
        ArrayList arrayList = this.fPatterns;
        synchronized (arrayList) {
            Iterator iterator = this.fPatterns.iterator();
            while (iterator.hasNext()) {
                CompiledPatternMatchListener compiledPatternMatchListener = (CompiledPatternMatchListener)iterator.next();
                if (compiledPatternMatchListener.listener != iPatternMatchListener) continue;
                iterator.remove();
                iPatternMatchListener.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.fMatchJob.cancel();
        ArrayList arrayList = this.fPatterns;
        synchronized (arrayList) {
            for (CompiledPatternMatchListener compiledPatternMatchListener : this.fPatterns) {
                compiledPatternMatchListener.dispose();
            }
            this.fPatterns.clear();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(DocumentEvent documentEvent) {
        if (documentEvent.fLength > 0) {
            ArrayList arrayList = this.fPatterns;
            synchronized (arrayList) {
                if (documentEvent.fDocument.getLength() == 0) {
                    for (CompiledPatternMatchListener compiledPatternMatchListener : this.fPatterns) {
                        compiledPatternMatchListener.end = 0;
                    }
                } else if (documentEvent.fOffset == 0) {
                    for (CompiledPatternMatchListener compiledPatternMatchListener : this.fPatterns) {
                        int n = compiledPatternMatchListener.end = compiledPatternMatchListener.end > documentEvent.fLength ? compiledPatternMatchListener.end - documentEvent.fLength : 0;
                    }
                }
            }
        }
        this.fMatchJob.schedule();
    }

    public void forceFinalMatching() {
        this.fScheduleFinal = true;
        this.fMatchJob.schedule();
    }

    private class CompiledPatternMatchListener {
        Pattern pattern;
        Pattern qualifier;
        IPatternMatchListener listener;
        int end = 0;

        CompiledPatternMatchListener(Pattern pattern, Pattern pattern2, IPatternMatchListener iPatternMatchListener) {
            this.pattern = pattern;
            this.listener = iPatternMatchListener;
            this.qualifier = pattern2;
        }

        public void dispose() {
            this.listener.disconnect();
            this.pattern = null;
            this.qualifier = null;
            this.listener = null;
        }
    }

    private class MatchJob
    extends Job {
        MatchJob() {
            super("Match Job");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            IDocument iDocument = ConsolePatternMatcher.this.fConsole.getDocument();
            String string = null;
            int n = -1;
            if (iDocument != null && !iProgressMonitor.isCanceled()) {
                int n2 = iDocument.getLength();
                int n3 = n2;
                if (n3 > 0) {
                    --n3;
                }
                int n4 = 0;
                int n5 = 0;
                try {
                    n4 = iDocument.getLineOfOffset(n3);
                    n5 = iDocument.getLineOffset(n4);
                }
                catch (BadLocationException badLocationException) {
                    return Status.OK_STATUS;
                }
                Object[] objectArray = null;
                ArrayList arrayList = ConsolePatternMatcher.this.fPatterns;
                synchronized (arrayList) {
                    objectArray = ConsolePatternMatcher.this.fPatterns.toArray();
                }
                int n6 = 0;
                while (n6 < objectArray.length) {
                    if (iProgressMonitor.isCanceled()) break;
                    CompiledPatternMatchListener compiledPatternMatchListener = (CompiledPatternMatchListener)objectArray[n6];
                    int n7 = compiledPatternMatchListener.end;
                    int n8 = n2 - n7;
                    if (n8 > 0) {
                        try {
                            if (n != n7) {
                                string = iDocument.get(n7, n8);
                            }
                            Matcher matcher = compiledPatternMatchListener.pattern.matcher(string);
                            Matcher matcher2 = null;
                            if (compiledPatternMatchListener.qualifier != null) {
                                matcher2 = compiledPatternMatchListener.qualifier.matcher(string);
                            }
                            int n9 = 0;
                            int n10 = -1;
                            int n11 = -1;
                            while (n9 < n8 && !iProgressMonitor.isCanceled()) {
                                int n12;
                                if (matcher2 != null) {
                                    n9 = matcher2.find(n9) ? (n11 == (n12 = iDocument.getLineOfOffset(n7 + matcher2.start())) ? n10 : iDocument.getLineOffset(n12) - n7) : n8;
                                }
                                if (n9 < 0) {
                                    n9 = 0;
                                }
                                if (n9 >= n8) continue;
                                if (matcher.find(n9)) {
                                    n10 = matcher.end();
                                    n11 = iDocument.getLineOfOffset(n7 + n10 - 1);
                                    n12 = matcher.start();
                                    IPatternMatchListener iPatternMatchListener = compiledPatternMatchListener.listener;
                                    if (iPatternMatchListener != null && !iProgressMonitor.isCanceled()) {
                                        iPatternMatchListener.matchFound(new PatternMatchEvent(ConsolePatternMatcher.this.fConsole, n7 + n12, n10 - n12));
                                    }
                                    n9 = n10;
                                    continue;
                                }
                                n9 = n8;
                            }
                            compiledPatternMatchListener.end = n4 == n11 ? n7 + n10 : n5;
                        }
                        catch (BadLocationException badLocationException) {
                            ConsolePlugin.log(badLocationException);
                        }
                    }
                    n = n7;
                    ++n6;
                }
            }
            if (ConsolePatternMatcher.this.fFinalMatch) {
                ConsolePatternMatcher.this.disconnect();
                ConsolePatternMatcher.this.fConsole.matcherFinished();
            } else if (ConsolePatternMatcher.this.fScheduleFinal) {
                ConsolePatternMatcher.this.fFinalMatch = true;
                this.schedule();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return object == ConsolePatternMatcher.this.fConsole;
        }
    }
}

