/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;

public class ConsolePageParticipantExtension
implements IPluginContribution {
    private IConfigurationElement fConfig;
    private Expression fEnablementExpression;

    public ConsolePageParticipantExtension(IConfigurationElement iConfigurationElement) {
        this.fConfig = iConfigurationElement;
    }

    public String getLocalId() {
        return this.fConfig.getAttribute("id");
    }

    public String getPluginId() {
        return this.fConfig.getContributor().getName();
    }

    public boolean isEnabledFor(IConsole iConsole) throws CoreException {
        EvaluationContext evaluationContext = new EvaluationContext(null, (Object)iConsole);
        Expression expression = this.getEnablementExpression();
        if (expression != null) {
            EvaluationResult evaluationResult = expression.evaluate((IEvaluationContext)evaluationContext);
            return evaluationResult == EvaluationResult.TRUE;
        }
        return true;
    }

    public Expression getEnablementExpression() throws CoreException {
        if (this.fEnablementExpression == null) {
            IConfigurationElement iConfigurationElement;
            IConfigurationElement[] iConfigurationElementArray = this.fConfig.getChildren("enablement");
            IConfigurationElement iConfigurationElement2 = iConfigurationElement = iConfigurationElementArray.length > 0 ? iConfigurationElementArray[0] : null;
            if (iConfigurationElement != null) {
                this.fEnablementExpression = ExpressionConverter.getDefault().perform(iConfigurationElement);
            }
        }
        return this.fEnablementExpression;
    }

    public IConsolePageParticipant createDelegate() throws CoreException {
        return (IConsolePageParticipant)this.fConfig.createExecutableExtension("class");
    }
}

