/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePageParticipantExtension;
import org.eclipse.ui.internal.console.ConsoleView;
import org.eclipse.ui.internal.console.PatternMatchListener;
import org.eclipse.ui.internal.console.PatternMatchListenerExtension;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ConsoleManager
implements IConsoleManager {
    private ListenerList fListeners = null;
    private List fConsoles = new ArrayList(10);
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private List fPatternMatchListeners;
    private List fPageParticipants;
    private List fConsoleFactoryExtensions;
    private List fConsoleViews = new ArrayList();
    private boolean fWarnQueued = false;
    private RepaintJob fRepaintJob = new RepaintJob();
    private ShowConsoleViewJob showJob = new ShowConsoleViewJob();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConsoleView(ConsoleView consoleView) {
        List list = this.fConsoleViews;
        synchronized (list) {
            this.fConsoleViews.add(consoleView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConsoleView(ConsoleView consoleView) {
        List list = this.fConsoleViews;
        synchronized (list) {
            this.fConsoleViews.remove(consoleView);
        }
    }

    @Override
    public void addConsoleListener(IConsoleListener iConsoleListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)iConsoleListener);
    }

    @Override
    public void removeConsoleListener(IConsoleListener iConsoleListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iConsoleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsoles(IConsole[] iConsoleArray) {
        ArrayList<IConsole> arrayList = new ArrayList<IConsole>(iConsoleArray.length);
        List list = this.fConsoles;
        synchronized (list) {
            int n = 0;
            while (n < iConsoleArray.length) {
                IConsole iConsole = iConsoleArray[n];
                if (iConsole instanceof TextConsole) {
                    TextConsole textConsole = (TextConsole)iConsole;
                    this.createPatternMatchListeners(textConsole);
                }
                if (!this.fConsoles.contains(iConsole)) {
                    this.fConsoles.add(iConsole);
                    arrayList.add(iConsole);
                }
                ++n;
            }
        }
        if (!arrayList.isEmpty()) {
            this.fireUpdate(arrayList.toArray(new IConsole[arrayList.size()]), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsoles(IConsole[] iConsoleArray) {
        ArrayList<IConsole> arrayList = new ArrayList<IConsole>(iConsoleArray.length);
        List list = this.fConsoles;
        synchronized (list) {
            int n = 0;
            while (n < iConsoleArray.length) {
                IConsole iConsole = iConsoleArray[n];
                if (this.fConsoles.remove(iConsole)) {
                    arrayList.add(iConsole);
                }
                ++n;
            }
        }
        if (!arrayList.isEmpty()) {
            this.fireUpdate(arrayList.toArray(new IConsole[arrayList.size()]), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConsole[] getConsoles() {
        List list = this.fConsoles;
        synchronized (list) {
            return this.fConsoles.toArray(new IConsole[this.fConsoles.size()]);
        }
    }

    private void fireUpdate(IConsole[] iConsoleArray, int n) {
        new ConsoleNotifier().notify(iConsoleArray, n);
    }

    @Override
    public void showConsoleView(IConsole iConsole) {
        this.showJob.setConsole(iConsole);
        this.showJob.schedule(100L);
    }

    private boolean shouldBringToTop(IConsole iConsole, IViewPart iViewPart) {
        IConsoleView iConsoleView;
        boolean bl = true;
        if (iViewPart instanceof IConsoleView && (iConsoleView = (IConsoleView)iViewPart).isPinned()) {
            IConsole iConsole2 = iConsoleView.getConsole();
            bl = iConsole.equals(iConsole2);
        }
        return bl;
    }

    @Override
    public void warnOfContentChange(final IConsole iConsole) {
        if (!this.fWarnQueued) {
            this.fWarnQueued = true;
            UIJob uIJob = new UIJob(ConsolePlugin.getStandardDisplay(), ConsoleMessages.ConsoleManager_consoleContentChangeJob){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    IConsoleView iConsoleView;
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iConsoleView = (IConsoleView)iWorkbenchPage.findView("org.eclipse.ui.console.ConsoleView")) != null) {
                        iConsoleView.warnOfContentChange(iConsole);
                    }
                    ConsoleManager.this.fWarnQueued = false;
                    return Status.OK_STATUS;
                }
            };
            uIJob.setSystem(true);
            uIJob.schedule();
        }
    }

    @Override
    public IPatternMatchListener[] createPatternMatchListeners(IConsole iConsole) {
        Object object;
        Object object2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtensionPoint iExtensionPoint;
        if (this.fPatternMatchListeners == null) {
            this.fPatternMatchListeners = new ArrayList();
            iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consolePatternMatchListeners");
            iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                object2 = iConfigurationElementArray[n];
                object = new PatternMatchListenerExtension((IConfigurationElement)object2);
                this.fPatternMatchListeners.add(object);
                ++n;
            }
        }
        iExtensionPoint = new ArrayList();
        iConfigurationElementArray = this.fPatternMatchListeners.iterator();
        while (iConfigurationElementArray.hasNext()) {
            PatternMatchListenerExtension patternMatchListenerExtension = (PatternMatchListenerExtension)iConfigurationElementArray.next();
            try {
                if (patternMatchListenerExtension.getEnablementExpression() == null) {
                    iConfigurationElementArray.remove();
                    continue;
                }
                if (!(iConsole instanceof TextConsole) || !patternMatchListenerExtension.isEnabledFor(iConsole)) continue;
                object2 = (TextConsole)iConsole;
                object = new PatternMatchListener(patternMatchListenerExtension);
                try {
                    ((TextConsole)object2).addPatternMatchListener((IPatternMatchListener)object);
                    iExtensionPoint.add(object);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    ConsolePlugin.log(patternSyntaxException);
                    iConfigurationElementArray.remove();
                }
            }
            catch (CoreException coreException) {
                ConsolePlugin.log(coreException);
            }
        }
        return iExtensionPoint.toArray(new PatternMatchListener[0]);
    }

    public IConsolePageParticipant[] getPageParticipants(IConsole iConsole) {
        IExtensionPoint iExtensionPoint;
        if (this.fPageParticipants == null) {
            this.fPageParticipants = new ArrayList();
            iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consolePageParticipants");
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                ConsolePageParticipantExtension consolePageParticipantExtension = new ConsolePageParticipantExtension(iConfigurationElement);
                this.fPageParticipants.add(consolePageParticipantExtension);
                ++n;
            }
        }
        iExtensionPoint = new ArrayList();
        for (ConsolePageParticipantExtension consolePageParticipantExtension : this.fPageParticipants) {
            try {
                if (!consolePageParticipantExtension.isEnabledFor(iConsole)) continue;
                iExtensionPoint.add(consolePageParticipantExtension.createDelegate());
            }
            catch (CoreException coreException) {
                ConsolePlugin.log(coreException);
            }
        }
        return iExtensionPoint.toArray(new IConsolePageParticipant[0]);
    }

    public ConsoleFactoryExtension[] getConsoleFactoryExtensions() {
        if (this.fConsoleFactoryExtensions == null) {
            this.fConsoleFactoryExtensions = new ArrayList();
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consoleFactories");
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.fConsoleFactoryExtensions.add(new ConsoleFactoryExtension(iConfigurationElementArray[n]));
                ++n;
            }
        }
        return this.fConsoleFactoryExtensions.toArray(new ConsoleFactoryExtension[0]);
    }

    @Override
    public void refresh(IConsole iConsole) {
        this.fRepaintJob.addConsole(iConsole);
        this.fRepaintJob.schedule(50L);
    }

    class ConsoleNotifier
    implements ISafeRunnable {
        private IConsoleListener fListener;
        private int fType;
        private IConsole[] fChanged;

        ConsoleNotifier() {
        }

        public void handleException(Throwable throwable) {
            Status status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, ConsoleMessages.ConsoleManager_0, throwable);
            ConsolePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.consolesAdded(this.fChanged);
                    break;
                }
                case 2: {
                    this.fListener.consolesRemoved(this.fChanged);
                }
            }
        }

        public void notify(IConsole[] iConsoleArray, int n) {
            if (ConsoleManager.this.fListeners == null) {
                return;
            }
            this.fChanged = iConsoleArray;
            this.fType = n;
            Object[] objectArray = ConsoleManager.this.fListeners.getListeners();
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.fListener = (IConsoleListener)objectArray[n2];
                SafeRunner.run((ISafeRunnable)this);
                ++n2;
            }
            this.fChanged = null;
            this.fListener = null;
        }
    }

    private class RepaintJob
    extends WorkbenchJob {
        private Set list;

        public RepaintJob() {
            super("schedule redraw() of viewers");
            this.list = new HashSet();
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConsole(IConsole iConsole) {
            Set set = this.list;
            synchronized (set) {
                this.list.add(iConsole);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            Set set = this.list;
            synchronized (set) {
                if (this.list.isEmpty()) {
                    return Status.OK_STATUS;
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = 0;
                while (n < iWorkbenchWindowArray.length) {
                    Control control;
                    ConsoleView consoleView;
                    IViewPart iViewPart;
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n];
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.ui.console.ConsoleView")) != null && iViewPart instanceof IConsoleView && this.list.contains((consoleView = (ConsoleView)iViewPart).getConsole()) && !(control = consoleView.getCurrentPage().getControl()).isDisposed()) {
                        control.redraw();
                    }
                    ++n;
                }
                this.list.clear();
            }
            return Status.OK_STATUS;
        }
    }

    private class ShowConsoleViewJob
    extends WorkbenchJob {
        private IConsole console;

        ShowConsoleViewJob() {
            super("Show Console View");
            this.setSystem(true);
            this.setPriority(20);
        }

        void setConsole(IConsole iConsole) {
            this.console = iConsole;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            IWorkbenchPage iWorkbenchPage;
            boolean bl = false;
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null && this.console != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                Object object = ConsoleManager.this.fConsoleViews;
                synchronized (object) {
                    for (ConsoleView consoleView : ConsoleManager.this.fConsoleViews) {
                        boolean bl2;
                        if (!consoleView.getSite().getPage().equals(iWorkbenchPage) || !(bl2 = iWorkbenchPage.isPartVisible((IWorkbenchPart)consoleView))) continue;
                        bl = true;
                        boolean bl3 = ConsoleManager.this.shouldBringToTop(this.console, consoleView);
                        if (bl3) {
                            iWorkbenchPage.bringToTop((IWorkbenchPart)consoleView);
                        }
                        consoleView.display(this.console);
                    }
                }
                if (!bl) {
                    try {
                        object = (IConsoleView)iWorkbenchPage.showView("org.eclipse.ui.console.ConsoleView", null, 3);
                        boolean bl4 = ConsoleManager.this.shouldBringToTop(this.console, (IViewPart)object);
                        if (bl4) {
                            iWorkbenchPage.bringToTop((IWorkbenchPart)object);
                        }
                        object.display(this.console);
                    }
                    catch (PartInitException partInitException) {
                        ConsolePlugin.log(partInitException);
                    }
                }
            }
            this.console = null;
            return Status.OK_STATUS;
        }
    }
}

