/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.net.URL;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleFactory;
import org.osgi.framework.Bundle;

public class ConsoleFactoryExtension
implements IPluginContribution {
    private IConfigurationElement fConfig;
    private Expression fEnablementExpression;
    private String fLabel;
    private ImageDescriptor fImageDescriptor;
    private IConsoleFactory fFactory;

    ConsoleFactoryExtension(IConfigurationElement iConfigurationElement) {
        this.fConfig = iConfigurationElement;
    }

    public String getLocalId() {
        return this.fConfig.getAttribute("id");
    }

    public String getPluginId() {
        return this.fConfig.getContributor().getName();
    }

    public boolean isEnabled() {
        Expression expression;
        block3: {
            try {
                expression = this.getEnablementExpression();
                if (expression != null) break block3;
                return true;
            }
            catch (CoreException coreException) {
                ConsolePlugin.log(coreException);
                return false;
            }
        }
        EvaluationContext evaluationContext = new EvaluationContext(null, (Object)this);
        EvaluationResult evaluationResult = expression.evaluate((IEvaluationContext)evaluationContext);
        return evaluationResult != EvaluationResult.FALSE;
    }

    public Expression getEnablementExpression() throws CoreException {
        if (this.fEnablementExpression == null) {
            IConfigurationElement iConfigurationElement;
            IConfigurationElement[] iConfigurationElementArray = this.fConfig.getChildren("enablement");
            IConfigurationElement iConfigurationElement2 = iConfigurationElement = iConfigurationElementArray.length > 0 ? iConfigurationElementArray[0] : null;
            if (iConfigurationElement != null) {
                this.fEnablementExpression = ExpressionConverter.getDefault().perform(iConfigurationElement);
            }
        }
        return this.fEnablementExpression;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = this.fConfig.getAttribute("label");
        }
        return this.fLabel;
    }

    public ImageDescriptor getImageDescriptor() {
        Bundle bundle;
        URL uRL;
        String string;
        if (this.fImageDescriptor == null && (string = this.fConfig.getAttribute("icon")) != null && (uRL = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)this.getPluginId())), (IPath)new Path(string), null)) != null) {
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        }
        return this.fImageDescriptor;
    }

    public IConsoleFactory createFactory() throws CoreException {
        if (this.fFactory == null) {
            this.fFactory = (IConsoleFactory)this.fConfig.createExecutableExtension("class");
        }
        return this.fFactory;
    }
}

