/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.internal.console.ConsoleView;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.internal.console.ShowConsoleAction;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

class ConsoleDropDownAction
extends Action
implements IMenuCreator,
IConsoleListener,
IUpdate {
    private IConsoleView fView;
    private Menu fMenu;

    public void update() {
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        this.setEnabled(iConsoleArray.length > 1);
    }

    public ConsoleDropDownAction(IConsoleView iConsoleView) {
        this.fView = iConsoleView;
        this.setText(ConsoleMessages.ConsoleDropDownAction_0);
        this.setToolTipText(ConsoleMessages.ConsoleDropDownAction_1);
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_VIEW_CONSOLE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IConsoleHelpContextIds.CONSOLE_DISPLAY_CONSOLE_ACTION);
        this.setMenuCreator(this);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(this);
        this.update();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
        ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this);
    }

    public Menu getMenu(Menu menu) {
        return null;
    }

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        IConsole iConsole = this.fView.getConsole();
        int n = 0;
        while (n < iConsoleArray.length) {
            IConsole iConsole2 = iConsoleArray[n];
            ShowConsoleAction showConsoleAction = new ShowConsoleAction(this.fView, iConsole2);
            showConsoleAction.setChecked(iConsole2.equals(iConsole));
            this.addActionToMenu(this.fMenu, showConsoleAction, n + 1);
            ++n;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu menu, Action action, int n) {
        StringBuffer stringBuffer;
        if (n < 10) {
            stringBuffer = new StringBuffer();
            stringBuffer.append('&');
            stringBuffer.append(n);
            stringBuffer.append(' ');
            stringBuffer.append(action.getText());
            action.setText(stringBuffer.toString());
        }
        stringBuffer = new ActionContributionItem((IAction)action);
        stringBuffer.fill(menu, -1);
    }

    public void run() {
        List list;
        ConsoleView consoleView = (ConsoleView)this.fView;
        boolean bl = consoleView.isPinned();
        if (bl) {
            consoleView.setPinned(false);
        }
        if ((list = consoleView.getConsoleStack()).size() > 1) {
            IConsole iConsole = (IConsole)list.get(1);
            this.fView.display(iConsole);
        }
        if (bl) {
            consoleView.setPinned(true);
        }
    }

    @Override
    public void consolesAdded(IConsole[] iConsoleArray) {
        UIJob uIJob = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                ConsoleDropDownAction.this.update();
                return Status.OK_STATUS;
            }
        };
        uIJob.setSystem(true);
        uIJob.setPriority(10);
        uIJob.schedule();
    }

    @Override
    public void consolesRemoved(IConsole[] iConsoleArray) {
        UIJob uIJob = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                if (ConsoleDropDownAction.this.fMenu != null) {
                    ConsoleDropDownAction.this.fMenu.dispose();
                }
                ConsoleDropDownAction.this.update();
                return Status.OK_STATUS;
            }
        };
        uIJob.setSystem(true);
        uIJob.setPriority(10);
        uIJob.schedule();
    }
}

