/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;

public class ConsoleDocumentAdapter
implements IDocumentAdapter,
IDocumentListener {
    private int consoleWidth = -1;
    private List textChangeListeners;
    private IDocument document;
    int[] offsets = new int[5000];
    int[] lengths = new int[5000];
    private int regionCount = 1;
    private Pattern pattern = Pattern.compile("$", 8);

    public ConsoleDocumentAdapter(int n) {
        this.textChangeListeners = new ArrayList();
        this.consoleWidth = n;
    }

    /*
     * Unable to fully structure code
     */
    private void repairLines(int var1_1) {
        if (this.document == null) {
            return;
        }
        try {
            var2_2 = this.document.getLineOfOffset(var1_1);
            var3_3 = this.document.getLineOffset(var2_2);
            var4_4 = this.getLineAtOffset(var3_3);
            var5_5 = this.regionCount - 1;
            while (var5_5 >= var4_4) {
                --this.regionCount;
                --var5_5;
            }
            var5_5 = this.document.getNumberOfLines();
            var6_6 = this.document.getLineOffset(var2_2);
            var7_7 = var2_2;
            while (var7_7 < var5_5) {
                block9: {
                    var8_8 = var6_6;
                    var9_9 = this.document.getLineLength(var7_7);
                    var6_6 += var9_9;
                    if (var9_9 != 0) ** GOTO lbl36
                    this.addRegion(var8_8, 0);
                    break block9;
lbl-1000:
                    // 1 sources

                    {
                        var10_10 = var9_9;
                        var11_11 = this.document.getLineDelimiter(var7_7);
                        var12_12 = 0;
                        if (var11_11 != null) {
                            var12_12 = var11_11.length();
                            var10_10 -= var12_12;
                        }
                        if (this.consoleWidth > 0 && this.consoleWidth < var10_10) {
                            this.addRegion(var8_8, this.consoleWidth);
                            var8_8 += this.consoleWidth;
                            var9_9 -= this.consoleWidth;
                            continue;
                        }
                        this.addRegion(var8_8, var9_9);
                        var8_8 += var9_9;
                        var9_9 -= var9_9;
lbl36:
                        // 3 sources

                        ** while (var9_9 > 0)
                    }
                }
                ++var7_7;
            }
        }
        catch (BadLocationException v0) {}
        if (this.regionCount == 0) {
            this.addRegion(0, this.document.getLength());
        }
    }

    private void addRegion(int n, int n2) {
        if (this.regionCount == 0) {
            this.offsets[0] = n;
            this.lengths[0] = n2;
        } else {
            if (this.regionCount == this.offsets.length) {
                this.growRegionArray(this.regionCount * 2);
            }
            this.offsets[this.regionCount] = n;
            this.lengths[this.regionCount] = n2;
        }
        ++this.regionCount;
    }

    public void setDocument(IDocument iDocument) {
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
        this.document = iDocument;
        if (this.document != null) {
            this.document.addDocumentListener((IDocumentListener)this);
            this.repairLines(0);
        }
    }

    public synchronized void addTextChangeListener(TextChangeListener textChangeListener) {
        Assert.isNotNull((Object)textChangeListener);
        if (!this.textChangeListeners.contains(textChangeListener)) {
            this.textChangeListeners.add(textChangeListener);
        }
    }

    public synchronized void removeTextChangeListener(TextChangeListener textChangeListener) {
        if (this.textChangeListeners != null) {
            Assert.isNotNull((Object)textChangeListener);
            this.textChangeListeners.remove(textChangeListener);
        }
    }

    public int getCharCount() {
        return this.document.getLength();
    }

    public String getLine(int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer(this.document.get(this.offsets[n], this.lengths[n]));
            int n2 = stringBuffer.length() - 1;
            while (n2 > -1 && (stringBuffer.charAt(n2) == '\n' || stringBuffer.charAt(n2) == '\r')) {
                --n2;
            }
            return new String(stringBuffer.substring(0, n2 + 1));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getLineAtOffset(int n) {
        if (n == 0 || this.regionCount <= 1) {
            return 0;
        }
        if (n == this.document.getLength()) {
            return this.regionCount - 1;
        }
        int n2 = 0;
        int n3 = this.regionCount - 1;
        int n4 = 0;
        while (n2 <= n3) {
            if (n2 == n3) {
                return n3;
            }
            n4 = (n2 + n3) / 2;
            if (n < this.offsets[n4]) {
                n3 = n4;
                continue;
            }
            if (n >= this.offsets[n4] + this.lengths[n4]) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return n4;
    }

    public int getLineCount() {
        return this.regionCount;
    }

    public String getLineDelimiter() {
        return System.getProperty("line.separator");
    }

    public int getOffsetAtLine(int n) {
        return this.offsets[n];
    }

    public String getTextRange(int n, int n2) {
        try {
            return this.document.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void replaceTextRange(int n, int n2, String string) {
        try {
            this.document.replace(n, n2, string);
        }
        catch (BadLocationException badLocationException) {}
    }

    public synchronized void setText(String string) {
        TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener textChangeListener : this.textChangeListeners) {
            textChangeListener.textSet(textChangedEvent);
        }
    }

    public synchronized void documentAboutToBeChanged(DocumentEvent documentEvent) {
        if (this.document == null) {
            return;
        }
        TextChangingEvent textChangingEvent = new TextChangingEvent((StyledTextContent)this);
        textChangingEvent.start = documentEvent.fOffset;
        textChangingEvent.newText = documentEvent.fText == null ? "" : documentEvent.fText;
        textChangingEvent.replaceCharCount = documentEvent.fLength;
        textChangingEvent.newCharCount = documentEvent.fText == null ? 0 : documentEvent.fText.length();
        int n = this.getLineAtOffset(documentEvent.fOffset);
        int n2 = Math.max(documentEvent.fOffset + documentEvent.fLength - 1, 0);
        int n3 = this.getLineAtOffset(n2);
        textChangingEvent.replaceLineCount = Math.max(n3 - n, 0);
        int n4 = this.countNewLines(documentEvent.fText);
        int n5 = textChangingEvent.newLineCount = n4 >= 0 ? n4 : 0;
        if (textChangingEvent.newLineCount > this.offsets.length - this.regionCount) {
            this.growRegionArray(textChangingEvent.newLineCount);
        }
        for (TextChangeListener textChangeListener : this.textChangeListeners) {
            textChangeListener.textChanging(textChangingEvent);
        }
    }

    private void growRegionArray(int n) {
        int n2 = Math.max(this.offsets.length * 2, n * 2);
        int[] nArray = new int[n2];
        System.arraycopy(this.offsets, 0, nArray, 0, this.regionCount);
        this.offsets = nArray;
        int[] nArray2 = new int[n2];
        System.arraycopy(this.lengths, 0, nArray2, 0, this.regionCount);
        this.lengths = nArray2;
    }

    private int countNewLines(String string) {
        int n = 0;
        if (string.length() == 0) {
            return 0;
        }
        int n2 = string.length() - 1;
        while (n2 > -1 && string.charAt(n2) == '\r') {
            --n2;
            ++n;
        }
        if (n2 > -1) {
            if (n2 < string.length() - 1) {
                string = string.substring(0, n2);
            }
            int n3 = 0;
            int n4 = 0;
            Matcher matcher = this.pattern.matcher(string);
            while (matcher.find()) {
                n4 = matcher.start();
                if (n4 == 0) {
                    ++n;
                } else if (n4 != string.length()) {
                    ++n;
                }
                if (this.consoleWidth > 0) {
                    int n5 = n4 - n3 + 1;
                    if (n4 == 0) {
                        n5 += this.lengths[this.regionCount - 1];
                    }
                    n += n5 / this.consoleWidth;
                }
                n3 = n4;
            }
        }
        return n;
    }

    public synchronized void documentChanged(DocumentEvent documentEvent) {
        if (this.document == null) {
            return;
        }
        this.repairLines(documentEvent.fOffset);
        TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener textChangeListener : this.textChangeListeners) {
            textChangeListener.textChanged(textChangedEvent);
        }
    }

    public void setWidth(int n) {
        if (n != this.consoleWidth) {
            this.consoleWidth = n;
            this.repairLines(0);
            TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
            for (TextChangeListener textChangeListener : this.textChangeListeners) {
                textChangeListener.textSet(textChangedEvent);
            }
        }
    }
}

